/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.presentation.slide;

import java.util.ArrayList;
import java.util.List;
import org.xmind.core.IAdaptable;
import org.xmind.core.IIdentifiable;
import org.xmind.core.IResourceRef;
import org.xmind.core.IWorkbook;
import org.xmind.core.IWorkbookExtension;
import org.xmind.core.IWorkbookExtensionElement;
import org.xmind.ui.internal.presentation.slide.PresentationStory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PresentationSlide {
    public static final String TYPE_TOPIC = "topic";
    public static final String TYPE_SUMMARY = "summary";
    public static final String TYPE_RELATIONSHIP = "relationship";
    public static final String TYPE_BOUNDARY = "boundary";
    private PresentationStory story;
    private IWorkbookExtensionElement element;
    private IResourceRef resourceRef;
    private String type;
    private List<IAdaptable> selections;
    private IAdaptable parent;

    public PresentationSlide(PresentationStory story, IWorkbookExtensionElement element) {
        this.story = story;
        this.element = element;
    }

    protected void init() {
        this.type = this.element.getAttribute("type");
        this.initSelections();
        this.initParent();
        this.initResourceRef();
    }

    private void initSelections() {
        this.selections = new ArrayList<IAdaptable>();
        IWorkbook wb = this.element.getOwnedWorkbook();
        for (IWorkbookExtensionElement e : this.element.getChildren("selection")) {
            Object o;
            if (e.getObjectId() == null || !((o = wb.getElementById(e.getObjectId())) instanceof IAdaptable)) continue;
            this.selections.add((IAdaptable)o);
        }
    }

    private void initParent() {
        IWorkbook wb;
        Object o;
        IWorkbookExtensionElement ele = (IWorkbookExtensionElement)this.element.getFirstChild("parent");
        if (ele != null && ele.getObjectId() != null && (o = (wb = this.element.getOwnedWorkbook()).getElementById(ele.getObjectId())) instanceof IAdaptable) {
            this.parent = (IAdaptable)o;
        }
    }

    private void initResourceRef() {
        String resourceId = this.element.getResourcePath();
        if (resourceId != null && !"".equals(resourceId)) {
            IWorkbookExtension ext = this.element.getExtension();
            this.resourceRef = ext.getResourceRef(resourceId);
        }
    }

    public IWorkbook getOwnedWorkbook() {
        return this.element.getOwnedWorkbook();
    }

    protected IWorkbookExtensionElement getElement() {
        return this.element;
    }

    public PresentationStory getStory() {
        return this.story;
    }

    public int getIndex() {
        return this.story.getSlideIndex(this);
    }

    protected void setSelections(List<IAdaptable> selections) {
        if (selections == null || selections.isEmpty()) {
            throw new IllegalArgumentException();
        }
        for (IAdaptable selection : selections) {
            IWorkbookExtensionElement selectionEle = (IWorkbookExtensionElement)this.element.createChild("selection");
            if (!(selection instanceof IIdentifiable)) continue;
            selectionEle.setObjectId(((IIdentifiable)selection).getId());
        }
        this.selections = selections;
    }

    public List<IAdaptable> getSelections() {
        return this.selections;
    }

    protected void setParent(IAdaptable parent) {
        if (!(parent instanceof IIdentifiable)) {
            throw new IllegalArgumentException();
        }
        IWorkbookExtensionElement parentEle = (IWorkbookExtensionElement)this.element.getFirstChild("parent");
        if (parentEle == null) {
            parentEle = (IWorkbookExtensionElement)this.element.createChild("parent");
        }
        parentEle.setObjectId(((IIdentifiable)parent).getId());
        this.parent = parent;
    }

    public IAdaptable getParent() {
        return this.parent;
    }

    public void setType(String type) {
        if (type == null || "".equals(type)) {
            throw new IllegalArgumentException();
        }
        this.type = type;
        this.element.setAttribute("type", type);
    }

    public String getType() {
        return this.type;
    }

    public void setResourceRef(IResourceRef ref) {
        String resourceId = ref.getResourceId();
        if (resourceId != null && !"".equals(resourceId)) {
            this.element.setResourcePath(resourceId);
        }
        this.resourceRef = ref;
    }

    public IResourceRef getResourceRef() {
        return this.resourceRef;
    }
}

