/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.presentation.slide;

import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.xmind.gef.ui.editor.IGraphicalEditor;
import org.xmind.ui.internal.editor.IEditorLayout;
import org.xmind.ui.internal.editor.IEditorLayoutManager;
import org.xmind.ui.internal.presentation.slide.PresentationStory;
import org.xmind.ui.internal.presentation.slide.PresentationStoryEditCover;

public class PresentationEditorLayout
implements IEditorLayout {
    private static final String SLIDE_BASE_MODE = "isSlideBaseMode";
    private IEditorLayoutManager layoutManager;
    private PresentationStory story;
    private ISelectionProvider selectionProvider;
    private Layout layout = null;
    private PresentationStoryEditCover cover;
    private IGraphicalEditor editor;

    public PresentationEditorLayout(IEditorLayoutManager layoutManager, PresentationStory story, IGraphicalEditor editor) {
        this.layoutManager = layoutManager;
        this.story = story;
        this.editor = editor;
    }

    public void setSelectionProvider(ISelectionProvider selectionProvider) {
        this.selectionProvider = selectionProvider;
    }

    public PresentationStory getCurrentStory() {
        return this.story;
    }

    public void setCurrentStory(PresentationStory story) {
        this.story = story;
        this.cover.setCurrentStory(story);
    }

    public void activate(Composite parent) {
        this.cover = new PresentationStoryEditCover(parent, this.story, this.layoutManager, this.editor, this.selectionProvider);
        this.cover.create();
        this.layout = this.cover.getParentLayout();
        this.selectionProvider.addSelectionChangedListener((ISelectionChangedListener)this.cover);
        this.editor.getActivePageInstance().getControl().getShell().setData(SLIDE_BASE_MODE, (Object)true);
    }

    public void deactivate(Composite parent) {
        this.editor.getActivePageInstance().getControl().getShell().setData(SLIDE_BASE_MODE, (Object)false);
        this.selectionProvider.removeSelectionChangedListener((ISelectionChangedListener)this.cover);
        this.cover.dispose();
    }

    public Layout getSWTLayout() {
        return this.layout;
    }
}

