/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.pqc.math.ntru.polynomial;

import org.bouncycastle.pqc.math.ntru.polynomial.IntegerPolynomial;
import org.bouncycastle.util.Arrays;

public class LongPolynomial2 {
    private long[] coeffs;
    private int numCoeffs;

    public LongPolynomial2(IntegerPolynomial p) {
        this.numCoeffs = p.coeffs.length;
        this.coeffs = new long[(this.numCoeffs + 1) / 2];
        int idx = 0;
        int pIdx = 0;
        while (pIdx < this.numCoeffs) {
            int c0 = p.coeffs[pIdx++];
            while (c0 < 0) {
                c0 += 2048;
            }
            long c1 = pIdx < this.numCoeffs ? p.coeffs[pIdx++] : 0;
            while (c1 < 0L) {
                c1 += 2048L;
            }
            this.coeffs[idx] = (long)c0 + (c1 << 24);
            ++idx;
        }
    }

    private LongPolynomial2(long[] coeffs) {
        this.coeffs = coeffs;
    }

    private LongPolynomial2(int N) {
        this.coeffs = new long[N];
    }

    public LongPolynomial2 mult(LongPolynomial2 poly2) {
        int N = this.coeffs.length;
        if (poly2.coeffs.length != N || this.numCoeffs != poly2.numCoeffs) {
            throw new IllegalArgumentException("Number of coefficients must be the same");
        }
        LongPolynomial2 c = this.multRecursive(poly2);
        if (c.coeffs.length > N) {
            if (this.numCoeffs % 2 == 0) {
                int k = N;
                while (k < c.coeffs.length) {
                    c.coeffs[k - N] = c.coeffs[k - N] + c.coeffs[k] & 0x7FF0007FFL;
                    ++k;
                }
                c.coeffs = Arrays.copyOf(c.coeffs, N);
            } else {
                int k = N;
                while (k < c.coeffs.length) {
                    c.coeffs[k - N] = c.coeffs[k - N] + (c.coeffs[k - 1] >> 24);
                    c.coeffs[k - N] = c.coeffs[k - N] + ((c.coeffs[k] & 0x7FFL) << 24);
                    int n = k - N;
                    c.coeffs[n] = c.coeffs[n] & 0x7FF0007FFL;
                    ++k;
                }
                c.coeffs = Arrays.copyOf(c.coeffs, N);
                int n = c.coeffs.length - 1;
                c.coeffs[n] = c.coeffs[n] & 0x7FFL;
            }
        }
        c = new LongPolynomial2(c.coeffs);
        c.numCoeffs = this.numCoeffs;
        return c;
    }

    public IntegerPolynomial toIntegerPolynomial() {
        int[] intCoeffs = new int[this.numCoeffs];
        int uIdx = 0;
        int i = 0;
        while (i < this.coeffs.length) {
            intCoeffs[uIdx++] = (int)(this.coeffs[i] & 0x7FFL);
            if (uIdx < this.numCoeffs) {
                intCoeffs[uIdx++] = (int)(this.coeffs[i] >> 24 & 0x7FFL);
            }
            ++i;
        }
        return new IntegerPolynomial(intCoeffs);
    }

    private LongPolynomial2 multRecursive(LongPolynomial2 poly2) {
        long[] a = this.coeffs;
        long[] b = poly2.coeffs;
        int n = poly2.coeffs.length;
        if (n <= 32) {
            int cn = 2 * n;
            LongPolynomial2 c = new LongPolynomial2(new long[cn]);
            int k = 0;
            while (k < cn) {
                int i = Math.max(0, k - n + 1);
                while (i <= Math.min(k, n - 1)) {
                    long c0 = a[k - i] * b[i];
                    long cu = c0 & 0x7FF000000L + (c0 & 0x7FFL);
                    long co = c0 >>> 48 & 0x7FFL;
                    c.coeffs[k] = c.coeffs[k] + cu & 0x7FF0007FFL;
                    c.coeffs[k + 1] = c.coeffs[k + 1] + co & 0x7FF0007FFL;
                    ++i;
                }
                ++k;
            }
            return c;
        }
        int n1 = n / 2;
        LongPolynomial2 a1 = new LongPolynomial2(Arrays.copyOf(a, n1));
        LongPolynomial2 a2 = new LongPolynomial2(Arrays.copyOfRange(a, n1, n));
        LongPolynomial2 b1 = new LongPolynomial2(Arrays.copyOf(b, n1));
        LongPolynomial2 b2 = new LongPolynomial2(Arrays.copyOfRange(b, n1, n));
        LongPolynomial2 A = (LongPolynomial2)a1.clone();
        A.add(a2);
        LongPolynomial2 B = (LongPolynomial2)b1.clone();
        B.add(b2);
        LongPolynomial2 c1 = a1.multRecursive(b1);
        LongPolynomial2 c2 = a2.multRecursive(b2);
        LongPolynomial2 c3 = A.multRecursive(B);
        c3.sub(c1);
        c3.sub(c2);
        LongPolynomial2 c = new LongPolynomial2(2 * n);
        int i = 0;
        while (i < c1.coeffs.length) {
            c.coeffs[i] = c1.coeffs[i] & 0x7FF0007FFL;
            ++i;
        }
        i = 0;
        while (i < c3.coeffs.length) {
            c.coeffs[n1 + i] = c.coeffs[n1 + i] + c3.coeffs[i] & 0x7FF0007FFL;
            ++i;
        }
        i = 0;
        while (i < c2.coeffs.length) {
            c.coeffs[2 * n1 + i] = c.coeffs[2 * n1 + i] + c2.coeffs[i] & 0x7FF0007FFL;
            ++i;
        }
        return c;
    }

    private void add(LongPolynomial2 b) {
        if (b.coeffs.length > this.coeffs.length) {
            this.coeffs = Arrays.copyOf(this.coeffs, b.coeffs.length);
        }
        int i = 0;
        while (i < b.coeffs.length) {
            this.coeffs[i] = this.coeffs[i] + b.coeffs[i] & 0x7FF0007FFL;
            ++i;
        }
    }

    private void sub(LongPolynomial2 b) {
        if (b.coeffs.length > this.coeffs.length) {
            this.coeffs = Arrays.copyOf(this.coeffs, b.coeffs.length);
        }
        int i = 0;
        while (i < b.coeffs.length) {
            this.coeffs[i] = 0x800000800000L + this.coeffs[i] - b.coeffs[i] & 0x7FF0007FFL;
            ++i;
        }
    }

    public void subAnd(LongPolynomial2 b, int mask) {
        long longMask = ((long)mask << 24) + (long)mask;
        int i = 0;
        while (i < b.coeffs.length) {
            this.coeffs[i] = 0x800000800000L + this.coeffs[i] - b.coeffs[i] & longMask;
            ++i;
        }
    }

    public void mult2And(int mask) {
        long longMask = ((long)mask << 24) + (long)mask;
        int i = 0;
        while (i < this.coeffs.length) {
            this.coeffs[i] = this.coeffs[i] << 1 & longMask;
            ++i;
        }
    }

    public Object clone() {
        LongPolynomial2 p = new LongPolynomial2((long[])this.coeffs.clone());
        p.numCoeffs = this.numCoeffs;
        return p;
    }

    public boolean equals(Object obj) {
        if (obj instanceof LongPolynomial2) {
            return Arrays.areEqual(this.coeffs, ((LongPolynomial2)obj).coeffs);
        }
        return false;
    }
}

