/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.mindmap.merging;

import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import net.xmind.verify.ui.VerifyUI20141031;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.ui.IEditorPart;
import org.xmind.gef.command.ICommandStack;
import org.xmind.ui.internal.MindMapUIPlugin;
import org.xmind.ui.internal.handlers.MindMapHandlerUtil;
import org.xmind.ui.internal.mindmap.merging.MapChooseDialog;
import org.xmind.ui.internal.mindmap.merging.MergeCommandBuilder;
import org.xmind.ui.internal.mindmap.merging.MergeMessages;
import org.xmind.ui.internal.mindmap.merging.MergeOutputDialog;
import org.xmind.ui.mindmap.IMindMap;

public class MergeHandler
extends AbstractHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        final IEditorPart editor = MindMapHandlerUtil.findContributingEditor((ExecutionEvent)event);
        if (editor == null) {
            return null;
        }
        VerifyUI20141031.runAction20141031((String)"MergeMaps", (String)MergeMessages.MergeAction_name, (int)7, (Runnable)new Runnable(){

            public void run() {
                MergeHandler.this.merge(editor);
                VerifyUI20141031.getUsageDataCollector().increase("MergeMapsCount");
            }
        }, null);
        return null;
    }

    private void merge(IEditorPart editor) {
        IMindMap targetMap = (IMindMap)MindMapUIPlugin.getAdapter((Object)editor, IMindMap.class);
        if (targetMap == null) {
            return;
        }
        ICommandStack commandStack = (ICommandStack)MindMapUIPlugin.getAdapter((Object)editor, ICommandStack.class);
        if (commandStack == null) {
            return;
        }
        MapChooseDialog dialog = new MapChooseDialog(editor.getSite().getShell(), editor.getSite().getWorkbenchWindow().getWorkbench(), targetMap);
        int retCode = dialog.open();
        if (retCode != 0) {
            return;
        }
        String output = this.merge(dialog.getSourceMap(), targetMap, commandStack);
        new MergeOutputDialog(editor.getSite().getShell(), output).open();
    }

    private String merge(IMindMap sourceMap, IMindMap targetMap, ICommandStack commandStack) {
        PrintStream ps;
        ByteArrayOutputStream bytes = new ByteArrayOutputStream();
        try {
            ps = new PrintStream((OutputStream)bytes, false, "UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            ps = new PrintStream(bytes, false);
        }
        MergeCommandBuilder builder = new MergeCommandBuilder(commandStack, sourceMap, targetMap);
        builder.setLabel(MergeMessages.Command_MergeMap);
        builder.setLogHandle(ps);
        if (builder.canStart()) {
            builder.start();
            builder.end();
        }
        ps.close();
        try {
            return bytes.toString("UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return bytes.toString();
        }
    }
}

