/*
 * Decompiled with CFR 0.152.
 */
package com.evernote.clients;

import com.evernote.edam.error.EDAMNotFoundException;
import com.evernote.edam.error.EDAMSystemException;
import com.evernote.edam.error.EDAMUserException;
import com.evernote.edam.type.PremiumInfo;
import com.evernote.edam.type.User;
import com.evernote.edam.userstore.AuthenticationResult;
import com.evernote.edam.userstore.BootstrapInfo;
import com.evernote.edam.userstore.PublicUserInfo;
import com.evernote.edam.userstore.UserStore;
import com.evernote.thrift.TException;
import com.evernote.thrift.protocol.TProtocol;

public class UserStoreClient {
    private final String token;
    private final UserStore.Client client;

    UserStoreClient(TProtocol prot, String token) {
        if (prot == null || token == null) {
            throw new IllegalArgumentException("TProtocol and Token must not be null.");
        }
        this.client = new UserStore.Client(prot);
        this.token = token;
    }

    UserStoreClient(TProtocol iprot, TProtocol oprot, String token) {
        if (iprot == null || oprot == null || token == null) {
            throw new IllegalArgumentException("TProtocol and Token must not be null.");
        }
        this.client = new UserStore.Client(iprot, oprot);
        this.token = token;
    }

    UserStore.Client getClient() {
        return this.client;
    }

    String getToken() {
        return this.token;
    }

    public boolean isBusinessUser() throws TException, EDAMUserException, EDAMSystemException {
        return this.getClient().getUser(this.getToken()).isSetBusinessUserInfo();
    }

    public boolean checkVersion(String clientName, short edamVersionMajor, short edamVersionMinor) throws TException {
        return this.getClient().checkVersion(clientName, edamVersionMajor, edamVersionMinor);
    }

    public BootstrapInfo getBootstrapInfo(String locale) throws TException {
        return this.getClient().getBootstrapInfo(locale);
    }

    public AuthenticationResult authenticate(String username, String password, String consumerKey, String consumerSecret, boolean supportsTwoFactor) throws EDAMUserException, EDAMSystemException, TException {
        return this.getClient().authenticate(username, password, consumerKey, consumerSecret, supportsTwoFactor);
    }

    public AuthenticationResult authenticateLongSession(String username, String password, String consumerKey, String consumerSecret, String deviceIdentifier, String deviceDescription, boolean supportsTwoFactor) throws EDAMUserException, EDAMSystemException, TException {
        return this.getClient().authenticateLongSession(username, password, consumerKey, consumerSecret, deviceIdentifier, deviceDescription, supportsTwoFactor);
    }

    public AuthenticationResult authenticateToBusiness() throws EDAMUserException, EDAMSystemException, TException {
        return this.getClient().authenticateToBusiness(this.getToken());
    }

    public AuthenticationResult refreshAuthentication() throws EDAMUserException, EDAMSystemException, TException {
        return this.getClient().refreshAuthentication(this.getToken());
    }

    public User getUser() throws EDAMUserException, EDAMSystemException, TException {
        return this.getClient().getUser(this.getToken());
    }

    public PublicUserInfo getPublicUserInfo(String username) throws EDAMNotFoundException, EDAMSystemException, EDAMUserException, TException {
        return this.getClient().getPublicUserInfo(username);
    }

    public PremiumInfo getPremiumInfo() throws EDAMUserException, EDAMSystemException, TException {
        return this.getClient().getPremiumInfo(this.getToken());
    }

    public String getNoteStoreUrl() throws EDAMUserException, EDAMSystemException, TException {
        return this.getClient().getNoteStoreUrl(this.getToken());
    }

    public void revokeLongSession() throws EDAMUserException, EDAMSystemException, TException {
        this.getClient().revokeLongSession(this.getToken());
    }

    public void completeTwoFactorAuthentication(String authenticationToken, String oneTimeCode, String deviceIdentifier, String deviceDescription) throws EDAMUserException, EDAMSystemException, TException {
        this.getClient().completeTwoFactorAuthentication(authenticationToken, oneTimeCode, deviceIdentifier, deviceDescription);
    }
}

