/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.core.command.transfer;

import java.io.Closeable;
import java.io.FilterOutputStream;
import java.io.Flushable;
import java.io.IOException;
import java.io.OutputStream;

public class ChunkWriter
implements Closeable,
Flushable {
    private static final byte DEFAULT_CHUNK_SEPARATOR = 10;
    private static final String DEFAULT_TEXT_ENCODING = "UTF-8";
    private static final int DEFAULT_BUFFER_SIZE = 16;
    private static final int DEFAULT_BINARY_BUFFER_SIZE = 12;
    private static final byte[] intToBase64 = new byte[]{65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 97, 98, 99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 43, 47};
    private OutputStream out;
    private String textEncoding;
    private byte separator;
    private ChunkOutputStream binaryStream = null;
    private byte[] binaryBuffer = new byte[12];
    private int binaryBuffered = 0;
    private byte[] buffer = new byte[16];
    private int buffered = 0;

    public ChunkWriter(OutputStream out) {
        this(out, 10, DEFAULT_TEXT_ENCODING);
    }

    public ChunkWriter(OutputStream out, byte chunkSeparator, String textEncoding) {
        this.out = out;
        this.separator = chunkSeparator;
        this.textEncoding = textEncoding;
    }

    public synchronized void writeText(String text) throws IOException {
        this.closeBinaryStream();
        if (text == null) {
            text = "";
        }
        byte[] bytes = text.getBytes(this.textEncoding);
        this.out.write(bytes);
        this.out.write(this.separator);
        this.out.flush();
    }

    public synchronized OutputStream openNextChunkAsStream() throws IOException {
        this.closeBinaryStream();
        this.binaryStream = new ChunkOutputStream(this.out);
        return this.binaryStream;
    }

    public synchronized void close() throws IOException {
        this.closeBinaryStream();
        try {
            this.out.flush();
        }
        finally {
            this.out.close();
        }
    }

    public synchronized void flush() throws IOException {
        this.flushBinaryBuffer(false);
        this.flushBuffer();
        this.out.flush();
    }

    private synchronized void closeBinaryStream() throws IOException {
        if (this.binaryStream != null && !this.binaryStream.closed) {
            this.binaryStream.close();
            this.binaryStream = null;
        }
    }

    private synchronized void appendToBuffer(byte b) throws IOException {
        this.binaryBuffer[this.binaryBuffered++] = b;
        if (this.binaryBuffered >= this.binaryBuffer.length) {
            int off = 0;
            while (off < this.binaryBuffered) {
                int b0 = this.binaryBuffer[off++] & 0xFF;
                int b1 = off >= this.binaryBuffered ? -1 : this.binaryBuffer[off++] & 0xFF;
                int b2 = off >= this.binaryBuffered ? -1 : this.binaryBuffer[off++] & 0xFF;
                this.writeBinary(b0, b1, b2);
            }
            this.binaryBuffered = 0;
        }
    }

    private synchronized void writeBinary(int b0, int b1, int b2) throws IOException {
        this.buffer[this.buffered++] = intToBase64[b0 >> 2];
        if (b1 < 0) {
            this.buffer[this.buffered++] = intToBase64[b0 << 4 & 0x3F];
            this.buffer[this.buffered++] = 61;
            this.buffer[this.buffered++] = 61;
        } else {
            this.buffer[this.buffered++] = intToBase64[b0 << 4 & 0x3F | b1 >> 4];
            if (b2 < 0) {
                this.buffer[this.buffered++] = intToBase64[b1 << 2 & 0x3F];
                this.buffer[this.buffered++] = 61;
            } else {
                this.buffer[this.buffered++] = intToBase64[b1 << 2 & 0x3F | b2 >> 6];
                this.buffer[this.buffered++] = intToBase64[b2 & 0x3F];
            }
        }
        if (this.buffered >= this.buffer.length || b2 < 0) {
            try {
                this.out.write(this.buffer, 0, this.buffered);
            }
            finally {
                this.buffered = 0;
            }
        }
    }

    private synchronized void flushBinaryBuffer(boolean all) throws IOException {
        if (this.binaryBuffered > 0) {
            int off = 0;
            int max = all ? this.binaryBuffered : this.binaryBuffered - 2;
            while (off < max) {
                int b0 = this.binaryBuffer[off++] & 0xFF;
                int b1 = off >= this.binaryBuffered ? -1 : this.binaryBuffer[off++] & 0xFF;
                int b2 = off >= this.binaryBuffered ? -1 : this.binaryBuffer[off++] & 0xFF;
                this.writeBinary(b0, b1, b2);
            }
            int newCount = this.binaryBuffered - off;
            if (newCount > 0) {
                System.arraycopy(this.binaryBuffer, off, this.binaryBuffer, 0, newCount);
            }
            this.binaryBuffered = newCount;
        }
    }

    private synchronized void flushBuffer() throws IOException {
        if (this.buffered > 0) {
            try {
                this.out.write(this.buffer, 0, this.buffered);
            }
            finally {
                this.buffered = 0;
            }
        }
    }

    private class ChunkOutputStream
    extends FilterOutputStream {
        private boolean closed;

        public ChunkOutputStream(OutputStream out) {
            super(out);
            this.closed = false;
        }

        public void close() throws IOException {
            ChunkWriter.this.flushBinaryBuffer(true);
            ChunkWriter.this.flushBuffer();
            if (!this.closed) {
                this.out.write(ChunkWriter.this.separator);
                this.out.flush();
            }
            this.closed = true;
        }

        public void write(byte[] b) throws IOException {
            this.write(b, 0, b.length);
        }

        public void write(byte[] b, int off, int len) throws IOException {
            if (this.closed) {
                throw new IOException("Stream already closed.");
            }
            int i = 0;
            while (i < len) {
                ChunkWriter.this.appendToBuffer(b[off + i]);
                ++i;
            }
        }

        public void write(int b) throws IOException {
            if (this.closed) {
                throw new IOException("Stream already closed.");
            }
            ChunkWriter.this.appendToBuffer((byte)(b & 0xFF));
        }

        public void flush() throws IOException {
            ChunkWriter.this.flushBinaryBuffer(false);
            ChunkWriter.this.flushBuffer();
            this.out.flush();
        }
    }
}

