/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.browser;

import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.xmind.ui.internal.browser.BrowserMessages;
import org.xmind.ui.internal.browser.BrowserPref;
import org.xmind.ui.internal.browser.BrowserUtil;

public class BrowserPrefPage
extends PreferencePage
implements IWorkbenchPreferencePage {
    private Button internal;
    private Button external;

    protected Control createContents(Composite parent) {
        this.initializeDialogUnits((Control)parent);
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.horizontalSpacing = this.convertHorizontalDLUsToPixels(4);
        layout.verticalSpacing = this.convertVerticalDLUsToPixels(3);
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        composite.setLayout((Layout)layout);
        GridData data = new GridData(4, 4, true, false);
        composite.setLayoutData((Object)data);
        Label label = new Label(composite, 64);
        label.setText(BrowserMessages.BrowserPrefPage_description);
        data = new GridData(4, 0, false, false);
        data.horizontalSpan = 2;
        data.widthHint = 275;
        label.setLayoutData((Object)data);
        this.internal = new Button(composite, 16);
        this.internal.setText(BrowserMessages.BrowserPrefPage_InternalBrowser_text);
        data = new GridData(4, 0, true, false);
        data.horizontalSpan = 2;
        this.internal.setLayoutData((Object)data);
        if (!BrowserUtil.canUseInternalWebBrowser()) {
            this.internal.setEnabled(false);
        }
        this.external = new Button(composite, 16);
        this.external.setText(BrowserMessages.BrowserPrefPage_ExternalBrowser_text);
        data = new GridData(4, 0, true, false);
        data.horizontalSpan = 2;
        this.external.setLayoutData((Object)data);
        this.internal.setSelection(BrowserPref.getBrowserChoice() == 1);
        this.external.setSelection(BrowserPref.getBrowserChoice() == 0);
        Dialog.applyDialogFont((Control)composite);
        return composite;
    }

    public void init(IWorkbench workbench) {
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (visible) {
            this.setTitle(BrowserMessages.BrowserPrefPage_title);
        }
    }

    protected void performDefaults() {
        this.internal.setSelection(!BrowserPref.isDefaultUseSystemBrowser());
        this.external.setSelection(BrowserPref.isDefaultUseSystemBrowser());
        super.performDefaults();
    }

    public boolean performOk() {
        int choice = this.internal.getSelection() ? 1 : 0;
        BrowserPref.setBrowserChoice(choice);
        return true;
    }
}

