/*
 * Decompiled with CFR 0.152.
 */
package com.apple.dnssd;

import com.apple.dnssd.AppleBrowser;
import com.apple.dnssd.AppleDNSSDException;
import com.apple.dnssd.AppleDomainEnum;
import com.apple.dnssd.AppleQuery;
import com.apple.dnssd.AppleRecordRegistrar;
import com.apple.dnssd.AppleRegistration;
import com.apple.dnssd.AppleResolver;
import com.apple.dnssd.BrowseListener;
import com.apple.dnssd.DNSSD;
import com.apple.dnssd.DNSSDException;
import com.apple.dnssd.DNSSDRecordRegistrar;
import com.apple.dnssd.DNSSDRegistration;
import com.apple.dnssd.DNSSDService;
import com.apple.dnssd.DomainListener;
import com.apple.dnssd.QueryListener;
import com.apple.dnssd.RegisterListener;
import com.apple.dnssd.RegisterRecordListener;
import com.apple.dnssd.ResolveListener;
import com.apple.dnssd.TXTRecord;

class AppleDNSSD
extends DNSSD {
    public static boolean hasAutoCallbacks;

    static {
        System.loadLibrary("jdns_sd");
        int libInitResult = AppleDNSSD.InitLibrary(2);
        if (libInitResult != 0) {
            throw new InternalError("cannot instantiate DNSSD: " + new AppleDNSSDException(libInitResult).getMessage());
        }
    }

    AppleDNSSD() {
    }

    protected DNSSDService _makeBrowser(int flags, int ifIndex, String regType, String domain, BrowseListener client) throws DNSSDException {
        return new AppleBrowser(flags, ifIndex, regType, domain, client);
    }

    protected DNSSDService _resolve(int flags, int ifIndex, String serviceName, String regType, String domain, ResolveListener client) throws DNSSDException {
        return new AppleResolver(flags, ifIndex, serviceName, regType, domain, client);
    }

    protected DNSSDRegistration _register(int flags, int ifIndex, String serviceName, String regType, String domain, String host, int port, TXTRecord txtRecord, RegisterListener client) throws DNSSDException {
        return new AppleRegistration(flags, ifIndex, serviceName, regType, domain, host, port, txtRecord != null ? txtRecord.getRawBytes() : null, client);
    }

    protected DNSSDRecordRegistrar _createRecordRegistrar(RegisterRecordListener listener) throws DNSSDException {
        return new AppleRecordRegistrar(listener);
    }

    protected DNSSDService _queryRecord(int flags, int ifIndex, String serviceName, int rrtype, int rrclass, QueryListener client) throws DNSSDException {
        return new AppleQuery(flags, ifIndex, serviceName, rrtype, rrclass, client);
    }

    protected DNSSDService _enumerateDomains(int flags, int ifIndex, DomainListener listener) throws DNSSDException {
        return new AppleDomainEnum(flags, ifIndex, listener);
    }

    protected String _constructFullName(String serviceName, String regType, String domain) throws DNSSDException {
        String[] responseHolder = new String[1];
        int rc = this.ConstructName(serviceName, regType, domain, responseHolder);
        if (rc != 0) {
            throw new AppleDNSSDException(rc);
        }
        return responseHolder[0];
    }

    protected void _reconfirmRecord(int flags, int ifIndex, String fullName, int rrtype, int rrclass, byte[] rdata) {
        this.ReconfirmRecord(flags, ifIndex, fullName, rrtype, rrclass, rdata);
    }

    protected String _getNameForIfIndex(int ifIndex) {
        return this.GetNameForIfIndex(ifIndex);
    }

    protected int _getIfIndexForName(String ifName) {
        return this.GetIfIndexForName(ifName);
    }

    protected native int ConstructName(String var1, String var2, String var3, String[] var4);

    protected native void ReconfirmRecord(int var1, int var2, String var3, int var4, int var5, byte[] var6);

    protected native String GetNameForIfIndex(int var1);

    protected native int GetIfIndexForName(String var1);

    protected static native int InitLibrary(int var0);
}

