/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.mindmap.filtering;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import net.xmind.verify.ui.VerifyUI20141031;
import org.xmind.ui.internal.mindmap.filtering.IPropertyFilterListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class PropertyFilter {
    protected static final Collection<Object> EMPTY = Collections.emptySet();
    private Collection<Object> availableProperties;
    private List<IPropertyFilterListener> listeners;

    protected abstract Collection<? extends Object> getProperties(Object var1);

    public Object[] getFilteredElements(Object[] elements) {
        ArrayList<Object> list = new ArrayList<Object>(elements.length);
        Object[] objectArray = elements;
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            Object element = objectArray[n2];
            if (this.passes(element)) {
                list.add(element);
            }
            ++n2;
        }
        return list.toArray();
    }

    public boolean passes(Object element) {
        if (!this.hasFilter()) {
            return true;
        }
        Collection<? extends Object> elementProperties = this.getProperties(element);
        return this.passesProperties(element, elementProperties, this.availableProperties);
    }

    protected boolean passesProperties(Object element, Collection<? extends Object> elementProperties, Collection<Object> availableProperties) {
        return PropertyFilter.hasElementsInCommon(elementProperties, availableProperties);
    }

    protected static boolean hasElementsInCommon(Collection<? extends Object> c1, Collection<? extends Object> c2) {
        if (c1.size() > c2.size()) {
            Collection<? extends Object> collection = c1;
            c1 = c2;
            c2 = collection;
        }
        for (Object object : c1) {
            if (!c2.contains(object)) continue;
            return true;
        }
        return false;
    }

    public boolean hasFilter() {
        return this.hasAvailableProperties();
    }

    public boolean isSingleFilter() {
        return this.availableProperties != null && this.availableProperties.size() == 1;
    }

    protected final boolean hasAvailableProperties() {
        return this.availableProperties != null && !this.availableProperties.isEmpty();
    }

    public Collection<Object> getPropertyFilters() {
        if (this.availableProperties == null) {
            return EMPTY;
        }
        return this.availableProperties;
    }

    public boolean hasFilter(Object property) {
        return this.availableProperties != null && this.availableProperties.contains(property);
    }

    public void addPropertyFilter(Object property) {
        boolean added;
        if (property == null) {
            return;
        }
        if (this.availableProperties == null) {
            this.availableProperties = new HashSet<Object>();
        }
        if (added = this.availableProperties.add(property)) {
            this.fireFilterChanged();
            VerifyUI20141031.getUsageDataCollector().increase("FilterOperationCount");
        }
    }

    public void removePropertyFilter(Object property) {
        if (property == null) {
            return;
        }
        if (this.availableProperties == null || this.availableProperties.isEmpty()) {
            return;
        }
        boolean removed = this.availableProperties.remove(property);
        if (removed) {
            this.fireFilterChanged();
        }
    }

    public void removeAllPropertyFilters() {
        if (this.availableProperties == null || this.availableProperties.isEmpty()) {
            return;
        }
        this.availableProperties.clear();
        this.fireFilterChanged();
    }

    public void addPropertyFilterListener(IPropertyFilterListener listener) {
        if (this.listeners == null) {
            this.listeners = new ArrayList<IPropertyFilterListener>();
        }
        this.listeners.add(listener);
    }

    public void removePropertyFilterListener(IPropertyFilterListener listener) {
        if (this.listeners == null) {
            return;
        }
        this.listeners.remove(listener);
    }

    protected void fireFilterChanged() {
        if (this.listeners == null) {
            return;
        }
        Object[] objectArray = this.listeners.toArray();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object o = objectArray[n2];
            ((IPropertyFilterListener)o).filterChanged(this);
            ++n2;
        }
    }
}

