/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.mindmap.filtering;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.xmind.core.ITopic;
import org.xmind.core.event.CoreEvent;
import org.xmind.core.event.CoreEventRegister;
import org.xmind.core.event.ICoreEventListener;
import org.xmind.core.event.ICoreEventRegister;
import org.xmind.gef.IGraphicalViewer;
import org.xmind.gef.part.IGraphicalPart;
import org.xmind.gef.service.GraphicalViewerService;
import org.xmind.ui.internal.mindmap.filtering.AssigneeFilter;
import org.xmind.ui.internal.mindmap.filtering.IPropertyFilterListener;
import org.xmind.ui.internal.mindmap.filtering.LabelFilter;
import org.xmind.ui.internal.mindmap.filtering.MarkerFilter;
import org.xmind.ui.internal.mindmap.filtering.PropertyFilter;
import org.xmind.ui.mindmap.IBranchPart;
import org.xmind.ui.mindmap.IHighlightService;
import org.xmind.ui.mindmap.ISheetPart;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FilterService
extends GraphicalViewerService
implements IPropertyFilterListener,
ICoreEventListener {
    private static final int LIGHTER_ALPHA = 80;
    private static final int DARKER_ALPHA = 176;
    private MarkerFilter markerFilter;
    private LabelFilter labelFilter;
    private AssigneeFilter assigneeFilter;
    private boolean scheduling = false;
    private boolean darker = false;
    private List<IPropertyFilterListener> listeners;
    private ICoreEventRegister register;

    public FilterService(IGraphicalViewer viewer) {
        super(viewer);
    }

    protected void activate() {
    }

    protected void deactivate() {
        if (this.register != null) {
            this.register.unregisterAll();
            this.register = null;
        }
    }

    public MarkerFilter getMarkerFilter() {
        if (this.markerFilter == null) {
            this.markerFilter = new MarkerFilter();
            this.markerFilter.addPropertyFilterListener(this);
        }
        return this.markerFilter;
    }

    public LabelFilter getLabelFilter() {
        if (this.labelFilter == null) {
            this.labelFilter = new LabelFilter();
            this.labelFilter.addPropertyFilterListener(this);
        }
        return this.labelFilter;
    }

    public AssigneeFilter getAssigneeFilter() {
        if (this.assigneeFilter == null) {
            this.assigneeFilter = new AssigneeFilter();
            this.assigneeFilter.addPropertyFilterListener(this);
        }
        return this.assigneeFilter;
    }

    public void removeAllFilters() {
        if (this.markerFilter != null) {
            this.markerFilter.removeAllPropertyFilters();
        }
        if (this.labelFilter != null) {
            this.labelFilter.removeAllPropertyFilters();
        }
        if (this.assigneeFilter != null) {
            this.assigneeFilter.removeAllPropertyFilters();
        }
    }

    public boolean isSingleFilter() {
        return this.isSingleFilter(this.labelFilter, null, this.markerFilter, this.assigneeFilter) || this.isSingleFilter(this.markerFilter, null, this.labelFilter, this.assigneeFilter) || this.isSingleFilter(this.assigneeFilter, null, this.labelFilter, this.markerFilter);
    }

    public boolean isSingleFilter(PropertyFilter filter, Object property) {
        return this.isSingleFilter(filter, property, this.getDetailFilter(filter));
    }

    private PropertyFilter getDetailFilter(PropertyFilter filter) {
        if (filter == this.labelFilter) {
            return this.labelFilter;
        }
        if (filter == this.markerFilter) {
            return this.markerFilter;
        }
        return this.assigneeFilter;
    }

    private boolean isSingleFilter(PropertyFilter filter, Object property, PropertyFilter ... otherFilters) {
        if (filter == null) {
            return false;
        }
        if (filter.isSingleFilter() && (property == null || filter.hasFilter(property))) {
            PropertyFilter[] propertyFilterArray = otherFilters;
            int n = otherFilters.length;
            int n2 = 0;
            while (n2 < n) {
                PropertyFilter other = propertyFilterArray[n2];
                if (other != null && other.hasFilter()) {
                    return false;
                }
                ++n2;
            }
            return true;
        }
        return false;
    }

    public boolean isDarker() {
        return this.darker;
    }

    public void setDarker(boolean darker) {
        this.darker = darker;
        this.scheduleRefresh();
    }

    private boolean passesFilters(ITopic topic) {
        if (this.hasFilter()) {
            return this.getMarkerFilter().hasFilter() && this.getMarkerFilter().passes(topic) || this.getLabelFilter().hasFilter() && this.getLabelFilter().passes(topic) || this.getAssigneeFilter().hasFilter() && this.getAssigneeFilter().passes(topic);
        }
        return true;
    }

    private void scheduleRefresh() {
        if (this.scheduling) {
            return;
        }
        Display.getCurrent().asyncExec(new Runnable(){

            public void run() {
                if (FilterService.this.getViewer().getControl().isDisposed()) {
                    FilterService.this.scheduling = false;
                    return;
                }
                FilterService.this.refresh();
                FilterService.this.scheduling = false;
            }
        });
        this.scheduling = true;
    }

    public void refresh(boolean immediately) {
        if (immediately) {
            this.refresh();
        } else {
            this.scheduleRefresh();
        }
    }

    private void refresh() {
        ISheetPart sheet;
        IHighlightService highlightService;
        if (this.register != null) {
            this.register.unregisterAll();
            this.register = null;
        }
        if ((highlightService = (IHighlightService)this.getViewer().getService(IHighlightService.class)) != null && (sheet = (ISheetPart)this.getViewer().getAdapter(ISheetPart.class)) != null) {
            this.refresh(highlightService, sheet);
        }
    }

    private void refresh(IHighlightService highlightService, ISheetPart sheet) {
        ArrayList<IGraphicalPart> visibleTopics = new ArrayList<IGraphicalPart>();
        if (this.hasFilter()) {
            if (sheet.getCentralBranch() != null) {
                this.collectVisibleTopics(visibleTopics, sheet.getCentralBranch());
            }
            for (IBranchPart branch : sheet.getFloatingBranches()) {
                this.collectVisibleTopics(visibleTopics, branch);
            }
        }
        highlightService.highlight(visibleTopics, this.darker ? 176 : 80);
    }

    public boolean hasFilter() {
        return this.getMarkerFilter().hasFilter() || this.getLabelFilter().hasFilter() || this.getAssigneeFilter().hasFilter();
    }

    private void collectVisibleTopics(List<IGraphicalPart> visibleTopics, IBranchPart branch) {
        ITopic topic = branch.getTopic();
        if (this.register == null) {
            this.register = new CoreEventRegister((ICoreEventListener)this);
        }
        this.register.setNextSourceFrom((Object)topic);
        this.register.register("markerRefAdd");
        this.register.register("markerRefRemove");
        this.register.register("topicRemove");
        this.register.register("topicAdd");
        if (this.passesFilters(topic)) {
            visibleTopics.add((IGraphicalPart)branch.getTopicPart());
        }
        if (!branch.isFolded()) {
            for (IBranchPart subBranch : branch.getSubBranches()) {
                this.collectVisibleTopics(visibleTopics, subBranch);
            }
            for (IBranchPart subBranch : branch.getCalloutBranches()) {
                this.collectVisibleTopics(visibleTopics, subBranch);
            }
            for (IBranchPart subBranch : branch.getSummaryBranches()) {
                this.collectVisibleTopics(visibleTopics, subBranch);
            }
        }
    }

    public void inputChanged(Object oldInput, Object newInput) {
        super.inputChanged(oldInput, newInput);
        this.removeAllFilters();
    }

    @Override
    public void filterChanged(PropertyFilter filter) {
        this.scheduleRefresh();
        this.fireFilterChanged(filter);
    }

    public void addFilterListener(IPropertyFilterListener listener) {
        if (this.listeners == null) {
            this.listeners = new ArrayList<IPropertyFilterListener>();
        }
        this.listeners.add(listener);
    }

    public void removeFilterListener(IPropertyFilterListener listener) {
        if (this.listeners == null) {
            return;
        }
        this.listeners.remove(listener);
    }

    private void fireFilterChanged(PropertyFilter filter) {
        if (this.listeners == null) {
            return;
        }
        Object[] objectArray = this.listeners.toArray();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object l = objectArray[n2];
            ((IPropertyFilterListener)l).filterChanged(filter);
            ++n2;
        }
    }

    public void handleCoreEvent(CoreEvent event) {
        Control control = this.getViewer().getControl();
        if (control != null && !control.isDisposed()) {
            control.getDisplay().syncExec(new Runnable(){

                public void run() {
                    FilterService.this.refresh();
                }
            });
        }
    }
}

