/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.mindmap.filtering;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.xmind.core.ISheet;
import org.xmind.core.ITopic;
import org.xmind.core.event.CoreEvent;
import org.xmind.core.event.CoreEventRegister;
import org.xmind.core.event.ICoreEventListener;
import org.xmind.core.event.ICoreEventRegister;
import org.xmind.gef.IGraphicalViewer;
import org.xmind.ui.forms.WidgetFactory;
import org.xmind.ui.internal.mindmap.filtering.FilterSection;
import org.xmind.ui.internal.mindmap.filtering.FilterService;
import org.xmind.ui.internal.mindmap.filtering.Messages;
import org.xmind.ui.internal.mindmap.filtering.PropertyFilter;
import org.xmind.ui.internal.taskinfo.TaskInfoUtils;
import org.xmind.ui.internal.utils.E4Utils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AssigneeFilterSection
extends FilterSection
implements ICoreEventListener {
    private ICoreEventRegister register;

    public AssigneeFilterSection() {
        this.setTitle(Messages.AssigneeFilterSection_title);
    }

    public AssigneeFilterSection(int noItemPolicy) {
        super(noItemPolicy);
        this.setTitle(Messages.AssigneeFilterSection_title);
    }

    @Override
    protected PropertyFilter findFilter(IGraphicalViewer viewer) {
        FilterService filterService = (FilterService)viewer.getService(FilterService.class);
        if (filterService != null) {
            return filterService.getAssigneeFilter();
        }
        return null;
    }

    @Override
    protected Object[] getAllPropertyFilters(IGraphicalViewer viewer) {
        ISheet sheet = (ISheet)viewer.getAdapter(ISheet.class);
        if (sheet == null) {
            return new Object[0];
        }
        if (this.register != null) {
            this.register.unregisterAll();
            this.register = null;
        }
        this.register = new CoreEventRegister((Object)sheet, (ICoreEventListener)this);
        this.register.register("modifyTime");
        ArrayList<String> assignees = new ArrayList<String>();
        ITopic root = sheet.getRootTopic();
        if (this.getAssignee(root) != null) {
            assignees.add(this.getAssignee(root));
        }
        this.getAllAssignees(root.getAllChildren(), assignees);
        return assignees.toArray();
    }

    private List<ITopic> getAllAssignees(List<ITopic> topics, List<String> assignees) {
        if (topics.size() == 0) {
            return null;
        }
        ArrayList<ITopic> subs = new ArrayList<ITopic>();
        for (ITopic topic : topics) {
            if (this.getAssignee(topic) != null && !assignees.contains(this.getAssignee(topic))) {
                assignees.add(this.getAssignee(topic));
            }
            subs.addAll(topic.getAllChildren());
        }
        return this.getAllAssignees(subs, assignees);
    }

    private String getAssignee(ITopic topic) {
        return TaskInfoUtils.getContent((ITopic)topic, (String)"assigned-to");
    }

    @Override
    protected String getMessage() {
        return Messages.AssigneeFilterSection_message;
    }

    @Override
    protected void createMessagePart(Composite parent, WidgetFactory factory, String message, boolean html) {
        super.createMessagePart(parent, factory, message, true);
    }

    @Override
    protected void handleMessageHyperlink(HyperlinkEvent e) {
        super.handleMessageHyperlink(e);
        if ("#TaskInfoView".equals(e.getHref())) {
            this.gotoTaskInfoView();
        }
    }

    private void gotoTaskInfoView() {
        if (PlatformUI.isWorkbenchRunning()) {
            E4Utils.showPart((String)"org.xmind.ui.command.showModelPart", (IWorkbenchWindow)PlatformUI.getWorkbench().getActiveWorkbenchWindow(), (String)"org.xmind.ui.modelPart.taskinfo", null, (String)"org.xmind.ui.stack.right");
        }
    }

    public void handleCoreEvent(CoreEvent event) {
        Control c = this.getControl();
        if (c == null || c.isDisposed()) {
            return;
        }
        c.getDisplay().syncExec(new Runnable(){

            public void run() {
                AssigneeFilterSection.this.refresh();
            }
        });
    }

    @Override
    protected void handleDispose() {
        if (this.register != null) {
            this.register.unregisterAll();
            this.register = null;
        }
        super.handleDispose();
    }
}

