/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.gallery;

import java.util.List;
import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.FigureCanvas;
import org.eclipse.draw2d.IFigure;
import org.eclipse.jface.util.Util;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.LabelProviderChangedEvent;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.xmind.gef.EditDomain;
import org.xmind.gef.GraphicalViewer;
import org.xmind.gef.IGraphicalViewer;
import org.xmind.gef.event.MouseEvent;
import org.xmind.gef.part.GraphicalEditPart;
import org.xmind.gef.part.GraphicalRootEditPart;
import org.xmind.gef.part.IGraphicalPart;
import org.xmind.gef.part.IPart;
import org.xmind.gef.part.IPartFactory;
import org.xmind.gef.part.IRootPart;
import org.xmind.gef.service.IViewerService;
import org.xmind.gef.tool.ITool;
import org.xmind.gef.tool.SelectTool;
import org.xmind.ui.gallery.NavigationAnimationService;
import org.xmind.ui.gallery.NavigationContentPart;
import org.xmind.ui.gallery.NavigationItemPart;

public class NavigationViewer
extends GraphicalViewer {
    public static final int PREF_HEIGHT = 60;
    public static final int BIG_HEIGHT = 70;
    public static final int SMALL_HEIGHT = 50;
    public static final int BIG_ALPHA = 0;
    public static final int SMALL_ALPHA = 40;
    private static IPartFactory DEFAULT_PART_FACTORY = new IPartFactory(){

        public IPart createPart(IPart context, Object model) {
            if (context instanceof NavigationContentPart) {
                return new NavigationItemPart(model);
            }
            if (context instanceof IRootPart) {
                return new NavigationContentPart(model);
            }
            return new EmptyPart();
        }
    };
    private IStructuredContentProvider contentProvider = null;
    private IBaseLabelProvider labelProvider = null;
    private ILabelProviderListener labelProviderListener = null;

    public NavigationViewer() {
        this.setPartFactory(DEFAULT_PART_FACTORY);
        this.setRootPart((IRootPart)new GraphicalRootEditPart());
        EditDomain editDomain = new EditDomain();
        editDomain.installTool("select tool", (ITool)new NavigationSelectTool());
        this.setEditDomain(editDomain);
        NavigationAnimationService animationService = new NavigationAnimationService((IGraphicalViewer)this);
        this.installService(NavigationAnimationService.class, (IViewerService)animationService);
        animationService.setActive(true);
    }

    public <T> T getAdapter(Class<T> adapter) {
        if (IContentProvider.class.equals(adapter) || IStructuredContentProvider.class.equals(adapter)) {
            return adapter.cast(this.getContentProvider());
        }
        if (IBaseLabelProvider.class.equals(adapter)) {
            return adapter.cast(this.getLabelProvider());
        }
        return (T)super.getAdapter(adapter);
    }

    public IStructuredContentProvider getContentProvider() {
        return this.contentProvider;
    }

    public void setContentProvider(IStructuredContentProvider contentProvider) {
        if (contentProvider == null || contentProvider == this.contentProvider) {
            return;
        }
        IStructuredContentProvider oldContentProvider = this.contentProvider;
        this.contentProvider = contentProvider;
        if (oldContentProvider != null) {
            oldContentProvider.dispose();
        }
        contentProvider.inputChanged((Viewer)this, this.getInput(), this.getInput());
        this.refresh();
    }

    protected void internalInputChanged(Object input, Object oldInput) {
        if (this.getContentProvider() != null) {
            this.getContentProvider().inputChanged((Viewer)this, oldInput, input);
        }
        super.internalInputChanged(input, oldInput);
    }

    public void update() {
        this.update(null);
    }

    public void update(Object[] elements) {
        if (elements == null) {
            IPart contents = this.getRootPart().getContents();
            if (contents.getStatus().isActive()) {
                contents.refresh();
            }
            for (IPart p : contents.getChildren()) {
                if (!p.getStatus().isActive()) continue;
                ((IGraphicalPart)p).refresh();
            }
        } else {
            Object[] objectArray = elements;
            int n = elements.length;
            int n2 = 0;
            while (n2 < n) {
                Object element = objectArray[n2];
                IPart p = this.findPart(element);
                if (p != null && p.getStatus().isActive()) {
                    ((IGraphicalPart)p).refresh();
                }
                ++n2;
            }
        }
    }

    public IBaseLabelProvider getLabelProvider() {
        if (this.labelProvider == null) {
            this.labelProvider = new LabelProvider();
        }
        return this.labelProvider;
    }

    public void setLabelProvider(IBaseLabelProvider labelProvider) {
        if (labelProvider == null) {
            return;
        }
        IBaseLabelProvider oldLabelProvider = this.labelProvider;
        if (labelProvider == oldLabelProvider) {
            return;
        }
        if (oldLabelProvider != null && this.labelProviderListener != null) {
            oldLabelProvider.removeListener(this.labelProviderListener);
        }
        this.labelProvider = labelProvider;
        if (this.labelProviderListener == null) {
            this.labelProviderListener = new LabelProviderListener();
        }
        labelProvider.addListener(this.labelProviderListener);
        this.refresh();
        if (oldLabelProvider != null) {
            oldLabelProvider.dispose();
        }
    }

    protected void handleDispose(DisposeEvent e) {
        if (this.labelProvider != null) {
            if (this.labelProviderListener != null) {
                this.labelProvider.removeListener(this.labelProviderListener);
            }
            this.labelProvider.dispose();
            this.labelProvider = null;
        }
        if (this.contentProvider != null) {
            this.contentProvider.dispose();
            this.contentProvider = null;
        }
        super.handleDispose(e);
    }

    protected Control internalCreateControl(Composite parent, int style) {
        FigureCanvas canvas = (FigureCanvas)super.internalCreateControl(parent, style);
        canvas.setScrollBarVisibility(FigureCanvas.NEVER);
        this.getViewport().setContentsTracksWidth(true);
        this.getViewport().setContentsTracksHeight(true);
        if (Util.isMac()) {
            canvas.addListener(38, (Listener)new NavigationScrollHandler());
        } else {
            canvas.addListener(37, (Listener)new NavigationScrollHandler());
        }
        return canvas;
    }

    private static class EmptyPart
    extends GraphicalEditPart {
        private EmptyPart() {
        }

        protected IFigure createFigure() {
            return new Figure();
        }
    }

    private class LabelProviderListener
    implements ILabelProviderListener {
        private LabelProviderListener() {
        }

        public void labelProviderChanged(LabelProviderChangedEvent event) {
            NavigationViewer.this.update(event.getElements());
        }
    }

    private class NavigationScrollHandler
    implements Listener {
        private NavigationScrollHandler() {
        }

        public void handleEvent(Event event) {
            int offset = event.count;
            offset = (int)(Math.sqrt(Math.abs(offset)) * (double)offset);
            ((NavigationContentPart)NavigationViewer.this.getRootPart().getContents()).addScrollOffset(offset);
        }
    }

    private static class NavigationSelectTool
    extends SelectTool {
        private NavigationSelectTool() {
        }

        protected boolean handleMouseDown(MouseEvent me) {
            if (me.leftOrRight) {
                if (me.target.hasRole("selectable role")) {
                    this.selectSingle(me.target);
                    return true;
                }
                return super.handleMouseDown(me);
            }
            return false;
        }

        protected void select(List<? extends IPart> toSelect, IPart toFocus) {
            if (toSelect.isEmpty()) {
                return;
            }
            super.select(toSelect, toFocus);
        }
    }
}

