/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.gallery;

import org.xmind.gef.IViewer;
import org.xmind.gef.Request;
import org.xmind.gef.event.KeyEvent;
import org.xmind.gef.event.MouseEvent;
import org.xmind.gef.part.IPart;
import org.xmind.gef.tool.ITool;
import org.xmind.gef.tool.SelectTool;
import org.xmind.ui.gallery.FramePart;
import org.xmind.ui.gallery.GalleryViewer;

public class GallerySelectTool
extends SelectTool {
    private FramePart sourceFrame = null;
    private FramePart trackedFrame = null;

    protected boolean isFrameAsButton() {
        return !this.getTargetViewer().getProperties().getBoolean("org.xmind.ui.gallery.solidFrames", false);
    }

    protected boolean isSingleClickToOpen() {
        return this.getTargetViewer().getProperties().getBoolean("org.xmind.ui.gallery.singleClickToOpen", false);
    }

    protected boolean isCursorInTitle(IPart p) {
        return p instanceof FramePart && ((FramePart)p).getFigure().getTitle().containsPoint(this.getCursorPosition());
    }

    protected boolean isTitleEditable(IPart p) {
        if (this.getTargetViewer() instanceof GalleryViewer) {
            return ((GalleryViewer)this.getTargetViewer()).isTitleEditable(p);
        }
        return false;
    }

    protected boolean handleMouseDown(MouseEvent me) {
        FramePart targetFrame = this.findFrame(me.target);
        if (this.isFrameAsButton() && targetFrame != null && targetFrame.getContentPane().containsPoint(me.cursorLocation)) {
            this.sourceFrame = targetFrame;
            this.sourceFrame.getFigure().press();
        }
        boolean ret = this.handleSelectionOnMouseDown(me);
        if (this.isCursorInTitle(me.target) && this.isTitleEditable(me.target)) {
            Request request = new Request("edit");
            request.setDomain(this.getDomain());
            request.setViewer((IViewer)this.getTargetViewer());
            request.setPrimaryTarget(me.target);
            this.startEditing(me.target, request);
            ITool et = this.getTool("edit tool");
            if (et != null && et == this.getDomain().getActiveTool()) {
                me.consume();
            }
        } else if (this.isSingleClickToOpen() && me.leftOrRight && targetFrame != null) {
            this.trackedFrame = targetFrame;
        }
        return ret;
    }

    private FramePart findFrame(IPart part) {
        while (part != null) {
            if (part instanceof FramePart) {
                return (FramePart)part;
            }
            part = part.getParent();
        }
        return null;
    }

    protected boolean handleSelectionOnMouseDown(MouseEvent me) {
        return super.handleMouseDown(me);
    }

    public boolean handleMouseUp(MouseEvent me) {
        FramePart targetFrame = this.findFrame(me.target);
        if (this.sourceFrame != null) {
            this.sourceFrame.getFigure().unpress();
            this.sourceFrame = null;
        }
        boolean handled = super.handleMouseUp(me);
        if (this.trackedFrame != null && this.isSingleClickToOpen() && me.leftOrRight) {
            if (targetFrame == this.trackedFrame) {
                this.performOpen();
            }
            me.consume();
        }
        this.trackedFrame = null;
        return handled;
    }

    protected boolean handleMouseDoubleClick(MouseEvent me) {
        if (!(!(me.target instanceof FramePart) || this.isSingleClickToOpen() || this.isCursorInTitle(me.target) && this.isTitleEditable(me.target))) {
            this.performOpen();
            me.consume();
            return true;
        }
        return super.handleMouseDoubleClick(me);
    }

    protected void performOpen() {
        if (!(this.getTargetViewer() instanceof GalleryViewer)) {
            return;
        }
        GalleryViewer viewer = (GalleryViewer)this.getTargetViewer();
        viewer.fireOpen();
    }

    protected boolean handleKeyTraversed(KeyEvent ke) {
        if (ke.traverse == 4) {
            this.performOpen();
            ke.consume();
            return false;
        }
        return super.handleKeyTraversed(ke);
    }
}

