/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.gallery;

import org.eclipse.draw2d.Border;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Layer;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.MarginBorder;
import org.eclipse.draw2d.StackLayout;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Insets;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.swt.graphics.Color;
import org.xmind.gef.GEF;
import org.xmind.gef.draw2d.AdvancedToolbarLayout;
import org.xmind.gef.draw2d.ITextFigure;
import org.xmind.gef.draw2d.RotatableWrapLabel;
import org.xmind.ui.gallery.FrameBorderLayout;
import org.xmind.ui.gallery.ShadowedLayer;
import org.xmind.ui.resources.ColorUtils;

public class FrameFigure
extends Figure {
    private static final int FLAG_SELECTED = MAX_FLAG << 1;
    private static final int FLAG_PRESELECTED = MAX_FLAG << 2;
    private static final int FLAG_HIDE_TITLE = MAX_FLAG << 3;
    private static final int FLAG_FLAT;
    protected static final Color ColorSelected;
    protected static final Color ColorSelectedPreselected;
    private static final int PADDING = 6;
    private RotatableWrapLabel title;
    private IFigure titleContainer;
    private IFigure contentContainer;
    private ShadowedLayer contentLayer;
    private int titlePlacement = 8;
    private Layer contentCover;

    static {
        MAX_FLAG = FLAG_FLAT = MAX_FLAG << 4;
        ColorSelected = ColorUtils.getColor((String)"#0070d8");
        ColorSelectedPreselected = ColorUtils.getColor((String)"#2088e0");
    }

    public FrameFigure() {
        this.setOpaque(false);
        this.setBorder((Border)new MarginBorder(6));
        FrameBorderLayout layout = new FrameBorderLayout();
        layout.setVerticalSpacing(2);
        layout.setHorizontalSpacing(2);
        super.setLayoutManager((LayoutManager)layout);
        this.titleContainer = new Layer();
        AdvancedToolbarLayout titleContainerLayout = new AdvancedToolbarLayout();
        titleContainerLayout.setStretchMinorAxis(true);
        this.titleContainer.setLayoutManager((LayoutManager)titleContainerLayout);
        this.add(this.titleContainer, FrameBorderLayout.TOP);
        this.title = new RotatableWrapLabel(0);
        this.title.setTextAlignment(2);
        this.title.setAbbreviated(true);
        this.title.setForegroundColor(ColorConstants.black);
        this.titleContainer.add((IFigure)this.title, (Object)FrameBorderLayout.TOP);
        Layer contentPane = new Layer();
        contentPane.setLayoutManager((LayoutManager)new StackLayout());
        this.add((IFigure)contentPane, FrameBorderLayout.CENTER);
        this.contentContainer = new Layer();
        contentPane.add(this.contentContainer);
        AdvancedToolbarLayout contentContainerLayout = new AdvancedToolbarLayout(true);
        contentContainerLayout.setMajorAlignment(0);
        contentContainerLayout.setMinorAlignment(0);
        contentContainerLayout.setInnerMinorAlignment(0);
        this.contentContainer.setLayoutManager((LayoutManager)contentContainerLayout);
        this.contentLayer = new ShadowedLayer();
        this.contentLayer.setBorderColor(ColorUtils.getColor((int)170, (int)170, (int)170));
        this.contentContainer.add((IFigure)this.contentLayer);
        this.contentCover = new Layer();
        AdvancedToolbarLayout presentationLayout = new AdvancedToolbarLayout(true);
        presentationLayout.setMajorAlignment(0);
        presentationLayout.setMinorAlignment(0);
        presentationLayout.setInnerMinorAlignment(0);
        this.contentCover.setLayoutManager((LayoutManager)presentationLayout);
        contentPane.add((IFigure)this.contentCover, GEF.LAYER_PRESENTATION);
    }

    public void setContentSize(Dimension size) {
        if (size == null) {
            this.contentContainer.setPreferredSize(null);
        } else {
            Insets ins1 = this.contentContainer.getInsets();
            Insets ins2 = this.contentLayer.getInsets();
            this.contentContainer.setPreferredSize(size.getExpanded(ins1.getWidth(), ins1.getHeight()).expand(ins2.getWidth(), ins2.getHeight()));
        }
    }

    public void setLayoutManager(LayoutManager manager) {
    }

    protected void paintFigure(Graphics graphics) {
        boolean preselected = this.isPreselected();
        boolean selected = this.isSelected();
        if (selected) {
            this.paintBackground(graphics, ColorSelected, 255);
        } else if (preselected) {
            this.paintBackground(graphics, ColorSelected, 32);
        }
        super.paintFigure(graphics);
    }

    private void paintBackground(Graphics graphics, Color color, int alpha) {
        Rectangle b = this.getBounds();
        graphics.setAlpha(alpha);
        graphics.setBackgroundColor(color);
        graphics.fillRectangle(b);
    }

    public Layer getContentCover() {
        return this.contentCover;
    }

    public ShadowedLayer getContentPane() {
        return this.contentLayer;
    }

    protected IFigure getTitleContainer() {
        return this.titleContainer;
    }

    public ITextFigure getTitle() {
        return this.title;
    }

    public int getTitleRenderStyle() {
        return this.title.getRenderStyle();
    }

    public void setTitleRenderStyle(int renderStyle) {
        this.title.setRenderStyle(renderStyle);
    }

    public int getTitlePlacement() {
        return this.titlePlacement;
    }

    public void setTitlePlacement(int textPlacement) {
        if (textPlacement == this.getTitlePlacement()) {
            return;
        }
        this.titlePlacement = textPlacement;
        this.updateTitlePlacement(textPlacement);
    }

    private void updateTitlePlacement(int textPlacement) {
        Integer constraint = null;
        switch (textPlacement) {
            case 1: {
                constraint = FrameBorderLayout.LEFT;
                this.title.setTextAlignment(4);
                break;
            }
            case 4: {
                constraint = FrameBorderLayout.RIGHT;
                this.title.setTextAlignment(1);
                break;
            }
            case 8: {
                constraint = FrameBorderLayout.TOP;
                this.title.setTextAlignment(2);
                break;
            }
            case 32: {
                constraint = FrameBorderLayout.BOTTOM;
                this.title.setTextAlignment(2);
            }
        }
        if (constraint != null && this.titleContainer.getParent() == this) {
            this.setConstraint(this.titleContainer, constraint);
        }
    }

    public boolean isSelected() {
        return this.getFlag(FLAG_SELECTED);
    }

    public void setSelected(boolean selected) {
        if (selected == this.isSelected()) {
            return;
        }
        this.setFlag(FLAG_SELECTED, selected);
        this.repaint();
        this.title.setForegroundColor(selected ? ColorConstants.white : ColorConstants.black);
    }

    public void setPreselected(boolean preselected) {
        if (preselected == this.isPreselected()) {
            return;
        }
        this.setFlag(FLAG_PRESELECTED, preselected);
        this.repaint();
    }

    public boolean isPreselected() {
        return this.getFlag(FLAG_PRESELECTED);
    }

    public boolean isPressed() {
        return this.contentLayer.isPressed();
    }

    public void setPressed(boolean pressed) {
        if (this.isFlat()) {
            return;
        }
        this.contentLayer.setPressed(pressed);
    }

    public void press() {
        if (this.isFlat()) {
            return;
        }
        this.contentLayer.press();
    }

    public void unpress() {
        if (this.isFlat()) {
            return;
        }
        this.contentLayer.unpress();
    }

    public void togglePressed() {
        if (this.isFlat()) {
            return;
        }
        this.contentLayer.togglePressed();
    }

    public boolean isHideTitle() {
        return this.getFlag(FLAG_HIDE_TITLE);
    }

    public boolean isFlat() {
        return this.getFlag(FLAG_FLAT);
    }

    public void setFlat(boolean flat) {
        if (flat == this.isFlat()) {
            return;
        }
        this.setFlag(FLAG_FLAT, flat);
        if (flat) {
            this.contentLayer.setShadowDepths(0);
        } else {
            this.contentLayer.setShadowDepths(3);
        }
    }

    public void setHideTitle(boolean hideTitle) {
        boolean oldHideTitle = this.isHideTitle();
        if (hideTitle == oldHideTitle) {
            return;
        }
        this.setFlag(FLAG_HIDE_TITLE, hideTitle);
        if (hideTitle) {
            this.remove(this.titleContainer);
        } else {
            this.add(this.titleContainer);
            this.updateTitlePlacement(this.getTitlePlacement());
        }
    }
}

