/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.gallery;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.draw2d.FigureCanvas;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.BaseLabelProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IColorProvider;
import org.eclipse.jface.viewers.IFontProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.IOpenListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.OpenEvent;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.ScrollBar;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.forms.widgets.ScrolledForm;
import org.xmind.gef.EditDomain;
import org.xmind.gef.part.IGraphicalPart;
import org.xmind.gef.part.IPart;
import org.xmind.gef.util.Properties;
import org.xmind.ui.gallery.GalleryViewer;
import org.xmind.ui.gallery.IDecorationContext;
import org.xmind.ui.gallery.ILabelDecorator;
import org.xmind.ui.viewers.CategorizedViewer;
import org.xmind.ui.viewers.IGraphicalToolTipProvider;
import org.xmind.ui.viewers.IToolTipProvider;

public class CategorizedGalleryViewer
extends CategorizedViewer {
    private Map<Object, GalleryViewer> viewers = new HashMap<Object, GalleryViewer>();
    private Properties properties = new Properties();
    private ISelectionChangedListener viewerSelectionChangedListener = new ISelectionChangedListener(){

        public void selectionChanged(SelectionChangedEvent event) {
            if (CategorizedGalleryViewer.this.settingViewerSelections) {
                return;
            }
            for (GalleryViewer viewer : CategorizedGalleryViewer.this.viewers.values()) {
                if (viewer == event.getSelectionProvider()) continue;
                CategorizedGalleryViewer.this.setSelectionToNestedViewer(viewer, (ISelection)StructuredSelection.EMPTY, false);
            }
            CategorizedGalleryViewer.this.fireSelectionChanged(new SelectionChangedEvent((ISelectionProvider)CategorizedGalleryViewer.this, CategorizedGalleryViewer.this.getSelection()));
        }
    };
    private IOpenListener viewerOpenListener = new IOpenListener(){

        public void open(OpenEvent event) {
            CategorizedGalleryViewer.this.fireOpen(new OpenEvent((Viewer)CategorizedGalleryViewer.this, CategorizedGalleryViewer.this.getSelection()));
        }
    };
    private boolean settingViewerSelections = false;
    private EditDomain editDomain = null;
    private Listener selectionClearer = new Listener(){

        public void handleEvent(Event event) {
            CategorizedGalleryViewer.this.setSelection((ISelection)StructuredSelection.EMPTY);
        }
    };

    public EditDomain getEditDomain() {
        return this.editDomain;
    }

    public void setEditDomain(EditDomain editDomain) {
        EditDomain oldEditDomain = this.editDomain;
        if (oldEditDomain != null) {
            oldEditDomain.dispose();
        }
        this.editDomain = editDomain;
        for (GalleryViewer viewer : this.viewers.values()) {
            viewer.setEditDomain(editDomain);
        }
    }

    public Properties getProperties() {
        return this.properties;
    }

    protected final void hookSelectionClearer(Control control) {
        control.addListener(3, this.selectionClearer);
    }

    protected void hookControl(Control control) {
        super.hookControl(control);
        this.hookSelectionClearer(control);
        this.hookSelectionClearer((Control)((ScrolledForm)control).getBody());
    }

    protected Control createSectionContent(Composite parent, Object category) {
        this.hookSelectionClearer((Control)parent);
        Composite wrap = this.getWidgetFactory().createComposite(parent, 64);
        this.hookSelectionClearer((Control)wrap);
        GridLayout wrapLayout = new GridLayout(1, false);
        wrapLayout.marginWidth = 0;
        wrapLayout.marginHeight = 0;
        wrapLayout.verticalSpacing = 0;
        wrapLayout.horizontalSpacing = 0;
        wrap.setLayout((Layout)wrapLayout);
        GalleryViewer viewer = this.createNestedViewer();
        this.configureNestedViewer(viewer, category);
        Control control = viewer.createControl(wrap);
        this.getWidgetFactory().adapt(control, false, false);
        control.setMenu(control.getParent().getMenu());
        this.hookNestedViewerControl(viewer, category);
        control.setLayoutData((Object)new GridData(4, 4, true, true));
        viewer.setSelection((ISelection)StructuredSelection.EMPTY);
        this.viewers.put(category, viewer);
        return wrap;
    }

    protected void disposeSectionContent(Composite parent, Object category) {
        Control control;
        GalleryViewer viewer = this.viewers.remove(category);
        if (viewer != null && (control = viewer.getControl()) != null && !control.isDisposed()) {
            control.getParent().setMenu(null);
            control.setMenu(null);
            control.dispose();
        }
    }

    protected void refreshSectionContent(Control content, Object category, Object element) {
        GalleryViewer viewer = this.viewers.get(category);
        if (viewer != null && viewer.getControl() != null && !viewer.getControl().isDisposed()) {
            if (element != null) {
                IPart part = viewer.findPart(element);
                if (part != null) {
                    part.refresh();
                }
            } else {
                viewer.setInput(this.getElements(category));
            }
        }
    }

    protected GalleryViewer createNestedViewer() {
        return new GalleryViewer();
    }

    protected void configureNestedViewer(GalleryViewer viewer, Object category) {
        viewer.setProperties(this.properties);
        viewer.setContentProvider((IStructuredContentProvider)new ArrayContentProvider());
        viewer.setLabelProvider((IBaseLabelProvider)new DelegatingLabelProvider(this.getLabelProvider()));
        viewer.setFilters(this.getFilters());
        viewer.setSorter(this.getSorter());
        viewer.addSelectionChangedListener(this.viewerSelectionChangedListener);
        viewer.addOpenListener(this.viewerOpenListener);
        viewer.setEditDomain(this.getEditDomain());
    }

    protected void hookNestedViewerControl(GalleryViewer viewer, Object category) {
        ScrollBar vBar;
        viewer.getCanvas().setScrollBarVisibility(FigureCanvas.NEVER);
        ScrollBar hBar = viewer.getCanvas().getHorizontalBar();
        if (hBar != null) {
            hBar.setEnabled(false);
            hBar.setVisible(false);
        }
        if ((vBar = viewer.getCanvas().getVerticalBar()) != null) {
            vBar.setEnabled(false);
            vBar.setVisible(false);
        }
    }

    protected void reveal(Object category, Object element) {
        IPart part;
        GalleryViewer viewer;
        if (element != null && (viewer = this.viewers.get(category)) != null && viewer.getControl() != null && !viewer.getControl().isDisposed() && (part = viewer.findPart(element)) != null && part instanceof IGraphicalPart) {
            Display.getCurrent().asyncExec(new Runnable(){

                @Override
                public void run() {
                    if (viewer.getControl() == null || viewer.getControl().isDisposed()) {
                        return;
                    }
                    IFigure fig = ((IGraphicalPart)part).getFigure();
                    Point loc = viewer.computeToDisplay(fig.getBounds().getLocation(), true);
                    loc = new Point(CategorizedGalleryViewer.this.getContainer().toControl(loc.x, loc.y));
                    CategorizedGalleryViewer.this.reveal(loc.x, loc.y - 10);
                }
            });
            return;
        }
        super.reveal(category, element);
    }

    protected void fillSelection(Object category, List selection) {
        ISelection sel;
        GalleryViewer viewer = this.viewers.get(category);
        if (viewer != null && (sel = viewer.getSelection()) instanceof IStructuredSelection) {
            IStructuredSelection ss = (IStructuredSelection)sel;
            selection.addAll(ss.toList());
        }
    }

    protected void setSelectionToCategory(Object category, ISelection selection, boolean reveal) {
        GalleryViewer viewer = this.viewers.get(category);
        if (viewer != null) {
            this.setSelectionToNestedViewer(viewer, selection, reveal);
        }
    }

    private void setSelectionToNestedViewer(GalleryViewer viewer, ISelection selection, boolean reveal) {
        this.settingViewerSelections = true;
        try {
            viewer.setSelection(selection, reveal);
        }
        finally {
            this.settingViewerSelections = false;
        }
    }

    public GalleryViewer getNestedViewer(Object category) {
        return this.viewers.get(category);
    }

    protected void handleDispose(DisposeEvent event) {
        super.handleDispose(event);
        this.viewers.clear();
    }

    public void setLabelProvider(IBaseLabelProvider labelProvider) {
        super.setLabelProvider(labelProvider);
        for (GalleryViewer viewer : this.viewers.values()) {
            viewer.setLabelProvider(labelProvider);
        }
    }

    public void setSorter(ViewerSorter sorter) {
        super.setSorter(sorter);
        for (GalleryViewer viewer : this.viewers.values()) {
            viewer.setSorter(sorter);
        }
    }

    public void addFilter(ViewerFilter filter) {
        super.addFilter(filter);
        for (GalleryViewer viewer : this.viewers.values()) {
            viewer.addFilter(filter);
        }
    }

    public void removeFilter(ViewerFilter filter) {
        super.removeFilter(filter);
        for (GalleryViewer viewer : this.viewers.values()) {
            viewer.removeFilter(filter);
        }
    }

    public void setFilters(ViewerFilter ... filters) {
        super.setFilters(filters);
        for (GalleryViewer viewer : this.viewers.values()) {
            viewer.setFilters(filters);
        }
    }

    protected void doUpdateItem(Widget item, Object element, boolean fullMap) {
        GalleryViewer viewer;
        super.doUpdateItem(item, element, fullMap);
        Object category = this.getCategory(element);
        if (category != null && (viewer = this.viewers.get(category)) != null) {
            viewer.update(new Object[]{element});
        }
    }

    private static class DelegatingLabelProvider
    extends BaseLabelProvider
    implements ILabelProvider,
    IColorProvider,
    IFontProvider,
    IToolTipProvider,
    IGraphicalToolTipProvider,
    ILabelDecorator {
        private IBaseLabelProvider labelProvider;

        public DelegatingLabelProvider(IBaseLabelProvider labelProvider) {
            this.labelProvider = labelProvider;
        }

        public boolean isLabelProperty(Object element, String property) {
            return this.labelProvider.isLabelProperty(element, property);
        }

        public void addListener(ILabelProviderListener listener) {
            super.addListener(listener);
            this.labelProvider.addListener(listener);
        }

        public void removeListener(ILabelProviderListener listener) {
            super.removeListener(listener);
            this.labelProvider.removeListener(listener);
        }

        public void dispose() {
            Object[] listeners = this.getListeners();
            int i = 0;
            while (i < listeners.length) {
                this.labelProvider.removeListener((ILabelProviderListener)listeners[i]);
                ++i;
            }
            super.dispose();
        }

        public Font getFont(Object element) {
            if (this.labelProvider instanceof IFontProvider) {
                return ((IFontProvider)this.labelProvider).getFont(element);
            }
            return null;
        }

        public Color getForeground(Object element) {
            if (this.labelProvider instanceof IColorProvider) {
                return ((IColorProvider)this.labelProvider).getForeground(element);
            }
            return null;
        }

        public Color getBackground(Object element) {
            if (this.labelProvider instanceof IColorProvider) {
                return ((IColorProvider)this.labelProvider).getBackground(element);
            }
            return null;
        }

        public Image getImage(Object element) {
            if (this.labelProvider instanceof ILabelProvider) {
                return ((ILabelProvider)this.labelProvider).getImage(element);
            }
            return null;
        }

        public String getText(Object element) {
            if (this.labelProvider instanceof ILabelProvider) {
                return ((ILabelProvider)this.labelProvider).getText(element);
            }
            return "";
        }

        public String getToolTip(Object element) {
            if (this.labelProvider instanceof IToolTipProvider) {
                return ((IToolTipProvider)this.labelProvider).getToolTip(element);
            }
            return null;
        }

        public IFigure getToolTipFigure(Object element) {
            if (this.labelProvider instanceof IGraphicalToolTipProvider) {
                return ((IGraphicalToolTipProvider)this.labelProvider).getToolTipFigure(element);
            }
            return null;
        }

        @Override
        public IFigure decorateFigure(IFigure figure, Object element, IDecorationContext context) {
            if (this.labelProvider instanceof ILabelDecorator) {
                return ((ILabelDecorator)this.labelProvider).decorateFigure(figure, element, context);
            }
            return figure;
        }
    }
}

