/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.gef.ui.editor;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.dialogs.IPageChangeProvider;
import org.eclipse.jface.dialogs.IPageChangedListener;
import org.eclipse.jface.dialogs.PageChangedEvent;
import org.eclipse.jface.util.SafeRunnable;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.events.MenuDetectEvent;
import org.eclipse.swt.events.MenuDetectListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.ui.IEditorActionBarContributor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.part.EditorPart;
import org.xmind.gef.EditDomain;
import org.xmind.gef.command.CommandStack;
import org.xmind.gef.command.CommandStackEvent;
import org.xmind.gef.command.ICommandStack;
import org.xmind.gef.command.ICommandStackListener;
import org.xmind.gef.ui.actions.ActionRegistry;
import org.xmind.gef.ui.actions.IActionRegistry;
import org.xmind.gef.ui.actions.ICommandStackAction;
import org.xmind.gef.ui.editor.GlobalActionHandlerService;
import org.xmind.gef.ui.editor.GraphicalEditorActionBarContributor;
import org.xmind.gef.ui.editor.IGlobalActionHandlerService;
import org.xmind.gef.ui.editor.IGlobalActionHandlerUpdater;
import org.xmind.gef.ui.editor.IGraphicalEditor;
import org.xmind.gef.ui.editor.IGraphicalEditorPage;
import org.xmind.gef.ui.editor.IMiniBar;
import org.xmind.gef.ui.editor.IMiniBarContributor;
import org.xmind.gef.ui.editor.IPageContainerPresentation;
import org.xmind.gef.ui.editor.MiniBar;
import org.xmind.gef.ui.editor.TabFolderContainerPresentation;
import org.xmind.gef.ui.internal.GEFPlugin;
import org.xmind.gef.util.EventListenerSupport;
import org.xmind.gef.util.IEventDispatcher;
import org.xmind.ui.tabfolder.DelegatedSelectionProvider;
import org.xmind.ui.tabfolder.IDelegatedSelectionProvider;
import org.xmind.ui.tabfolder.IPageClosedListener;

public abstract class GraphicalEditor
extends EditorPart
implements IGraphicalEditor,
ICommandStackListener {
    private Composite container = null;
    private IPageContainerPresentation containerPresentation = null;
    private IPageChangedListener presentationHooker = new IPageChangedListener(){

        public void pageChanged(PageChangedEvent event) {
            GraphicalEditor.this.handlePageChange(GraphicalEditor.this.getActivePage());
        }
    };
    private List<IGraphicalEditorPage> pages = new ArrayList<IGraphicalEditorPage>();
    private EventListenerSupport listeners = new EventListenerSupport();
    private ICommandStack commandStack = null;
    private IMiniBar miniBar = null;
    private IMiniBarContributor miniBarContributor = null;
    private IActionRegistry actionRegistry = null;
    private List<ICommandStackAction> csActions = null;
    private int activePageIndex = -1;
    private PageInputSelectionProvider pageInputSelectionProvider = null;
    private MenuManager pagePopupMenu = null;
    private IGlobalActionHandlerService globalActionHandlerService = null;

    public void init(IEditorSite site, IEditorInput input) throws PartInitException {
        this.setSite((IWorkbenchPartSite)site);
        this.setInput(input);
        site.setSelectionProvider(this.createSelectionProvider());
        this.setCommandStack(this.createCommandStack());
    }

    protected ISelectionProvider createSelectionProvider() {
        return new MultiPageSelectionProvider();
    }

    protected Object findOwnedInput(ISelection selection) {
        return null;
    }

    protected Composite getContainer() {
        return this.container;
    }

    protected IPageContainerPresentation getContainerPresentation() {
        return this.containerPresentation;
    }

    protected void hookContainerPresentation() {
        this.getContainerPresentation().addPageChangedListener(this.presentationHooker);
    }

    public void createPartControl(Composite parent) {
        if (this.containerPresentation == null) {
            this.containerPresentation = this.createContainerPresentation();
            this.hookContainerPresentation();
        }
        Composite containerParent = this.createContainerParent(parent);
        this.container = this.containerPresentation.createContainer(containerParent);
        this.createEditorContents();
    }

    protected void createEditorContents() {
        if (this.getContainer() instanceof CTabFolder) {
            this.createMiniBarComposite((CTabFolder)this.getContainer());
            this.createPageContextMenu((Composite)((CTabFolder)this.getContainer()));
        }
    }

    private void createMiniBarComposite(CTabFolder tabFolder) {
        Composite composite = new Composite(this.getContainer(), 0);
        GridLayout layout = new GridLayout(1, false);
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        layout.horizontalSpacing = 0;
        layout.verticalSpacing = 0;
        composite.setLayout((Layout)layout);
        this.createMiniBar(composite);
        ToolBar control = ((ToolBarManager)this.miniBar.getToolBarManager()).getControl();
        GridData controlData = new GridData(131072, 4, true, true);
        control.setLayoutData((Object)controlData);
        tabFolder.setTopRight((Control)composite, 131072);
    }

    protected IPageContainerPresentation createContainerPresentation() {
        return new TabFolderContainerPresentation();
    }

    protected Composite createContainerParent(Composite parent) {
        parent.setLayout((Layout)new FillLayout());
        return parent;
    }

    @Override
    public void addPage(IGraphicalEditorPage page) {
        page.setEditDomain(this.createEditDomain(page));
        this.createPageControl(page);
        this.pages.add(page);
    }

    private void createPageControl(IGraphicalEditorPage page) {
        page.createPageControl(this.getContainer());
        Assert.isNotNull((Object)page.getControl());
        Assert.isNotNull((Object)page.getViewer());
        Assert.isNotNull((Object)page.getViewer().getControl());
        this.addPageControl(page.getControl());
    }

    private void addPageControl(Control pageControl) {
        int index = this.containerPresentation.getPageCount(this.getContainer());
        this.containerPresentation.addPage(this.getContainer(), index, pageControl);
    }

    protected EditDomain createEditDomain(IGraphicalEditorPage page) {
        return new EditDomain();
    }

    protected void disposeEditDomain(IGraphicalEditorPage page, EditDomain editDomain) {
        editDomain.dispose();
    }

    protected void createPageContextMenu(Composite container) {
        if (this.pagePopupMenu == null) {
            this.pagePopupMenu = this.createPagePopupMenu();
            String menuId = String.valueOf(this.getSite().getId()) + ".page";
            if (this.isPagePopupMenuDynamic()) {
                this.setupDynamicPopupMenu(container, this.pagePopupMenu);
            } else {
                this.contributeToPagePopupMenu((IMenuManager)this.pagePopupMenu);
            }
            this.registerPagePopupMenu(menuId, this.pagePopupMenu);
        }
        container.setMenu(this.pagePopupMenu.createContextMenu((Control)container));
    }

    private void setupDynamicPopupMenu(final Composite container, MenuManager popupMenu) {
        final boolean[] showsItems = new boolean[]{false};
        popupMenu.setRemoveAllWhenShown(true);
        popupMenu.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                if (showsItems[0]) {
                    GraphicalEditor.this.contributeToPagePopupMenu(manager);
                }
            }
        });
        container.addMenuDetectListener(new MenuDetectListener(){

            public void menuDetected(MenuDetectEvent e) {
                CTabFolder folder = (CTabFolder)container;
                Point p = folder.toControl(e.x, e.y);
                showsItems[0] = !folder.getClientArea().contains(p) && !folder.getTopRight().getBounds().contains(p);
            }
        });
    }

    protected void registerPagePopupMenu(String menuId, MenuManager menu) {
        this.getSite().registerContextMenu(menuId, menu, this.getPageInputSelectionProvider());
    }

    protected void contributeToPagePopupMenu(IMenuManager menu) {
        IEditorActionBarContributor contributor = this.getEditorSite().getActionBarContributor();
        if (contributor instanceof GraphicalEditorActionBarContributor) {
            ((GraphicalEditorActionBarContributor)contributor).contributeToPagePopupMenu(menu);
        }
    }

    protected boolean isPagePopupMenuDynamic() {
        return true;
    }

    protected MenuManager createPagePopupMenu() {
        return new MenuManager();
    }

    @Override
    public void removePage(IGraphicalEditorPage page) {
        this.removePage(this.findPage(page));
    }

    protected void removePage(int pageIndex) {
        Assert.isTrue((pageIndex >= 0 && pageIndex < this.getPageCount() ? 1 : 0) != 0);
        boolean wasActivePage = pageIndex == this.getActivePage();
        IGraphicalEditorPage page = this.getPage(pageIndex);
        this.containerPresentation.disposePage(this.getContainer(), pageIndex);
        if (page != null) {
            page.dispose();
        }
        this.pages.remove(page);
        if (wasActivePage) {
            if (pageIndex == this.getPageCount()) {
                --pageIndex;
            }
            this.setActivePage(pageIndex);
        }
        this.firePageClosed(page);
    }

    @Override
    public IGraphicalEditorPage getPage(int pageIndex) {
        if (pageIndex < 0 || pageIndex >= this.getPageCount()) {
            return null;
        }
        return this.pages.get(pageIndex);
    }

    @Override
    public int findPage(IGraphicalEditorPage page) {
        return this.pages.indexOf(page);
    }

    protected void postSave() {
        if (this.getCommandStack() != null) {
            this.getCommandStack().markSaved();
        }
        this.firePropertyChange(257);
    }

    @Override
    public int getPageCount() {
        return this.pages.size();
    }

    public boolean isDirty() {
        return this.getCommandStack() != null && this.getCommandStack().isDirty();
    }

    protected final void createMiniBar(Composite parent) {
        if (!(this.getContainer() instanceof CTabFolder)) {
            return;
        }
        this.miniBar = new MiniBar();
        this.initializeMiniBar(this.miniBar);
        if (!((MiniBar)this.miniBar).isEmpty()) {
            this.createMiniBarControl(this.miniBar, (CTabFolder)this.getContainer(), parent);
        }
    }

    private void initializeMiniBar(IMiniBar miniBar) {
        if (this.getMiniBarContributor() != null) {
            this.getMiniBarContributor().init(miniBar, this);
        }
    }

    private void createMiniBarControl(IMiniBar miniBar, CTabFolder tabFolder, Composite parent) {
        ((ToolBarManager)miniBar.getToolBarManager()).createControl(parent);
    }

    public IMiniBarContributor getMiniBarContributor() {
        return this.miniBarContributor;
    }

    public void setMiniBarContributor(IMiniBarContributor miniBarContributor) {
        this.miniBarContributor = miniBarContributor;
    }

    @Override
    public ICommandStack getCommandStack() {
        return this.commandStack;
    }

    protected ICommandStack createCommandStack() {
        return new CommandStack();
    }

    public void handleCommandStackEvent(CommandStackEvent event) {
        if ((event.getStatus() & 0x38) != 0 || event.getStatus() == 128) {
            this.getSite().getShell().getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    GraphicalEditor.this.firePropertyChange(257);
                }
            });
        }
    }

    @Deprecated
    protected void fireDirty() {
        this.firePropertyChange(257);
    }

    @Override
    public void setCommandStack(ICommandStack commandStack) {
        ICommandStack oldCS = this.commandStack;
        if (commandStack == oldCS) {
            return;
        }
        this.commandStack = commandStack;
        this.commandStackChanged(oldCS, commandStack);
    }

    protected void commandStackChanged(ICommandStack oldCS, ICommandStack newCS) {
        if (oldCS != null) {
            this.unhookCommandStack(oldCS);
        }
        if (newCS != null) {
            this.hookCommandStack(newCS);
        }
        IGraphicalEditorPage[] iGraphicalEditorPageArray = this.getPages();
        int n = iGraphicalEditorPageArray.length;
        int n2 = 0;
        while (n2 < n) {
            IGraphicalEditorPage page = iGraphicalEditorPageArray[n2];
            EditDomain domain = page.getEditDomain();
            if (domain != null) {
                domain.setCommandStack(newCS);
            }
            ++n2;
        }
        if (this.csActions != null) {
            for (ICommandStackAction action : this.csActions) {
                action.setCommandStack(newCS);
            }
        }
        this.firePropertyChange(257);
    }

    protected void hookCommandStack(ICommandStack cs) {
        cs.addCSListener((ICommandStackListener)this);
    }

    protected void unhookCommandStack(ICommandStack cs) {
        cs.removeCSListener((ICommandStackListener)this);
    }

    public <T> T getAdapter(Class<T> adapter) {
        T result = this.getEditorAdapter(adapter);
        if (result != null) {
            return result;
        }
        Object activePage = this.getSelectedPage();
        if (activePage != null && (result = GEFPlugin.getAdapter(activePage, adapter)) != null) {
            return result;
        }
        return (T)super.getAdapter(adapter);
    }

    protected <T> T getEditorAdapter(Class<T> adapter) {
        if (adapter.isInstance(this)) {
            return adapter.cast(this);
        }
        if (adapter == ICommandStack.class) {
            return adapter.cast(this.getCommandStack());
        }
        if (adapter == IActionRegistry.class) {
            return adapter.cast(this.getActionRegistry());
        }
        if (adapter == IMiniBar.class) {
            return adapter.cast(this.miniBar);
        }
        if (adapter == IMiniBarContributor.class) {
            return adapter.cast(this.getMiniBarContributor());
        }
        if (adapter == IGlobalActionHandlerService.class) {
            if (this.globalActionHandlerService == null) {
                this.globalActionHandlerService = new GlobalActionHandlerService(this);
            }
            return adapter.cast(this.globalActionHandlerService);
        }
        if (adapter == IGlobalActionHandlerUpdater.class) {
            IEditorActionBarContributor contributor = this.getEditorSite().getActionBarContributor();
            if (contributor instanceof IGlobalActionHandlerUpdater) {
                return adapter.cast(contributor);
            }
            return null;
        }
        return null;
    }

    public Object getSelectedPage() {
        return this.getActivePageInstance();
    }

    @Override
    public IGraphicalEditorPage getActivePageInstance() {
        return this.getPage(this.getActivePage());
    }

    public void addPageChangedListener(IPageChangedListener listener) {
        this.listeners.addListener(IPageChangedListener.class, (Object)listener);
    }

    public void removePageChangedListener(IPageChangedListener listener) {
        this.listeners.removeListener(IPageChangedListener.class, (Object)listener);
    }

    protected void firePageChanged(Object page) {
        final PageChangedEvent event = new PageChangedEvent((IPageChangeProvider)this, page);
        this.listeners.fireEvent(IPageChangedListener.class, new IEventDispatcher(){

            public void dispatch(Object listener) {
                ((IPageChangedListener)listener).pageChanged(event);
            }
        });
    }

    protected void firePageClosed(final Object page) {
        this.listeners.fireEvent(IPageChangedListener.class, new IEventDispatcher(){

            public void dispatch(Object listener) {
                if (listener instanceof IPageClosedListener) {
                    ((IPageClosedListener)listener).pageClosed(page);
                }
            }
        });
    }

    protected void handlePageChange(int newPageIndex) {
        ISelectionProvider selectionProvider;
        IEditorActionBarContributor contributor;
        IWorkbenchPart currentActivePart;
        IWorkbenchPage page;
        boolean wasFocused = false;
        IGraphicalEditorPage oldActivePage = this.getPage(this.activePageIndex);
        if (oldActivePage != null && oldActivePage.isActive()) {
            wasFocused = oldActivePage.isFocused();
            oldActivePage.setActive(false);
        }
        this.activePageIndex = newPageIndex;
        IGraphicalEditorPage activePage = this.getPage(newPageIndex);
        if (activePage != null && !activePage.isActive()) {
            activePage.setActive(true);
        }
        if (wasFocused) {
            activePage.setFocus();
        }
        if ((page = this.getSite().getPage()) != null && (currentActivePart = page.getActivePart()) == this && (contributor = this.getEditorSite().getActionBarContributor()) != null && contributor instanceof GraphicalEditorActionBarContributor) {
            ((GraphicalEditorActionBarContributor)contributor).setActivePage(activePage);
        }
        if ((selectionProvider = this.getSite().getSelectionProvider()) instanceof IDelegatedSelectionProvider) {
            ((IDelegatedSelectionProvider)selectionProvider).setDelegate(activePage == null ? null : activePage.getSelectionProvider());
        }
        if (this.getMiniBarContributor() != null) {
            this.getMiniBarContributor().setActivePage(activePage);
        }
        if (this.pageInputSelectionProvider != null) {
            Object pageInput = activePage == null ? null : activePage.getInput();
            this.pageInputSelectionProvider.setSelection((ISelection)(pageInput == null ? StructuredSelection.EMPTY : new StructuredSelection(pageInput)));
        }
        this.firePageChanged(activePage);
    }

    public void setFocus() {
        this.setFocus(this.getActivePage());
    }

    protected void setFocus(int pageIndex) {
        if (pageIndex < 0 || pageIndex >= this.getPageCount()) {
            this.container.setFocus();
        } else {
            IGraphicalEditorPage page = this.getPage(pageIndex);
            if (page != null) {
                page.setFocus();
            } else {
                Control control = this.containerPresentation.getPageControl(this.getContainer(), pageIndex);
                if (control != null && !control.isDisposed()) {
                    control.setFocus();
                }
            }
        }
    }

    @Override
    public void movePageTo(int oldIndex, int newIndex) {
        IGraphicalEditorPage activePage = this.getActivePageInstance();
        boolean wasActive = oldIndex == this.getActivePage();
        this.pages.add(newIndex, this.pages.remove(oldIndex));
        int i = 0;
        while (i < this.pages.size()) {
            IGraphicalEditorPage page = this.pages.get(i);
            boolean wasFocused = page.isFocused();
            this.containerPresentation.setPageControl(this.getContainer(), i, page.getControl());
            if (wasFocused) {
                page.setFocus();
            }
            page.updatePageTitle();
            ++i;
        }
        if (wasActive) {
            this.pages.get(newIndex).getControl().setVisible(true);
            this.setActivePage(newIndex);
        }
        if (activePage != null) {
            this.containerPresentation.setActivePage(this.getContainer(), this.pages.indexOf(activePage));
        }
    }

    @Override
    public String getPageText(int pageIndex) {
        return this.containerPresentation.getPageText(this.getContainer(), pageIndex);
    }

    @Override
    public void setPageText(int pageIndex, String text) {
        if (text == null) {
            text = "";
        }
        this.containerPresentation.setPageText(this.getContainer(), pageIndex, text);
    }

    @Override
    public int getActivePage() {
        return this.containerPresentation.getActivePage(this.getContainer());
    }

    @Override
    public void setActivePage(int pageIndex) {
        if (pageIndex < 0 || pageIndex >= this.getPageCount()) {
            return;
        }
        if (pageIndex >= 0) {
            this.containerPresentation.setActivePage(this.getContainer(), pageIndex);
        } else {
            this.containerPresentation.setActivePage(this.getContainer(), this.containerPresentation.getPageCount(this.getContainer()) - 1);
        }
        this.handlePageChange(pageIndex);
    }

    @Override
    public IGraphicalEditorPage[] getPages() {
        return this.pages.toArray(new IGraphicalEditorPage[this.pages.size()]);
    }

    protected ISelectionProvider getPageInputSelectionProvider() {
        if (this.pageInputSelectionProvider == null) {
            this.pageInputSelectionProvider = new PageInputSelectionProvider();
        }
        return this.pageInputSelectionProvider;
    }

    protected IActionRegistry getActionRegistry() {
        if (this.actionRegistry == null) {
            this.actionRegistry = new ActionRegistry();
        }
        return this.actionRegistry;
    }

    public void dispose() {
        IWorkbenchPartSite site;
        if (this.csActions != null) {
            for (ICommandStackAction action : this.csActions) {
                action.setCommandStack(null);
            }
            this.csActions = null;
        }
        if (this.actionRegistry != null) {
            this.actionRegistry.dispose();
            this.actionRegistry = null;
        }
        if (this.pagePopupMenu != null) {
            this.pagePopupMenu.dispose();
            this.pagePopupMenu = null;
        }
        if (this.miniBar != null) {
            IToolBarManager toolBarManager = this.miniBar.getToolBarManager();
            if (toolBarManager instanceof ToolBarManager) {
                ((ToolBarManager)toolBarManager).dispose();
            }
            this.miniBar = null;
        }
        if (this.miniBarContributor != null) {
            this.miniBarContributor.dispose();
            this.miniBarContributor = null;
        }
        if (this.commandStack != null) {
            if (!this.commandStack.isDisposed()) {
                this.disposeCommandStack(this.commandStack);
            }
            this.commandStack = null;
        }
        if ((site = this.getSite()) != null) {
            site.setSelectionProvider(null);
        }
        this.disposePages();
        super.dispose();
    }

    protected void disposeCommandStack(ICommandStack commandStack) {
        commandStack.dispose();
    }

    private void disposePages() {
        if (this.pages.isEmpty()) {
            return;
        }
        Object[] objectArray = this.pages.toArray();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            final Object o = objectArray[n2];
            SafeRunner.run((ISafeRunnable)new SafeRunnable(){

                public void run() throws Exception {
                    IGraphicalEditorPage page = (IGraphicalEditorPage)o;
                    page.dispose();
                    EditDomain editDomain = page.getEditDomain();
                    if (editDomain != null) {
                        GraphicalEditor.this.disposeEditDomain(page, editDomain);
                    }
                }
            });
            ++n2;
        }
        this.pages.clear();
    }

    @Override
    public IGraphicalEditorPage findPage(Object input) {
        IGraphicalEditorPage[] iGraphicalEditorPageArray = this.getPages();
        int n = iGraphicalEditorPageArray.length;
        int n2 = 0;
        while (n2 < n) {
            IGraphicalEditorPage page = iGraphicalEditorPageArray[n2];
            Object pageInput = page.getInput();
            if (pageInput == input || input != null && input.equals(pageInput)) {
                return page;
            }
            ++n2;
        }
        return null;
    }

    @Override
    public IGraphicalEditorPage ensurePageVisible(Object input) {
        IGraphicalEditorPage page = this.findPage(input);
        if (page != null && page != this.getActivePageInstance()) {
            this.setActivePage(page.getIndex());
            page = this.getActivePageInstance();
        }
        return page;
    }

    @Override
    public boolean navigateTo(Object input, Object ... elements) {
        IGraphicalEditorPage page = this.ensurePageVisible(input);
        if (page != null) {
            if (elements == null) {
                return true;
            }
            ISelectionProvider viewer = page.getSelectionProvider();
            if (viewer != null) {
                viewer.setSelection((ISelection)new StructuredSelection(elements));
                return true;
            }
        }
        return false;
    }

    protected void addCommandStackAction(ICommandStackAction action) {
        if (this.csActions == null) {
            this.csActions = new ArrayList<ICommandStackAction>();
        }
        this.csActions.add(action);
    }

    protected class MultiPageSelectionProvider
    extends DelegatedSelectionProvider {
        protected MultiPageSelectionProvider() {
        }

        public void setSelection(ISelection selection) {
            Object input = GraphicalEditor.this.findOwnedInput(selection);
            if (input != null) {
                GraphicalEditor.this.ensurePageVisible(input);
            }
            super.setSelection(selection);
        }
    }

    protected class PageInputSelectionProvider
    implements ISelectionProvider {
        private EventListenerSupport listeners = new EventListenerSupport();

        protected PageInputSelectionProvider() {
        }

        public void addSelectionChangedListener(ISelectionChangedListener listener) {
            this.listeners.addListener(ISelectionChangedListener.class, (Object)listener);
        }

        public ISelection getSelection() {
            Object pageInput;
            IGraphicalEditorPage page = GraphicalEditor.this.getActivePageInstance();
            if (page != null && (pageInput = page.getInput()) != null) {
                return new StructuredSelection(pageInput);
            }
            return StructuredSelection.EMPTY;
        }

        public void removeSelectionChangedListener(ISelectionChangedListener listener) {
            this.listeners.removeListener(ISelectionChangedListener.class, (Object)listener);
        }

        public void setSelection(ISelection selection) {
            Object pageInput;
            if (selection instanceof IStructuredSelection && (pageInput = ((IStructuredSelection)selection).getFirstElement()) != null) {
                GraphicalEditor.this.ensurePageVisible(pageInput);
            }
        }

        protected void firePageChanged() {
            this.fireSelectionChanged(new SelectionChangedEvent((ISelectionProvider)this, this.getSelection()));
        }

        private void fireSelectionChanged(final SelectionChangedEvent event) {
            this.listeners.fireEvent(ISelectionChangedListener.class, new IEventDispatcher(){

                public void dispatch(Object listener) {
                    ((ISelectionChangedListener)listener).selectionChanged(event);
                }
            });
        }
    }
}

