/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.audionotes;

import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.FigureCanvas;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.ImageFigure;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Path;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.xmind.ui.internal.audionotes.AudioNotesViewerPage;
import org.xmind.ui.viewers.SWTUtils;
import org.xmind.ui.viewers.SliderViewer;

public class ProgressComposite
extends SliderViewer
implements AudioNotesViewerPage.ContentComposite {
    private static final int BLOCK_HEIGHT = 15;
    private static final int BLOCK_WIDTH = 8;
    private static final int SLOT_HEIGHT = 8;

    public ProgressComposite(Composite parent, int style) {
        super(parent, style);
    }

    public void setSelection(Object selection) {
        this.setSelection((ISelection)new StructuredSelection(selection));
    }

    protected IFigure createSlotFigure() {
        return new SlotFigure(this);
    }

    protected IFigure createBlockFigure() {
        BlockFigure imageFigure = new BlockFigure(this);
        final Image image = new Image((Device)this.getControl().getDisplay(), 8, 15);
        GC gc = new GC((Drawable)image);
        gc.setBackground(ColorConstants.gray);
        gc.fillRectangle(0, 0, 8, 15);
        imageFigure.setImage(image);
        this.getControl().addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                image.dispose();
            }
        });
        return imageFigure;
    }

    protected void layoutFigures(FigureCanvas fc) {
        Rectangle r = new Rectangle(fc.getViewport().getClientArea());
        Dimension size = this.getBlockFigure().getPreferredSize();
        Rectangle b = new Rectangle(r.x + size.width / 2, r.y + (r.height - 8) / 2, r.width - size.width, 8);
        int x = (int)((double)b.x + (double)b.width * this.getSelectionPortion());
        int y = b.y + b.height - b.height / 2;
        Rectangle b2 = new Rectangle(x - size.width / 2, y - size.height / 2, size.width, size.height);
        this.getSlotFigure().setBounds(b);
        this.getBlockFigure().setBounds(b2);
    }

    public void resetProgress() {
        Dimension size = this.getBlockFigure().getPreferredSize();
        Rectangle b = new Rectangle(this.getSlotFigure().getClientArea());
        int y = b.y + b.height / 2;
        Rectangle b2 = new Rectangle(0, y - size.height / 2, size.width, size.height);
        this.getSlotFigure().setBounds(b);
        this.getBlockFigure().setBounds(b2);
    }

    protected boolean handleCanvasSelection(int x, int y) {
        boolean result = super.handleCanvasSelection(x, y);
        this.firePostSelectionChanged(new SelectionChangedEvent((ISelectionProvider)this, this.getSelection()));
        return result;
    }

    private final class BlockFigure
    extends ImageFigure {
        private SliderViewer viewer;

        public BlockFigure(SliderViewer viewer) {
            this.viewer = viewer;
        }

        protected void paintFigure(Graphics graphics) {
            graphics.setAntialias(1);
            if (this.viewer.getControl() != null && !this.viewer.getControl().isDisposed() && this.viewer.getControl().isEnabled()) {
                graphics.setAlpha(255);
            } else {
                graphics.setAlpha(128);
            }
            super.paintFigure(graphics);
        }
    }

    private class SlotFigure
    extends Figure {
        final RGB LEFT_BACKGROUND = new RGB(88, 214, 58);
        final RGB RIGHT_BACKGROUND = new RGB(220, 217, 213);
        private SliderViewer viewer;

        public SlotFigure(SliderViewer viewer) {
            this.viewer = viewer;
        }

        public boolean containsPoint(int x, int y) {
            Rectangle r = this.getBounds();
            return y >= r.y - 5 && y < r.y + r.height + 5 && x >= r.x && x < r.x + r.width;
        }

        protected void paintFigure(Graphics graphics) {
            IStructuredSelection selection = (IStructuredSelection)this.viewer.getSelection();
            Double rate = (Double)selection.getFirstElement();
            Color preBackground = graphics.getBackgroundColor();
            Color preForeground = graphics.getForegroundColor();
            int alpha = 96;
            graphics.setAntialias(1);
            if (this.viewer.getControl() != null && !this.viewer.getControl().isDisposed() && this.viewer.getControl().isEnabled()) {
                graphics.setAlpha(255);
            } else {
                graphics.setAlpha(144);
            }
            Rectangle r = this.getBounds();
            Path leftShape = new Path((Device)Display.getCurrent());
            Path rightShape = new Path((Device)Display.getCurrent());
            Path clientAreaPath = new Path((Device)Display.getDefault());
            int selectionWidth = (int)((double)r.width * rate);
            SWTUtils.addRoundedRectangle((Path)leftShape, (float)r.x, (float)r.y, (float)selectionWidth, (float)(r.height - 1), (float)0.0f);
            SWTUtils.addRoundedRectangle((Path)rightShape, (float)(r.x + selectionWidth), (float)r.y, (float)(r.width - selectionWidth - 1), (float)(r.height - 1), (float)0.0f);
            SWTUtils.addRoundedRectangle((Path)clientAreaPath, (float)r.x, (float)r.y, (float)(r.width - 1), (float)(r.height - 1), (float)0.0f);
            Color leftColor = new Color((Device)Display.getDefault(), this.LEFT_BACKGROUND);
            graphics.setBackgroundColor(leftColor);
            graphics.fillPath(leftShape);
            Color rightColor = new Color((Device)Display.getDefault(), this.RIGHT_BACKGROUND);
            graphics.setBackgroundColor(rightColor);
            graphics.fillPath(rightShape);
            graphics.setAlpha(alpha);
            graphics.setForegroundColor(rightColor);
            graphics.drawPath(clientAreaPath);
            graphics.setBackgroundColor(preBackground);
            graphics.setForegroundColor(preForeground);
            leftShape.dispose();
            rightShape.dispose();
            clientAreaPath.dispose();
            leftColor.dispose();
            rightColor.dispose();
        }
    }
}

