/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.taskinfo;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.xmind.verify.ui.VerifyUI20141031;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.resource.DeviceResourceDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.LocalResourceManager;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseTrackAdapter;
import org.eclipse.swt.events.MouseTrackListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.forms.widgets.ScrolledForm;
import org.xmind.core.INamed;
import org.xmind.ui.forms.WidgetFactory;
import org.xmind.ui.internal.taskinfo.AssigneeItem;
import org.xmind.ui.internal.taskinfo.AssigneeSheet;
import org.xmind.ui.internal.taskinfo.AssigneeSheetManager;
import org.xmind.ui.internal.taskinfo.TaskInfo;
import org.xmind.ui.internal.taskinfo.TaskMessages;
import org.xmind.ui.resources.ColorUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ArrageAssigneeDialog
extends TitleAreaDialog
implements Listener {
    private static final String TITLE_BACKGROUND_COLOR = "#f3f3f3";
    private Label addAssignee;
    private Text assigneeText;
    private WidgetFactory factory;
    private ScrolledForm scroll;
    private Composite compositeformbody;
    private LocalResourceManager resource;

    public ArrageAssigneeDialog(Shell parentShell) {
        super(parentShell);
        if (this.resource == null) {
            this.resource = new LocalResourceManager(JFaceResources.getResources(), (Control)parentShell);
        }
    }

    public void create() {
        this.setTitleAreaColor(((Color)this.resource.get((DeviceResourceDescriptor)ColorUtils.toDescriptor((String)TITLE_BACKGROUND_COLOR))).getRGB());
        super.create();
        this.setTitleImage(null);
        this.setTitle(TaskMessages.ArrageAssigneeDialog_Title);
        this.getShell().setText(TaskMessages.ArrageAssigneeDialog_Message);
        this.setMessage(TaskMessages.PeoplePage_message);
    }

    protected Control createDialogArea(Composite parent) {
        parent.setBackground(ColorConstants.white);
        this.factory = new WidgetFactory(parent.getDisplay());
        this.createAssginText(parent);
        this.createScrollFrom(parent);
        this.scroll.addListener(11, (Listener)this);
        parent.getDisplay().asyncExec(new Runnable(){

            public void run() {
                ArrageAssigneeDialog.this.initAssignee();
            }
        });
        return parent;
    }

    private void createScrollFrom(Composite container) {
        this.scroll = this.factory.createScrolledForm(container);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)this.scroll);
        this.scroll.setBackground(container.getBackground());
        this.scroll.setExpandHorizontal(true);
        this.scroll.setExpandVertical(true);
        this.scroll.setMinWidth(1);
    }

    private void initAssignee() {
        List<AssigneeItemReference> references = this.getInput();
        if (this.compositeformbody == null) {
            this.compositeformbody = this.scroll.getBody();
        }
        for (AssigneeItemReference ref : references) {
            this.createAssigneeViewer(this.compositeformbody, ref.getName());
        }
    }

    private void createAssginText(Composite container) {
        Composite sparator = new Composite(container, 0);
        GridDataFactory.fillDefaults().grab(true, false).hint(-1, 5).applyTo((Control)sparator);
        GridLayoutFactory.fillDefaults().applyTo(sparator);
        Composite parent = new Composite(container, 0);
        GridLayoutFactory.fillDefaults().extendedMargins(0, 0, 0, 0).applyTo(parent);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)parent);
        parent.setBackground(container.getBackground());
        this.createLine(parent);
        Composite textContainer = new Composite(parent, 0);
        textContainer.setBackground(container.getBackground());
        textContainer.setLayout(null);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)textContainer);
        if (this.assigneeText == null) {
            this.assigneeText = new Text(textContainer, 1024);
        }
        this.assigneeText.setBounds(40, 4, 186, 20);
        if (this.addAssignee == null) {
            this.addAssignee = new Label(textContainer, 0);
        }
        this.addAssignee.setBackground(container.getBackground());
        this.addAssignee.setBounds(235, 0, 28, 28);
        this.addAssignee.setFocus();
        this.addAssignee.setImage((Image)this.resource.get((DeviceResourceDescriptor)TaskInfo.imageDescriptorFromPlugin((String)"org.xmind.ui.taskinfo", (String)"icons/ic_add.png")));
        this.revealAddAssignee(this.addAssignee);
        this.hookWidget((Widget)this.addAssignee, 3);
        this.hookWidget((Widget)this.assigneeText, 2);
        this.createLineOfAssignee(parent);
    }

    private void revealAddAssignee(final Label addAssignee) {
        addAssignee.addMouseTrackListener((MouseTrackListener)new MouseTrackAdapter(){

            public void mouseEnter(MouseEvent e) {
                addAssignee.setImage((Image)ArrageAssigneeDialog.this.resource.get((DeviceResourceDescriptor)TaskInfo.imageDescriptorFromPlugin((String)"org.xmind.ui.taskinfo", (String)"icons/ic_add_hover.png")));
            }

            public void mouseExit(MouseEvent e) {
                addAssignee.setImage((Image)ArrageAssigneeDialog.this.resource.get((DeviceResourceDescriptor)TaskInfo.imageDescriptorFromPlugin((String)"org.xmind.ui.taskinfo", (String)"icons/ic_add.png")));
            }
        });
    }

    private Label createAssigneeViewer(Composite container, String name) {
        if (container == null) {
            return null;
        }
        if (name == null) {
            name = this.createAssigneeName();
            if ("".equals(name) || name == null) {
                return null;
            }
            this.addAssignee(name);
        }
        Composite parent = new Composite(container, 0);
        GridLayoutFactory.fillDefaults().applyTo(parent);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)parent);
        parent.setBackground(container.getBackground());
        Composite itemContainer = new Composite(parent, 0);
        itemContainer.setBackground(container.getBackground());
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)itemContainer);
        itemContainer.setLayout(null);
        parent.moveAbove(null);
        Label label = new Label(itemContainer, 0);
        label.setBackground(itemContainer.getBackground());
        label.setText(name);
        label.setBounds(40, 7, 186, 20);
        Label remove = new Label(itemContainer, 0);
        remove.setImage((Image)this.resource.get((DeviceResourceDescriptor)TaskInfo.imageDescriptorFromPlugin((String)"org.xmind.ui.taskinfo", (String)"icons/ic_remove.png")));
        remove.setVisible(false);
        remove.setBackground(itemContainer.getBackground());
        remove.setBounds(230, 1, 28, 28);
        this.configRemoveListener(parent, itemContainer, label, remove);
        this.configLabelListener(label);
        itemContainer.addListener(3, (Listener)this);
        container.addListener(3, (Listener)this);
        this.createLineOfAssignee(parent);
        this.scroll.reflow(true);
        return remove;
    }

    private void createLineOfAssignee(Composite parent) {
        Composite line = new Composite(parent, 0);
        GridDataFactory.fillDefaults().hint(-1, 1).grab(true, false).applyTo((Control)line);
        GridLayoutFactory.fillDefaults().applyTo(line);
        line.setBackground((Color)this.resource.get((DeviceResourceDescriptor)ColorUtils.toDescriptor((String)"#e0e0e0")));
    }

    private void configRemoveListener(Composite parent, Composite itemContainer, final Label label, final Label remove) {
        remove.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDown(MouseEvent e) {
                ArrageAssigneeDialog.this.handleRemove(label, remove);
            }
        });
        Control[] controls = itemContainer.getChildren();
        MouseTrackAdapter mouseTrack = new MouseTrackAdapter(){

            public void mouseEnter(MouseEvent e) {
                if (!remove.isVisible()) {
                    remove.setVisible(true);
                }
            }

            public void mouseExit(MouseEvent e) {
                if (remove.isVisible()) {
                    remove.setVisible(false);
                }
            }
        };
        Control[] controlArray = controls;
        int n = controls.length;
        int n2 = 0;
        while (n2 < n) {
            Control control = controlArray[n2];
            control.addMouseTrackListener((MouseTrackListener)mouseTrack);
            ++n2;
        }
        parent.addMouseTrackListener((MouseTrackListener)mouseTrack);
        itemContainer.addMouseTrackListener((MouseTrackListener)mouseTrack);
        this.removeMouseTrackListener(parent, itemContainer, mouseTrack);
    }

    private void removeMouseTrackListener(final Composite parent, final Composite itemContainer, final MouseTrackAdapter mouseTrack) {
        itemContainer.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                ArrageAssigneeDialog.this.removeControlListeners(itemContainer, mouseTrack);
            }
        });
        parent.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                parent.removeMouseTrackListener((MouseTrackListener)mouseTrack);
            }
        });
    }

    private void configLabelListener(final Label label) {
        label.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDown(MouseEvent e) {
                ArrageAssigneeDialog.this.startRename(label);
            }
        });
    }

    private void removeControlListeners(Composite itemContainer, MouseTrackAdapter mouseTrack) {
        if (itemContainer.isDisposed()) {
            return;
        }
        Control[] controlArray = itemContainer.getChildren();
        int n = controlArray.length;
        int n2 = 0;
        while (n2 < n) {
            Control control = controlArray[n2];
            if (!control.isDisposed()) {
                control.removeMouseTrackListener((MouseTrackListener)mouseTrack);
            }
            ++n2;
        }
        itemContainer.removeMouseTrackListener((MouseTrackListener)mouseTrack);
    }

    private void handleRemove(Label assigneeLabel, Label remove) {
        this.removeSelectedAssignee(assigneeLabel.getText());
        Composite display = remove.getParent().getParent();
        display.dispose();
        this.scroll.reflow(true);
        this.makeRemoveVisible();
        this.addAssignee.setFocus();
    }

    private void makeRemoveVisible() {
        Control control = Display.getDefault().getCursorControl();
        if (control instanceof Label) {
            ((Label)control).setVisible(true);
        } else if (control instanceof Composite) {
            Control[] controls;
            Composite c = (Composite)control;
            Control[] controlArray = controls = c.getChildren();
            int n = controls.length;
            int n2 = 0;
            while (n2 < n) {
                Control label = controlArray[n2];
                if (label instanceof Label && !label.isVisible()) {
                    label.setVisible(true);
                }
                ++n2;
            }
        }
    }

    private void startRename(Label source) {
        source.setVisible(false);
        Text text = new Text(source.getParent(), 2052);
        text.setFont(source.getFont());
        Rectangle bounds = source.getBounds();
        text.setBounds(bounds.x, bounds.y, bounds.width, bounds.height);
        text.setText(source.getText());
        text.selectAll();
        text.setFocus();
        this.configTextListener(source, text);
    }

    private void configTextListener(final Label source, final Text text) {
        text.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusLost(FocusEvent e) {
                ArrageAssigneeDialog.this.finishRename(source, text);
            }
        });
        text.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                if (13 == e.keyCode) {
                    ArrageAssigneeDialog.this.finishRename(source, text);
                }
            }
        });
        text.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                if (!source.isDisposed()) {
                    source.setVisible(true);
                }
            }
        });
    }

    private void finishRename(Label source, Text text) {
        if (text.isDisposed() || source.isDisposed()) {
            return;
        }
        this.renameAssigneeReference(source.getText(), text.getText());
        source.setText(text.getText());
        this.assigneeText.setFocus();
        text.dispose();
    }

    private String createAssigneeName() {
        String assignName = this.assigneeText.getText().trim();
        if (assignName != null && assignName != "" && !this.containAsignee(assignName)) {
            return assignName;
        }
        this.assigneeText.setText("");
        this.assigneeText.setFocus();
        return null;
    }

    private Label createLine(Composite itemContainer) {
        Label line = new Label(itemContainer, 258);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)line);
        line.setBackground(itemContainer.getDisplay().getSystemColor(15));
        return line;
    }

    private List<AssigneeItemReference> getInput() {
        ArrayList<AssigneeItemReference> references = new ArrayList<AssigneeItemReference>();
        for (AssigneeItem item : this.getSheet().getAssignees()) {
            references.add(new AssigneeItemReference(item.getName(), item));
        }
        return references;
    }

    public AssigneeSheet getSheet() {
        return AssigneeSheetManager.getInstance().getAssigneeSheet();
    }

    private boolean containAsignee(String newName) {
        if (newName == null || "".equals(newName)) {
            return false;
        }
        List<AssigneeItemReference> references = this.getInput();
        ArrayList<String> nameExclusions = new ArrayList<String>();
        for (AssigneeItemReference item : references) {
            nameExclusions.add(item.getName());
        }
        return nameExclusions.contains(newName);
    }

    private void hookWidget(Widget widget, int eventType) {
        widget.addListener(eventType, (Listener)this);
    }

    private void addAssignee(String name) {
        AssigneeItem item = this.getSheet().createAssignee();
        item.setName(name);
        this.getSheet().addAssigneeItem(item);
        this.assigneeText.setText("");
        this.assigneeText.setBackground(ColorConstants.white);
        this.assigneeText.setFocus();
        VerifyUI20141031.getUsageDataCollector().increase("AddAssigneeCount");
        this.saveSheet();
    }

    private void removeSelectedAssignee(String assigneeName) {
        List<AssigneeItemReference> references = this.getInput();
        Iterator<AssigneeItemReference> it = references.iterator();
        while (it.hasNext()) {
            AssigneeItemReference assignee = it.next();
            if (!assignee.getName().equals(assigneeName)) continue;
            this.getSheet().removeAssigneeItem(assignee.getItem());
            it.remove();
            this.saveSheet();
            return;
        }
    }

    private void renameAssigneeReference(String oldName, String newName) {
        oldName = oldName.trim();
        if ((newName = newName.trim()) == null || "".equals(newName) || oldName.equals(newName)) {
            return;
        }
        List<AssigneeItemReference> assigneeRefs = this.getInput();
        for (AssigneeItemReference assigneeRef : assigneeRefs) {
            if (!oldName.equals(assigneeRef.getName())) continue;
            assigneeRef.getItem().setName(newName);
            break;
        }
        this.saveSheet();
    }

    public void handleEvent(Event event) {
        if (event.widget == this.addAssignee || event.widget == this.assigneeText && event.keyCode == 13) {
            this.createAssigneeViewer(this.compositeformbody, null);
        } else if (event.type == 3) {
            this.assigneeText.setFocus();
        }
        if (event.widget == this.scroll) {
            this.refreshFrom();
        }
    }

    public void saveSheet() {
        AssigneeSheetManager.getInstance().saveAssigneeSheet();
    }

    private void refreshFrom() {
        if (this.compositeformbody == null) {
            this.compositeformbody = this.scroll.getBody();
            GridLayout scrollLayout = new GridLayout(1, true);
            this.compositeformbody.setLayout((Layout)scrollLayout);
            GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)this.compositeformbody);
        }
        this.scroll.reflow(true);
    }

    protected void createButtonsForButtonBar(Composite parent) {
    }

    protected Control createContents(Composite parent) {
        Control content = super.createContents(parent);
        this.buttonBar.dispose();
        return content;
    }

    private static class AssigneeItemReference
    implements INamed {
        private String name;
        private AssigneeItem item;

        public AssigneeItemReference(String name, AssigneeItem item) {
            this.name = name;
            this.item = item;
        }

        public String getName() {
            if (this.name.length() > 10) {
                this.name = String.valueOf(this.name.substring(0, 10)) + "...";
            }
            return this.name;
        }

        public void setName(String name) {
            if (name.length() > 50) {
                name = name.substring(0, 50);
            }
            this.name = name;
        }

        public AssigneeItem getItem() {
            return this.item;
        }
    }
}

