/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.wizards;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.xmind.core.IFileEntry;
import org.xmind.core.IRelationship;
import org.xmind.core.ISheet;
import org.xmind.core.ITopic;
import org.xmind.core.marker.IMarker;
import org.xmind.core.style.IStyle;
import org.xmind.gef.util.Properties;
import org.xmind.ui.internal.wizards.WizardMessages;
import org.xmind.ui.mindmap.GhostShellProvider;
import org.xmind.ui.mindmap.MindMap;
import org.xmind.ui.mindmap.MindMapImageExporter;
import org.xmind.ui.wizards.IExportPart;
import org.xmind.ui.wizards.IExporter;

public abstract class Exporter
implements IExporter {
    protected static final String Message_FailedToCreateOverview = WizardMessages.DocumentExport_FailedToCreateOverview;
    protected static final String Message_FailedToCopyAttachment = WizardMessages.DocumentExport_FailedToCopyAttachmentFile;
    protected static final String Message_FailedToCopyMarker = WizardMessages.DocumentExport_FailedToCopyMarker;
    private static final List<IExportPart> EMPTY_PARTS = Collections.emptyList();
    private static final List<Map.Entry<Throwable, String>> NO_ERRORS = Collections.emptyList();
    private final ISheet sheet;
    private final ITopic centralTopic;
    private Display display = null;
    private Shell shell = null;
    private List<IExportPart> parts = null;
    private Iterator<IExportPart> partIter = null;
    private IExportPart next = null;
    private List<IRelationship> relationships = null;
    private IDialogSettings dialogSettings = null;
    private List<Map.Entry<Throwable, String>> errors = null;
    private GhostShellProvider overviewExportShellProvider = null;

    public Exporter(ISheet sheet, ITopic centralTopic) {
        this.sheet = sheet;
        this.centralTopic = centralTopic;
    }

    @Override
    public ITopic getCentralTopic() {
        return this.centralTopic;
    }

    @Override
    public ISheet getSheet() {
        return this.sheet;
    }

    @Override
    public void append(IExportPart part) {
        if (this.parts == null) {
            this.parts = new ArrayList<IExportPart>();
        }
        this.parts.add(part);
    }

    @Override
    public int getTotalWork() {
        return this.parts == null ? 0 : this.parts.size();
    }

    @Override
    public boolean canStart() {
        return this.parts != null && !this.parts.isEmpty();
    }

    @Override
    public void start(Display display, Shell shell) throws InvocationTargetException {
        this.display = display;
        this.shell = shell;
        if (this.partIter == null && this.parts != null) {
            this.partIter = this.parts.iterator();
            this.next = this.partIter.hasNext() ? this.partIter.next() : null;
        }
    }

    @Override
    public boolean hasNext() {
        return this.next != null;
    }

    @Override
    public String getNextName() {
        return this.next != null ? this.next.toString() : null;
    }

    @Override
    public void writeNext(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
        if (this.next != null) {
            this.write(monitor, this.next);
            if (this.partIter != null) {
                this.next = this.partIter.hasNext() ? this.partIter.next() : null;
            }
        }
    }

    @Override
    public void end() throws InvocationTargetException {
        this.next = null;
        this.partIter = null;
        if (this.overviewExportShellProvider != null) {
            this.display.syncExec(new Runnable(){

                @Override
                public void run() {
                    Exporter.this.overviewExportShellProvider.dispose();
                }
            });
            this.overviewExportShellProvider = null;
        }
    }

    @Override
    public List<IExportPart> getParts() {
        return this.parts == null ? EMPTY_PARTS : this.parts;
    }

    protected abstract void write(IProgressMonitor var1, IExportPart var2) throws InvocationTargetException, InterruptedException;

    @Override
    public List<IRelationship> getRelationships() {
        if (this.relationships == null) {
            this.relationships = new ArrayList<IRelationship>(this.getSheet().getRelationships());
        }
        return this.relationships;
    }

    public MindMapImageExporter createOverviewExporter(ITopic topic) {
        if (!this.hasOverview(topic)) {
            return null;
        }
        if (this.overviewExportShellProvider == null) {
            this.overviewExportShellProvider = new GhostShellProvider(this.getDisplay());
        }
        Properties properties = new Properties();
        if (this.getBoolean("separateOverview")) {
            properties.set("maxTopicLevel", 1);
        }
        MindMapImageExporter exporter = new MindMapImageExporter(this.getDisplay());
        exporter.setSource(new MindMap(topic.getOwnedSheet(), topic), this.overviewExportShellProvider, properties, null);
        return exporter;
    }

    public boolean hasOverview(ITopic topic) {
        if (!this.getBoolean("includeOverview")) {
            return false;
        }
        if (topic.equals(this.getCentralTopic()) || topic.hasChildren("detached")) {
            return true;
        }
        if (this.getBoolean("separateOverview")) {
            return !topic.getAllChildren().isEmpty();
        }
        return false;
    }

    @Override
    public Display getDisplay() {
        return this.display;
    }

    @Override
    public Shell getShell() {
        return this.shell;
    }

    @Override
    public boolean getBoolean(String propertyName) {
        if (this.dialogSettings != null) {
            return this.dialogSettings.getBoolean(propertyName);
        }
        return false;
    }

    @Override
    public double getDouble(String propertyName, double defaultValue) {
        if (this.dialogSettings != null) {
            try {
                return this.dialogSettings.getDouble(propertyName);
            }
            catch (NumberFormatException numberFormatException) {}
        }
        return defaultValue;
    }

    @Override
    public int getInt(String propertyName, int defaultValue) {
        if (this.dialogSettings != null) {
            try {
                return this.dialogSettings.getInt(propertyName);
            }
            catch (NumberFormatException numberFormatException) {}
        }
        return defaultValue;
    }

    @Override
    public String getString(String propertyName, String defaultValue) {
        String value;
        if (this.dialogSettings != null && (value = this.dialogSettings.get(propertyName)) != null) {
            return value;
        }
        return defaultValue;
    }

    public void setDialogSettings(IDialogSettings dialogSettings) {
        this.dialogSettings = dialogSettings;
    }

    public void log(final Throwable e, final String message) {
        if (this.errors == null) {
            this.errors = new ArrayList<Map.Entry<Throwable, String>>();
        }
        this.errors.add(new Map.Entry<Throwable, String>(){

            @Override
            public Throwable getKey() {
                return e;
            }

            @Override
            public String getValue() {
                return message;
            }

            @Override
            public String setValue(String value) {
                return this.getValue();
            }
        });
    }

    public List<Map.Entry<Throwable, String>> getErrors() {
        return this.errors == null ? NO_ERRORS : this.errors;
    }

    public IStyle getStyle(String styleId) {
        if (styleId == null) {
            return null;
        }
        return this.getSheet().getOwnedWorkbook().getStyleSheet().findStyle(styleId);
    }

    public IMarker getMarker(String markerId) {
        if (markerId == null) {
            return null;
        }
        return this.getSheet().getOwnedWorkbook().getMarkerSheet().findMarker(markerId);
    }

    public IFileEntry getFileEntry(String entryPath) {
        if (entryPath == null) {
            return null;
        }
        return this.getSheet().getOwnedWorkbook().getManifest().getFileEntry(entryPath);
    }
}

