/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.wizards;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchWindow;
import org.xmind.core.util.FileUtils;
import org.xmind.gef.IGraphicalViewer;
import org.xmind.gef.ui.editor.IGraphicalEditor;
import org.xmind.gef.ui.editor.IGraphicalEditorPage;
import org.xmind.ui.internal.dialogs.DialogUtils;
import org.xmind.ui.internal.wizards.UncompletablePage;
import org.xmind.ui.internal.wizards.WizardMessages;
import org.xmind.ui.io.MonitoredOutputStream;
import org.xmind.ui.mindmap.IMindMap;
import org.xmind.ui.mindmap.IMindMapViewer;
import org.xmind.ui.util.Logger;
import org.xmind.ui.util.MindMapUtils;
import org.xmind.ui.wizards.AbstractExportWizard;

public abstract class AbstractMindMapExportWizard
extends AbstractExportWizard {
    private static final int MAX_FILE_NAME_LENGTH = 120;
    private IGraphicalEditor sourceEditor;
    private IGraphicalEditorPage sourcePage;
    private IMindMapViewer sourceViewer;
    private IMindMap sourceMindMap;

    public AbstractMindMapExportWizard() {
        this.setNeedsProgressMonitor(true);
    }

    @Override
    public void init(IWorkbench workbench, IStructuredSelection selection) {
        this.initSources(workbench);
        super.init(workbench, selection);
    }

    protected void initSources(IWorkbench workbench) {
        IMindMapViewer mmv;
        IMindMap mindMap;
        IGraphicalViewer viewer;
        IGraphicalEditor editor;
        IGraphicalEditorPage page;
        IWorkbenchWindow window = workbench.getActiveWorkbenchWindow();
        IEditorPart activeEditor = window.getActivePage().getActiveEditor();
        if (activeEditor instanceof IGraphicalEditor && (page = (editor = (IGraphicalEditor)activeEditor).getActivePageInstance()) != null && (viewer = page.getViewer()) instanceof IMindMapViewer && (mindMap = (mmv = (IMindMapViewer)viewer).getMindMap()) != null) {
            this.setSourceMindMap(mindMap);
            this.setSourceViewer(mmv);
            this.setSourcePage(page);
            this.setSourceEditor(editor);
            return;
        }
        this.setSourceViewer(null);
        this.setSourcePage(null);
        this.setSourceEditor(null);
    }

    @Override
    public void dispose() {
        this.setSourceEditor(null);
        this.setSourcePage(null);
        this.setSourceViewer(null);
        super.dispose();
    }

    public void addPages() {
        if (this.hasSource()) {
            this.addValidPages();
        } else {
            UncompletablePage errorPage = new UncompletablePage(WizardMessages.NoContentPage_title, WizardMessages.NoContentPage_message);
            errorPage.setDescription(WizardMessages.NoContentPage_description);
            this.addPage((IWizardPage)errorPage);
        }
    }

    protected abstract void addValidPages();

    @Override
    public boolean canFinish() {
        return super.canFinish() && this.hasSource();
    }

    public boolean performFinish() {
        if (!this.hasSource() || !this.hasTargetPath()) {
            return false;
        }
        if (!this.isLegalPath(this.getTargetPath())) {
            MessageDialog.openInformation((Shell)this.getShell(), (String)WizardMessages.ExportPage_FindFileFail_title, (String)WizardMessages.ExportPage_FindFileFail_message);
            return false;
        }
        if (!this.isExtensionCompatible(this.getTargetPath(), FileUtils.getExtension((String)this.getTargetPath()))) {
            String fileName = new File(this.getTargetPath()).getName();
            String formatName = this.getFormatName();
            String messages = NLS.bind((String)WizardMessages.Export_UncompatibleFormat_message, (Object)fileName, (Object)formatName);
            if (!MessageDialog.openConfirm((Shell)this.getShell(), (String)WizardMessages.Export_UncompatibleFormat_title, (String)messages)) {
                return false;
            }
        }
        this.setTargetPath(this.trimPath(this.getTargetPath()));
        if (!this.isOverwriteWithoutPrompt() && new File(this.getTargetPath()).exists() && !DialogUtils.confirmOverwrite(this.getShell(), this.getTargetPath())) {
            return false;
        }
        return this.doExport();
    }

    private boolean isLegalPath(String targetPath) {
        boolean isLagel = true;
        String path = targetPath.substring(0, targetPath.lastIndexOf(File.separator));
        File directory = new File(path);
        if (!directory.exists() || !directory.isDirectory()) {
            isLagel = false;
            return isLagel;
        }
        String fileName = targetPath.substring(targetPath.lastIndexOf(File.separator) + 1);
        String[] letters = new String[]{"/", ":", "\\", "*", "?", "\"", "<", ">", "|"};
        int i = 0;
        while (i < letters.length) {
            if (fileName.indexOf(letters[i]) != -1) {
                isLagel = false;
                return isLagel;
            }
            ++i;
        }
        return isLagel;
    }

    private String trimPath(String path) {
        String dirPath = path.substring(0, path.lastIndexOf(File.separator) + 1);
        String fileName = FileUtils.getNoExtensionFileName((String)path);
        if (fileName.length() > 120) {
            fileName = fileName.substring(0, 120);
        }
        return String.valueOf(dirPath) + fileName + FileUtils.getExtension((String)path);
    }

    /*
     * Unable to fully structure code
     */
    protected boolean doExport() {
        display = Display.getCurrent();
        parentShell = this.findParentShell(display);
        try {
            this.getContainer().run(true, true, new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    try {
                        AbstractMindMapExportWizard.this.doExport(monitor, display, parentShell);
                    }
                    catch (OutOfMemoryError e) {
                        try {
                            throw new Exception(WizardMessages.ImageTooLarge_Error, e);
                        }
                        catch (Exception e2) {
                            throw new InvocationTargetException(e2);
                        }
                    }
                }
            });
            return true;
        }
        catch (Throwable e) {
            if (!(e instanceof InterruptedException) && !(e instanceof InterruptedIOException)) ** GOTO lbl11
            return false;
        }
        while ((t = ((InvocationTargetException)e).getCause()) != null) {
            e = t;
lbl11:
            // 2 sources

            if (e instanceof InvocationTargetException) continue;
        }
        ex = e;
        display.asyncExec(new Runnable((Throwable)ex){
            private final /* synthetic */ Throwable val$ex;
            {
                this.val$ex = throwable;
            }

            @Override
            public void run() {
                AbstractMindMapExportWizard.this.handleExportException(this.val$ex);
            }
        });
        return false;
    }

    protected void handleExportException(Throwable e) {
        Logger.log(e, NLS.bind((String)WizardMessages.Export_FailedWhenExport, (Object)this.getFormatName()));
        e.printStackTrace();
        if (e instanceof FileNotFoundException) {
            MessageDialog.openInformation((Shell)this.getShell(), (String)WizardMessages.ExportPage_FindFileFail_title, (String)WizardMessages.ExportPage_FindFileFail_message);
        }
    }

    private Shell findParentShell(Display display) {
        Shell parentShell;
        Composite shellParent;
        Shell shell = this.getContainer().getShell();
        if (shell != null && (shellParent = shell.getParent()) instanceof Shell && !(parentShell = (Shell)shellParent).isDisposed() && parentShell.getDisplay() == display) {
            return parentShell;
        }
        return null;
    }

    protected abstract void doExport(IProgressMonitor var1, Display var2, Shell var3) throws InvocationTargetException, InterruptedException;

    protected OutputStream wrapMonitor(OutputStream realStream, IProgressMonitor monitor) {
        return new MonitoredOutputStream(realStream, monitor);
    }

    public IGraphicalEditor getSourceEditor() {
        return this.sourceEditor;
    }

    public IGraphicalEditorPage getSourcePage() {
        return this.sourcePage;
    }

    public IMindMapViewer getSourceViewer() {
        return this.sourceViewer;
    }

    public void setSourceEditor(IGraphicalEditor sourceEditor) {
        this.sourceEditor = sourceEditor;
    }

    public void setSourcePage(IGraphicalEditorPage sourcePage) {
        this.sourcePage = sourcePage;
    }

    public void setSourceViewer(IMindMapViewer sourceViewer) {
        this.sourceViewer = sourceViewer;
    }

    public IMindMap getSourceMindMap() {
        return this.sourceMindMap;
    }

    public void setSourceMindMap(IMindMap sourceMindMap) {
        this.sourceMindMap = sourceMindMap;
    }

    public boolean hasSource() {
        return this.sourceEditor != null && this.sourcePage != null && this.sourceViewer != null && this.sourceViewer.getInput() != null && this.sourceMindMap != null;
    }

    protected abstract String getFormatName();

    protected boolean isExtensionCompatible(String path, String extension) {
        return true;
    }

    @Override
    protected String getSuggestedFileName() {
        IMindMap mindMap = this.getSourceMindMap();
        if (mindMap == null) {
            return WizardMessages.ExportWizard_SuggestedFileName;
        }
        String fileName = mindMap.getCentralTopic().getTitleText();
        String replacedFileName = MindMapUtils.trimFileName(fileName);
        if (replacedFileName.length() > 120) {
            replacedFileName = replacedFileName.substring(0, 120);
        }
        return replacedFileName;
    }
}

