/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.util;

public class NumberUtils {
    public static final int DEFAULT_MAX_ROUND = 10000;
    public static final double DEFAULT_EPSILONG = 1.0E-8;

    private NumberUtils() {
    }

    public static long safeParseLong(String s, long defaultLong) {
        try {
            return Long.parseLong(s);
        }
        catch (Exception exception) {
            return defaultLong;
        }
    }

    public static int safeParseInt(String s, int defaultInt) {
        if (s == null || "".equals(s)) {
            return defaultInt;
        }
        int result = 0;
        int radix = 10;
        int i = 0;
        int max = s.length();
        int limit = -2147483647;
        int multmin = limit / radix;
        if (max > 0) {
            int digit;
            if (i < max) {
                if ((digit = Character.digit(s.charAt(i++), radix)) < 0) {
                    return defaultInt;
                }
                result = -digit;
            }
            while (i < max) {
                if ((digit = Character.digit(s.charAt(i++), radix)) < 0) {
                    return -result;
                }
                if (result < multmin) {
                    return -result;
                }
                if ((result *= radix) < limit + digit) {
                    return -result;
                }
                result -= digit;
            }
            return -result;
        }
        return defaultInt;
    }

    public static int safeParseInt(String s) {
        return NumberUtils.safeParseInt(s, -1);
    }

    public static double safeParseDouble(String s) {
        return NumberUtils.safeParseDouble(s, 0.0);
    }

    public static double safeParseDouble(String s, double defaultDouble) {
        if (s == null || "".equals(s)) {
            return defaultDouble;
        }
        try {
            return Double.parseDouble(s);
        }
        catch (Exception exception) {
            return defaultDouble;
        }
    }

    public static String toLetter(int digit, char start, int total) {
        if (digit <= total) {
            return String.valueOf((char)(digit + start - 1));
        }
        int x = digit / total;
        int y = digit - x * total;
        if (y == 0) {
            y = total;
            --x;
        }
        return String.valueOf(NumberUtils.toLetter(x, start, total)) + NumberUtils.toLetter(y, start, total);
    }

    public static double newton(double[] coefs, double x0) {
        return NumberUtils.newton(coefs, x0, 10000, 1.0E-8);
    }

    public static double newton(double[] coefs, double x0, int max, double eps) {
        double current;
        if (coefs == null) {
            throw new IllegalArgumentException("coefficient list is null");
        }
        if (coefs.length <= 1) {
            throw new IllegalArgumentException("coefficients are too few to calculate");
        }
        eps = Math.abs(eps);
        double last = current = x0;
        double sig = 1.0;
        int i = 0;
        while (Math.abs(sig) > eps) {
            if (++i >= max) break;
            current = last - NumberUtils.f(coefs, last) / NumberUtils.df(coefs, last);
            sig = current - last;
            last = current;
        }
        return current;
    }

    static double f(double[] coefs, double x) {
        double y = 0.0;
        int i = 0;
        while (i < coefs.length) {
            y += coefs[i] * Math.pow(x, coefs.length - 1 - i);
            ++i;
        }
        return y;
    }

    static double df(double[] coefs, double x) {
        double y = 0.0;
        int i = 0;
        while (i < coefs.length - 1) {
            y += coefs[i] * (double)(coefs.length - 1 - i) * Math.pow(x, coefs.length - 2 - i);
            ++i;
        }
        return y;
    }

    public static short bytesToShort16(byte highByte, byte lowByte) {
        return (short)(highByte << 8 | lowByte & 0xFF);
    }

    public static String toRoman(long n) {
        StringBuilder sb = new StringBuilder(10);
        RomanSymbols[] symbols = RomanSymbols.values();
        while (n > 0L) {
            int i = 0;
            while (i < symbols.length) {
                if (symbols[i].value <= n) {
                    int shift = i + i % 2;
                    if (i > 0 && shift < symbols.length && symbols[i - 1].value - symbols[shift].value <= n) {
                        sb.append(symbols[shift].name());
                        sb.append(symbols[i - 1].name());
                        n = n - symbols[i - 1].value + symbols[shift].value;
                        i = -1;
                    } else {
                        sb.append(symbols[i].name());
                        n -= symbols[i].value;
                        i = -1;
                    }
                }
                ++i;
            }
        }
        return sb.toString();
    }

    public static String toSimpleChinese(int n) {
        String[] num = new String[]{"\u96f6", "\u4e00", "\u4e8c", "\u4e09", "\u56db", "\u4e94", "\u516d", "\u4e03", "\u516b", "\u4e5d"};
        String[] xx = new String[]{"\u5341", "\u767e", "\u5343"};
        StringBuilder sb = new StringBuilder();
        int bs = 0;
        while ((int)((long)n / (long)Math.pow(10.0, bs)) != 0) {
            ++bs;
        }
        if (bs > 4) {
            return "";
        }
        int i = bs - 1;
        while (i >= 0) {
            int index = (int)((double)n / Math.pow(10.0, i));
            sb.append(num[index]);
            if (index != 0 && i > 0) {
                sb.append(xx[i - 1]);
            }
            n = (int)((double)n - (double)index * Math.pow(10.0, i));
            --i;
        }
        return sb.toString();
    }

    public static String toTraditionalChinese(int n) {
        String[] num = new String[]{"\u96f6", "\u58f9", "\u8cb3", "\u53c3", "\u8086", "\u4f0d", "\u9678", "\u67d2", "\u634c", "\u7396"};
        String[] xx = new String[]{"\u62fe", "\u4f70", "\u4edf"};
        StringBuilder sb = new StringBuilder();
        int bs = 0;
        while ((int)((long)n / (long)Math.pow(10.0, bs)) != 0) {
            ++bs;
        }
        if (bs > 4) {
            return "";
        }
        int i = bs - 1;
        while (i >= 0) {
            int index = (int)((double)n / Math.pow(10.0, i));
            sb.append(num[index]);
            if (index != 0 && i > 0) {
                sb.append(xx[i - 1]);
            }
            n = (int)((double)n - (double)index * Math.pow(10.0, i));
            --i;
        }
        return sb.toString();
    }

    public static enum RomanSymbols {
        M(1000),
        D(500),
        C(100),
        L(50),
        X(10),
        V(5),
        I(1);

        public final long value;

        private RomanSymbols(int value) {
            this.value = value;
        }
    }
}

