/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.wizards;

import java.io.ByteArrayOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.xmind.core.ISheet;
import org.xmind.core.ITopic;
import org.xmind.ui.internal.MindMapUIPlugin;
import org.xmind.ui.internal.wizards.TextExporter;
import org.xmind.ui.internal.wizards.WizardMessages;
import org.xmind.ui.mindmap.IMindMap;
import org.xmind.ui.mindmap.MindMapUI;
import org.xmind.ui.util.Logger;
import org.xmind.ui.wizards.AbstractMindMapExportPage;
import org.xmind.ui.wizards.AbstractMindMapExportWizard;
import org.xmind.ui.wizards.IExporter;

public class TextExportWizard
extends AbstractMindMapExportWizard {
    private static final String TEXT_EXPORT_PAGE_NAME = "textExportPage";
    private static final String DIALOG_SETTINGS_SECTION_ID = "org.xmind.ui.export.text";
    private static final String EXT_TEXT_FILE = ".txt";
    private static final String FILTER_TEXT = "*.txt";
    private TextExportPage page;

    public TextExportWizard() {
        this.setWindowTitle(WizardMessages.TextExportWizard_windowTitle);
        this.setDefaultPageImageDescriptor(MindMapUI.getImages().getWizBan("export_wiz.png"));
        this.setDialogSettings(MindMapUIPlugin.getDefault().getDialogSettings(DIALOG_SETTINGS_SECTION_ID));
    }

    @Override
    protected void addValidPages() {
        this.page = new TextExportPage();
        this.addPage((IWizardPage)this.page);
    }

    @Override
    protected void doExport(IProgressMonitor monitor, Display display, Shell parentShell) throws InvocationTargetException, InterruptedException {
        FileOutputStream fileOut;
        monitor.beginTask(null, 100);
        monitor.subTask(WizardMessages.Export_Initializing);
        IExporter exporter = this.createExporter();
        if (exporter == null) {
            this.page.setErrorMessage(WizardMessages.TextExportPage_NoContentToExport_message);
            throw new InterruptedException();
        }
        monitor.worked(10);
        int total = exporter.getTotalWork();
        int worked = 0;
        int uiTotal = 88;
        int uiWorked = 0;
        try {
            fileOut = new FileOutputStream(this.getTargetPath());
        }
        catch (IOException e) {
            throw new InvocationTargetException(e);
        }
        try {
            OutputStream out = this.wrapMonitor(fileOut, monitor);
            try {
                PrintStream ps = TextExportWizard.createPrintStream(out);
                try {
                    ((TextExporter)exporter).setPrintStream(ps);
                    if (!exporter.canStart()) {
                        this.page.setErrorMessage(WizardMessages.TextExportPage_NoContentToExport_message);
                        throw new InterruptedException();
                    }
                    exporter.start(display, parentShell);
                    while (exporter.hasNext()) {
                        monitor.subTask(this.cleanFileName(exporter.getNextName()));
                        exporter.writeNext(monitor);
                        int newUIWorked = ++worked * uiTotal / total;
                        if (newUIWorked <= uiWorked) continue;
                        monitor.worked(newUIWorked - uiWorked);
                        uiWorked = newUIWorked;
                    }
                }
                finally {
                    ps.close();
                }
            }
            catch (Throwable throwable) {
                try {
                    out.close();
                }
                catch (IOException iOException) {}
                throw throwable;
            }
            try {
                out.close();
            }
            catch (IOException iOException) {}
        }
        catch (Throwable throwable) {
            try {
                ((OutputStream)fileOut).close();
            }
            catch (IOException iOException) {}
            throw throwable;
        }
        try {
            ((OutputStream)fileOut).close();
        }
        catch (IOException iOException) {}
        if (uiWorked < uiTotal) {
            monitor.worked(uiTotal - uiWorked);
        }
        monitor.subTask(WizardMessages.Export_Finishing);
        exporter.end();
        monitor.worked(1);
        this.launchTargetFile(true, monitor, display, parentShell);
        monitor.done();
    }

    private static PrintStream createPrintStream(OutputStream out) {
        try {
            return new UnicodePrintStream(out);
        }
        catch (UnsupportedEncodingException e) {
            Logger.log(e, "Unable to export text with utf-8 encoding.");
            return new PrintStream(out);
        }
    }

    protected IExporter createExporter() {
        IMindMap map = this.getSourceMindMap();
        ISheet sheet = map.getSheet();
        ITopic centralTopic = map.getCentralTopic();
        TextExporter exporter = new TextExporter(sheet, centralTopic);
        exporter.setDialogSettings(this.getDialogSettings());
        exporter.init();
        return exporter;
    }

    @Override
    protected String getFormatName() {
        return WizardMessages.TextExportWizard_formatName;
    }

    @Override
    protected String getSuggestedFileName() {
        return String.valueOf(super.getSuggestedFileName()) + EXT_TEXT_FILE;
    }

    @Override
    protected boolean doExport() {
        MindMapUIPlugin.getDefault().getUsageDataCollector().increase("ExportToTxtCount");
        return super.doExport();
    }

    static /* synthetic */ OutputStream access$0(TextExportWizard textExportWizard, OutputStream outputStream, IProgressMonitor iProgressMonitor) {
        return textExportWizard.wrapMonitor(outputStream, iProgressMonitor);
    }

    static /* synthetic */ PrintStream access$1(OutputStream outputStream) {
        return TextExportWizard.createPrintStream(outputStream);
    }

    static /* synthetic */ String access$2(TextExportWizard textExportWizard, String string) {
        return textExportWizard.cleanFileName(string);
    }

    private class TextExportPage
    extends AbstractMindMapExportPage {
        private Text previewControl;
        private Job generatePreviewJob;

        public TextExportPage() {
            super(TextExportWizard.TEXT_EXPORT_PAGE_NAME, WizardMessages.TextExportPage_title);
            this.generatePreviewJob = null;
            this.setDescription(WizardMessages.TextExportPage_description);
        }

        public void createControl(Composite parent) {
            Composite composite = new Composite(parent, 0);
            GridLayout layout = new GridLayout();
            layout.verticalSpacing = 15;
            composite.setLayout((Layout)layout);
            this.setControl((Control)composite);
            this.createPreviewGroup(composite);
            Control fileGroup = this.createFileControls(composite);
            fileGroup.setLayoutData((Object)new GridData(4, 4, true, false));
        }

        private void createPreviewGroup(Composite parent) {
            Group group = new Group(parent, 0);
            group.setLayoutData((Object)new GridData(4, 4, true, true));
            group.setLayout((Layout)new GridLayout(1, false));
            group.setText(WizardMessages.TextExportPage_PreviewGroup_title);
            this.previewControl = new Text((Composite)group, 2826);
            this.previewControl.setEditable(false);
            this.previewControl.setLayoutData((Object)new GridData(4, 4, true, true));
            this.generatePreview();
        }

        private void generatePreview() {
            this.cancel();
            this.previewControl.setText("");
            this.generatePreviewJob = new GeneratePreviewJob(Display.getCurrent());
            this.generatePreviewJob.schedule();
        }

        public void cancel() {
            if (this.generatePreviewJob != null) {
                this.generatePreviewJob.cancel();
                this.generatePreviewJob = null;
            }
        }

        @Override
        protected FileDialog createBrowseDialog() {
            FileDialog dialog = super.createBrowseDialog();
            dialog.setFilterNames(new String[]{WizardMessages.TextExportPage_FileDialog_TextFile, WizardMessages.ExportPage_FileDialog_AllFiles});
            dialog.setFilterExtensions(new String[]{TextExportWizard.FILTER_TEXT, "*.*"});
            return dialog;
        }

        @Override
        public void dispose() {
            this.cancel();
            super.dispose();
            this.previewControl = null;
        }

        static /* synthetic */ TextExportWizard access$1(TextExportPage textExportPage) {
            return textExportPage.TextExportWizard.this;
        }

        private class GeneratePreviewJob
        extends Job {
            private Display display;

            public GeneratePreviewJob(Display display) {
                super(WizardMessages.TextExportPage_GeneratePreview_jobName);
                this.display = display;
            }

            /*
             * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
             * Unable to fully structure code
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            protected IStatus run(IProgressMonitor monitor) {
                monitor.beginTask(null, 100);
                monitor.subTask(WizardMessages.TextExportPage_GeneratePreview_CollectingMapInfo);
                exporter = TextExportPage.access$1(TextExportPage.this).createExporter();
                if (exporter == null) {
                    return new Status(8, "org.xmind.ui.mindmap", WizardMessages.TextExportPage_GeneratePreview_NoContent);
                }
                monitor.worked(10);
                byteOut = new ByteArrayOutputStream(50);
                out = TextExportWizard.access$0(TextExportPage.access$1(TextExportPage.this), byteOut, monitor);
                ps = TextExportWizard.access$1(out);
                ((TextExporter)exporter).setPrintStream(ps);
                if (!exporter.canStart()) {
                    return new Status(8, "org.xmind.ui.mindmap", WizardMessages.TextExportPage_GeneratePreview_NoContent);
                }
                total = exporter.getTotalWork();
                worked = 0;
                uiTotal = 90;
                uiWorked = 0;
                lastRefresh = System.currentTimeMillis();
                try {
                    exporter.start(this.display, null);
                    if (true) ** GOTO lbl58
                }
                catch (InvocationTargetException v0) {
                    return new Status(8, "org.xmind.ui.mindmap", WizardMessages.TextExportPage_GeneratePreview_Canceled);
                }
                while (true) {
                    try {
                        if (!monitor.isCanceled()) ** GOTO lbl-1000
                        var14_12 = new Status(8, "org.xmind.ui.mindmap", WizardMessages.TextExportPage_GeneratePreview_Canceled);
                        ps.close();
                        ** GOTO lbl44
                    }
                    catch (Throwable v1) {
                        var14_13 = new Status(8, "org.xmind.ui.mindmap", WizardMessages.TextExportPage_GeneratePreview_Canceled);
                        ps.close();
                        try {
                            out.close();
                            return var14_13;
                        }
                        catch (IOException v2) {}
                        return var14_13;
                        catch (Throwable var13_14) {
                            ps.close();
                            try {
                                out.close();
                                throw var13_14;
                            }
                            catch (IOException v3) {}
                            throw var13_14;
                        }
lbl44:
                        // 1 sources

                        try {
                            out.close();
                            return var14_12;
                        }
                        catch (IOException v4) {}
                        return var14_12;
lbl-1000:
                        // 1 sources

                        {
                            monitor.subTask(TextExportWizard.access$2(TextExportPage.access$1(TextExportPage.this), exporter.getNextName()));
                            exporter.writeNext(monitor);
                            newUIWorked = ++worked * uiTotal / total;
                            if (newUIWorked > uiWorked) {
                                monitor.worked(newUIWorked - uiWorked);
                                uiWorked = newUIWorked;
                            }
                            if (System.currentTimeMillis() - lastRefresh <= 100L) continue;
                            this.refreshControl(byteOut.toString());
                            lastRefresh = System.currentTimeMillis();
lbl58:
                            // 3 sources

                            if (exporter.hasNext()) continue;
                        }
                    }
                    break;
                }
                ps.close();
                try {
                    out.close();
                }
                catch (IOException v5) {}
                try {
                    exporter.end();
                }
                catch (InvocationTargetException v6) {
                    return new Status(8, "org.xmind.ui.mindmap", WizardMessages.TextExportPage_GeneratePreview_Canceled);
                }
                if (ps instanceof UnicodePrintStream) {
                    try {
                        this.refreshControl(byteOut.toString("utf-8"));
                    }
                    catch (UnsupportedEncodingException v7) {
                        this.refreshControl(byteOut.toString());
                    }
                } else {
                    this.refreshControl(byteOut.toString());
                }
                monitor.done();
                return new Status(0, "org.xmind.ui.mindmap", WizardMessages.TextExportPage_GeneratePreview_Completed);
            }

            private void refreshControl(final String text) {
                this.display.asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        if (TextExportPage.this.previewControl != null && !TextExportPage.this.previewControl.isDisposed()) {
                            TextExportPage.this.previewControl.setText(text);
                        }
                    }
                });
            }
        }
    }

    private static class UnicodePrintStream
    extends PrintStream {
        public UnicodePrintStream(OutputStream out) throws UnsupportedEncodingException {
            super(out, false, "utf-8");
        }
    }
}

