/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.tools;

import org.eclipse.core.runtime.Assert;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.jface.fieldassist.IContentProposalProvider;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.xmind.gef.IViewer;
import org.xmind.gef.Request;
import org.xmind.gef.part.IGraphicalEditPart;
import org.xmind.gef.part.IPart;
import org.xmind.ui.internal.tools.LabelProposalProvider;
import org.xmind.ui.mindmap.ILabelPart;
import org.xmind.ui.mindmap.ITopicPart;
import org.xmind.ui.texteditor.ContentProposalAdapter;
import org.xmind.ui.texteditor.FloatingTextEditor;
import org.xmind.ui.texteditor.FloatingTextEditorContentAssistAdapter;
import org.xmind.ui.texteditor.FloatingTextEditorHelper;
import org.xmind.ui.tools.MindMapEditToolBase;
import org.xmind.ui.util.MindMapUtils;

public class LabelEditTool
extends MindMapEditToolBase {
    private LabelEditorHelper helper = null;
    private ILabelPart label = null;
    protected ContentProposalAdapter contentProposalAdapter = null;

    public LabelEditTool() {
        this.addEditRequestType("edit_label");
    }

    public ILabelPart getLabelPart() {
        return this.label;
    }

    protected boolean canEdit(IGraphicalEditPart target) {
        return super.canEdit(target) && target instanceof ITopicPart;
    }

    public void setSource(IGraphicalEditPart source) {
        Assert.isTrue((boolean)(source instanceof ITopicPart));
        this.label = ((ITopicPart)source).getOwnerBranch().getLabel();
        super.setSource(source);
    }

    @Override
    protected String getInitialText(IPart source) {
        if (this.label != null) {
            return this.label.getLabelText();
        }
        return MindMapUtils.getLabelText(((ITopicPart)source).getTopic().getLabels());
    }

    @Override
    protected Request createTextRequest(IPart source, IDocument document) {
        Request request = this.createTargetedRequest("modify_label", (IViewer)this.getTargetViewer(), false);
        request.setParameter("text", (Object)document.get());
        return request;
    }

    protected void hookEditor(FloatingTextEditor editor) {
        super.hookEditor(editor);
        if (this.helper == null) {
            this.helper = new LabelEditorHelper();
        }
        this.helper.setEditor(editor);
        this.helper.setViewer(this.getTargetViewer());
        this.helper.setFigure(this.getHookFigure());
        this.helper.activate();
    }

    private IFigure getHookFigure() {
        if (this.label != null) {
            return this.label.getFigure();
        }
        return this.getSource().getFigure();
    }

    protected void unhookEditor(FloatingTextEditor editor) {
        if (this.helper != null) {
            this.helper.deactivate();
        }
        super.unhookEditor(editor);
    }

    @Override
    protected void hookEditorControl(FloatingTextEditor editor, ITextViewer textViewer) {
        super.hookEditorControl(editor, textViewer);
        LabelProposalProvider proposalProvider = new LabelProposalProvider((IPart)this.getSource());
        if (this.contentProposalAdapter == null) {
            this.contentProposalAdapter = new FloatingTextEditorContentAssistAdapter(editor, (IContentProposalProvider)proposalProvider);
            this.contentProposalAdapter.setProposalAcceptanceStyle(2);
            this.contentProposalAdapter.setPopupSize(new Point(180, 80));
            final Image labelImage = this.createLabelProposalImage();
            if (labelImage != null) {
                this.contentProposalAdapter.setLabelProvider((ILabelProvider)new LabelProvider(){

                    public Image getImage(Object element) {
                        return labelImage;
                    }
                });
            }
            editor.getControl().addDisposeListener(new DisposeListener(){

                public void widgetDisposed(DisposeEvent e) {
                    LabelEditTool.this.contentProposalAdapter.setLabelProvider(null);
                    LabelEditTool.this.contentProposalAdapter = null;
                    if (labelImage != null) {
                        labelImage.dispose();
                    }
                }
            });
        } else {
            this.contentProposalAdapter.setContentProposalProvider((IContentProposalProvider)proposalProvider);
        }
    }

    private Image createLabelProposalImage() {
        return null;
    }

    private class LabelEditorHelper
    extends FloatingTextEditorHelper {
        private int prefHeight;

        public LabelEditorHelper() {
            super(true);
            this.prefHeight = -1;
            this.setMinWidth(160);
        }

        protected Font getPreferredFont(IFigure figure) {
            if (LabelEditTool.this.label != null && figure == LabelEditTool.this.label.getFigure()) {
                return super.getPreferredFont(figure);
            }
            return JFaceResources.getDefaultFont();
        }

        protected Rectangle calcPreferredBounds(IFigure figure, Rectangle bounds) {
            if (LabelEditTool.this.label == null || figure != LabelEditTool.this.label.getFigure()) {
                bounds = bounds.getTranslated(0, bounds.height);
                if (this.prefHeight < 0) {
                    this.prefHeight = this.getPreferredFont(figure).getFontData()[0].getHeight();
                }
                bounds.height = this.prefHeight;
            }
            return super.calcPreferredBounds(figure, bounds);
        }
    }
}

