/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.svgsupport;

import java.util.LinkedList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.draw2d.Graphics;
import org.xmind.ui.internal.svgsupport.SVGDefinitionConstants;
import org.xmind.ui.internal.svgsupport.TransformElement;

public class SVGTransform {
    public static final Pattern pattern = Pattern.compile("(translate)|(rotate)|(scale)|([+-]?\\d+(\\.\\d+)?)");
    private LinkedList<TransformElement> list = new LinkedList();
    private float[] matrix = new float[]{1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f};
    private boolean isMatrix = false;

    public void parseTransform(String transform) {
        if (transform.startsWith("matrix")) {
            this.isMatrix = true;
            this.parseTransformMatrix(transform);
        } else {
            this.parseTransformList(transform);
        }
    }

    private void parseTransformList(String transform) {
        Matcher match = pattern.matcher(transform);
        LinkedList<String> tokens = new LinkedList<String>();
        while (match.find()) {
            tokens.add(match.group());
        }
        while (!tokens.isEmpty()) {
            String tmp;
            String type = (String)tokens.removeFirst();
            if (type.equals("translate")) {
                this.list.add(new Translate(Float.valueOf((String)tokens.removeFirst()).floatValue(), Float.valueOf((String)tokens.removeFirst()).floatValue()));
                continue;
            }
            if (type.equals(SVGDefinitionConstants.ROTATE)) {
                String angle = (String)tokens.removeFirst();
                if (tokens.isEmpty()) {
                    this.list.addLast(new Rotate(Float.valueOf(angle).floatValue()));
                    break;
                }
                tmp = (String)tokens.getFirst();
                if (tmp.equals("translate") || tmp.equals(SVGDefinitionConstants.ROTATE) || tmp.equals(SVGDefinitionConstants.SCALE)) {
                    this.list.addLast(new Rotate(Float.valueOf(angle).floatValue()));
                    continue;
                }
                this.list.addLast(new Rotate(Float.valueOf(angle).floatValue(), Float.valueOf((String)tokens.removeFirst()).floatValue(), Float.valueOf((String)tokens.removeFirst()).floatValue()));
                continue;
            }
            if (!type.equals(SVGDefinitionConstants.SCALE)) continue;
            String hScale = (String)tokens.removeFirst();
            if (tokens.isEmpty()) {
                this.list.addLast(new Scale(Float.valueOf(hScale).floatValue()));
                break;
            }
            tmp = (String)tokens.getFirst();
            if (tmp.equals("translate") || tmp.equals(SVGDefinitionConstants.ROTATE) || tmp.equals(SVGDefinitionConstants.SCALE)) {
                this.list.addLast(new Scale(Float.valueOf(hScale).floatValue()));
                continue;
            }
            this.list.addLast(new Scale(Float.valueOf(hScale).floatValue(), Float.valueOf((String)tokens.removeFirst()).floatValue()));
        }
    }

    private void parseTransformMatrix(String transform) {
        String[] strs = transform.split("[(]")[1].split("[)]")[0].split(" +");
        this.matrix[0] = Float.valueOf(strs[0]).floatValue();
        this.matrix[1] = Float.valueOf(strs[1]).floatValue();
        this.matrix[2] = Float.valueOf(strs[2]).floatValue();
        this.matrix[3] = Float.valueOf(strs[3]).floatValue();
        this.matrix[4] = Float.valueOf(strs[4]).floatValue();
        this.matrix[5] = Float.valueOf(strs[5]).floatValue();
    }

    public LinkedList<TransformElement> getList() {
        return this.list;
    }

    public boolean isMatrix() {
        return this.isMatrix;
    }

    private static class Rotate
    implements TransformElement {
        private float angle;
        private float dx;
        private float dy;

        public Rotate(float angle) {
            this.angle = angle;
        }

        Rotate(float angle, float dx, float dy) {
            this(angle);
            this.dx = dx;
            this.dy = dy;
        }

        @Override
        public void transform(Graphics graphics) {
            graphics.translate(this.dx, this.dy);
            graphics.rotate(this.angle);
            graphics.translate(-this.dx, -this.dy);
        }

        public String toString() {
            return "rotate:" + this.angle;
        }
    }

    private static class Scale
    implements TransformElement {
        private float hScale = 1.0f;
        private float vScale = 1.0f;

        public Scale(float hScale) {
            this(hScale, hScale);
        }

        public Scale(float hScale, float vScale) {
            this.hScale = hScale;
            this.vScale = vScale;
        }

        @Override
        public void transform(Graphics graphics) {
            graphics.scale(this.hScale, this.vScale);
        }

        public String toString() {
            return "scale:" + this.hScale + "," + this.vScale;
        }
    }

    private static class Translate
    implements TransformElement {
        private float dx;
        private float dy;

        public Translate(float dx, float dy) {
            this.dx = dx;
            this.dy = dy;
        }

        @Override
        public void transform(Graphics graphics) {
            graphics.translate(this.dx, this.dy);
        }

        public String toString() {
            return "translate:" + this.dx + "," + this.dy;
        }
    }
}

