/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.svgsupport;

import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.jface.resource.ResourceManager;
import org.xmind.gef.draw2d.ReferencedFigure;
import org.xmind.ui.internal.svgsupport.SVGImageData;

public class SVGImageFigure
extends ReferencedFigure {
    private static final Rectangle IMAGE_CLIENT_AREA = new Rectangle();
    private static final int FLAG_STRETCHED = MAX_FLAG << 1;
    private static final int FLAG_CONSTRAINED;
    private SVGImageData svgData = null;
    private Dimension imgSize = null;
    private int alpha = -1;
    private ResourceManager manager;

    static {
        MAX_FLAG = FLAG_CONSTRAINED = MAX_FLAG << 2;
    }

    public SVGImageFigure() {
        this(null);
    }

    public SVGImageFigure(SVGImageData svgData) {
        this.setSVGData(svgData);
    }

    public void setSVGData(SVGImageData svgData) {
        if (this.svgData == svgData) {
            return;
        }
        this.svgData = svgData;
        this.setMinimumSize(new Dimension(1, 1));
        this.revalidate();
        this.repaint();
    }

    public Dimension getImageSize() {
        if (this.imgSize == null) {
            this.imgSize = this.svgData != null ? new Dimension(this.svgData.getSize()) : new Dimension();
        }
        return this.imgSize;
    }

    public boolean isConstrained() {
        return this.getFlag(FLAG_CONSTRAINED);
    }

    public void setConstrained(boolean constrained) {
        if (constrained == this.isConstrained()) {
            return;
        }
        this.setFlag(FLAG_CONSTRAINED, constrained);
        this.repaint();
    }

    public boolean isStretched() {
        return this.getFlag(FLAG_STRETCHED);
    }

    public void setStretched(boolean stretched) {
        if (stretched == this.isStretched()) {
            return;
        }
        this.setFlag(FLAG_STRETCHED, stretched);
        this.repaint();
    }

    public SVGImageData getSVGData() {
        return this.svgData;
    }

    public int getAlpha() {
        return this.alpha;
    }

    public void setAlpha(int alpha) {
        if (this.alpha == alpha) {
            return;
        }
        this.alpha = alpha;
        this.repaint();
    }

    public Dimension getPreferredSize(int wHint, int hHint) {
        Dimension d;
        if (this.prefSize != null) {
            return this.prefSize;
        }
        if (this.getLayoutManager() != null && (d = this.getLayoutManager().getPreferredSize((IFigure)this, wHint, hHint)) != null) {
            return d;
        }
        if (this.svgData != null) {
            return this.svgData.getSize();
        }
        return new Dimension(0, 0);
    }

    protected void paintFigure(Graphics graphics) {
        super.paintFigure(graphics);
        SVGImageData svgData = this.getSVGData();
        if (svgData != null) {
            svgData.paintFigure(graphics, this.getClientArea(IMAGE_CLIENT_AREA), this.manager);
        }
    }

    public ResourceManager getManager() {
        return this.manager;
    }

    public void setManager(ResourceManager manager) {
        this.manager = manager;
    }
}

