/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.svgsupport;

import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.widgets.Display;
import org.w3c.dom.Element;
import org.xmind.gef.draw2d.geometry.PrecisionPoint;
import org.xmind.gef.draw2d.geometry.PrecisionRectangle;
import org.xmind.gef.draw2d.graphics.Path;
import org.xmind.ui.internal.svgsupport.SVGShape;

public final class SVGEllipseShape
extends SVGShape {
    private PrecisionPoint origin;
    private float height;
    private float width;

    SVGEllipseShape() {
    }

    public SVGEllipseShape(double x, double y, float height, float width) {
        this.origin = new PrecisionPoint(x, y);
        this.height = height;
        this.width = width;
    }

    @Override
    void parse(Element implemention, SVGShape parent) {
        super.parse(implemention, parent);
        this.parseEllipse(implemention, parent);
    }

    private void parseEllipse(Element implemention, SVGShape parent) {
        float cx = this.getFloatAttribute(implemention, "cx");
        float cy = this.getFloatAttribute(implemention, "cy");
        float rx = this.getFloatAttribute(implemention, "rx");
        float ry = this.getFloatAttribute(implemention, "ry");
        this.origin = new PrecisionPoint((double)(cx - ry), (double)(cy - ry));
        this.height = 2.0f * rx;
        this.width = 2.0f * ry;
        if (this.width == 0.0f) {
            this.width = this.height;
        }
    }

    @Override
    Path generatePath(Display device) {
        Path path = new Path((Device)device);
        path.addArc(new PrecisionRectangle(this.origin.x, this.origin.y, (double)this.width, (double)this.height), 0.0f, 360.0f);
        return path;
    }

    @Override
    PrecisionRectangle generateRectangle() {
        return new PrecisionRectangle(this.origin.x, this.origin.y, (double)this.width, (double)this.height);
    }

    @Override
    protected SVGShape clone() {
        SVGEllipseShape ellipse = new SVGEllipseShape();
        ellipse.origin = this.origin;
        ellipse.height = this.height;
        ellipse.width = this.width;
        ellipse.setInfo(this.getInfo().clone());
        return ellipse;
    }

    public boolean equals(Object obj) {
        SVGEllipseShape ellipse;
        if (this == obj) {
            return true;
        }
        return obj instanceof SVGEllipseShape && (ellipse = (SVGEllipseShape)obj).getInfo().equals(this.getInfo()) && this.origin.equals((Object)ellipse.origin) && this.width == ellipse.width && this.height == ellipse.height;
    }

    public int hashCode() {
        int result = 17;
        result = result * 31 + this.getInfo().hashCode();
        result = result * 31 + (int)Double.doubleToLongBits(this.origin.x);
        result = result * 31 + (int)Double.doubleToLongBits(this.origin.y);
        result = result * 31 + Float.floatToIntBits(this.width);
        result = result * 31 + Float.floatToIntBits(this.height);
        return result;
    }

    public String toString() {
        return "SVGEllipse( origin:" + this.origin.toString() + this.getInfo().toString() + " )";
    }
}

