/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.svgsupport;

import java.util.LinkedList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.xmind.ui.internal.svgsupport.PathElement;
import org.xmind.ui.internal.svgsupport.PathLocationInfo;

public class PathParser {
    public final Pattern pathPattern = Pattern.compile("([MmLlHhVvAaQqTtCcSsZz])|([-+]?((\\d*\\.\\d+)|(\\d+))([eE][-+]?\\d+)?)");
    private static PathParser instance = null;

    private PathParser() {
    }

    public List<PathElement> parseSVGPath(String pathDefinitionString) {
        Matcher matchPathCmd = this.pathPattern.matcher(pathDefinitionString);
        LinkedList<String> tokens = new LinkedList<String>();
        LinkedList<PathElement> elements = new LinkedList<PathElement>();
        PathLocationInfo info = new PathLocationInfo();
        int curCmd = 90;
        while (matchPathCmd.find()) {
            String detailElement = matchPathCmd.group();
            tokens.addLast(detailElement);
        }
        while (tokens.size() != 0) {
            String curToken = (String)tokens.removeFirst();
            char initChar = curToken.charAt(0);
            if (initChar >= 'A' && initChar <= 'Z' || initChar >= 'a' && initChar <= 'z') {
                curCmd = initChar;
            } else {
                tokens.addFirst(curToken);
            }
            switch (curCmd) {
                case 77: {
                    this.moveTo(elements, info, this.nextDouble(tokens), this.nextDouble(tokens), true);
                    break;
                }
                case 109: {
                    this.moveTo(elements, info, this.nextDouble(tokens), this.nextDouble(tokens), false);
                    break;
                }
                case 76: {
                    this.lineTo(elements, info, this.nextDouble(tokens), this.nextDouble(tokens), true);
                    break;
                }
                case 108: {
                    this.lineTo(elements, info, this.nextDouble(tokens), this.nextDouble(tokens), false);
                    break;
                }
                case 72: {
                    this.horizontalTo(elements, info, this.nextDouble(tokens), true);
                    break;
                }
                case 104: {
                    this.horizontalTo(elements, info, this.nextDouble(tokens), false);
                    break;
                }
                case 86: {
                    this.verticalTo(elements, info, this.nextDouble(tokens), true);
                    break;
                }
                case 118: {
                    this.verticalTo(elements, info, this.nextDouble(tokens), false);
                    break;
                }
                case 65: 
                case 97: {
                    break;
                }
                case 81: {
                    this.quadraticBelzierCurveTo(elements, info, this.nextDouble(tokens), this.nextDouble(tokens), this.nextDouble(tokens), this.nextDouble(tokens), true);
                    break;
                }
                case 113: {
                    this.quadraticBelzierCurveTo(elements, info, this.nextDouble(tokens), this.nextDouble(tokens), this.nextDouble(tokens), this.nextDouble(tokens), false);
                    break;
                }
                case 84: {
                    this.smoothQuadraticBelzierCurveTo(elements, info, this.nextDouble(tokens), this.nextDouble(tokens), true);
                    break;
                }
                case 116: {
                    this.smoothQuadraticBelzierCurveTo(elements, info, this.nextDouble(tokens), this.nextDouble(tokens), false);
                    break;
                }
                case 67: {
                    this.curveTo(elements, info, this.nextDouble(tokens), this.nextDouble(tokens), this.nextDouble(tokens), this.nextDouble(tokens), this.nextDouble(tokens), this.nextDouble(tokens), true);
                    break;
                }
                case 99: {
                    this.curveTo(elements, info, this.nextDouble(tokens), this.nextDouble(tokens), this.nextDouble(tokens), this.nextDouble(tokens), this.nextDouble(tokens), this.nextDouble(tokens), false);
                    break;
                }
                case 83: {
                    this.smoothCurveTo(elements, info, this.nextDouble(tokens), this.nextDouble(tokens), this.nextDouble(tokens), this.nextDouble(tokens), true);
                    break;
                }
                case 115: {
                    this.smoothCurveTo(elements, info, this.nextDouble(tokens), this.nextDouble(tokens), this.nextDouble(tokens), this.nextDouble(tokens), false);
                    break;
                }
                case 90: 
                case 122: {
                    this.closePath(elements, info);
                    break;
                }
                default: {
                    throw new RuntimeException("Invalid path element");
                }
            }
        }
        return elements;
    }

    private void closePath(List<PathElement> elements, PathLocationInfo info) {
        info.setLastPointX(0.0);
        info.setLastPointY(0.0);
        info.setLastKnotX(0.0);
        info.setLastKnotY(0.0);
        elements.add(PathElement.getClosePathElement());
    }

    private void smoothCurveTo(List<PathElement> elements, PathLocationInfo info, double x2, double y2, double x, double y, boolean isAbsolute) {
        if (!isAbsolute) {
            x2 += info.getLastPointX();
            y2 += info.getLastPointY();
            x += info.getLastPointX();
            y += info.getLastPointY();
        }
        this.curveTo(elements, info, info.getLastKnotX() * 2.0 - info.getLastPointX(), info.getLastKnotY() * 2.0 - info.getLastPointY(), x2, y2, x, y, true);
    }

    private void curveTo(List<PathElement> elements, PathLocationInfo info, double x1, double y1, double x2, double y2, double x, double y, boolean isAbsolute) {
        if (!isAbsolute) {
            x1 += info.getLastPointX();
            x2 += info.getLastPointX();
            x += info.getLastPointX();
            y1 += info.getLastPointY();
            y2 += info.getLastPointY();
            y += info.getLastPointY();
        }
        elements.add(PathElement.getCurveElement(x1, y1, x2, y2, x, y));
        info.setLastPointX(x);
        info.setLastPointY(y);
        info.setLastKnotX(x2);
        info.setLastKnotY(y2);
    }

    private void smoothQuadraticBelzierCurveTo(List<PathElement> elements, PathLocationInfo info, double x, double y, boolean isAbsolute) {
        if (!isAbsolute) {
            x += info.getLastPointX();
            y += info.getLastPointY();
        }
        this.quadraticBelzierCurveTo(elements, info, info.getLastKnotX(), info.getLastKnotY(), x, y, true);
    }

    private void quadraticBelzierCurveTo(List<PathElement> elements, PathLocationInfo info, double x1, double y1, double x, double y, boolean isAbsolute) {
        if (!isAbsolute) {
            x1 += info.getLastPointX();
            y1 += info.getLastPointY();
            x += info.getLastPointX();
            y += info.getLastPointY();
        }
        elements.add(PathElement.getQuadraticBelzierCurveElement(x1, y1, x, y));
        info.setLastPointX(x);
        info.setLastPointY(y);
        info.setLastKnotX(x1);
        info.setLastKnotY(y1);
    }

    private void verticalTo(List<PathElement> elements, PathLocationInfo info, double y, boolean isAbsolute) {
        if (!isAbsolute) {
            y += info.getLastPointY();
        }
        this.lineTo(elements, info, info.getLastPointX(), y, true);
    }

    private void horizontalTo(List<PathElement> elements, PathLocationInfo info, double x, boolean isAbsolute) {
        if (!isAbsolute) {
            x += info.getLastPointX();
        }
        this.lineTo(elements, info, x, info.getLastPointY(), true);
    }

    private void lineTo(List<PathElement> elements, PathLocationInfo info, double x, double y, boolean isAbsolute) {
        if (!isAbsolute) {
            x += info.getLastPointX();
            y += info.getLastPointY();
        }
        elements.add(PathElement.getLineElement(x, y));
        info.setLastPointX(x);
        info.setLastPointY(y);
        info.setLastKnotX(x);
        info.setLastKnotY(y);
    }

    private void moveTo(List<PathElement> elements, PathLocationInfo info, double x, double y, boolean isAbsolute) {
        elements.add(PathElement.getMoveElement(x, y));
        info.setLastPointX(x);
        info.setLastPointY(y);
    }

    private double nextDouble(LinkedList<String> tokens) {
        String token = tokens.removeFirst();
        return Double.valueOf(token);
    }

    public static PathParser getInstance() {
        if (instance == null) {
            instance = new PathParser();
        }
        return instance;
    }
}

