/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.properties;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.viewers.IOpenListener;
import org.eclipse.jface.viewers.OpenEvent;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.xmind.core.ISettingEntry;
import org.xmind.core.ISheet;
import org.xmind.core.event.ICoreEventRegister;
import org.xmind.gef.command.Command;
import org.xmind.gef.ui.editor.IGraphicalEditor;
import org.xmind.ui.color.ColorPicker;
import org.xmind.ui.color.IColorSelection;
import org.xmind.ui.color.PaletteContents;
import org.xmind.ui.commands.CommandMessages;
import org.xmind.ui.commands.ModifyInfoItemVisibilityCommand;
import org.xmind.ui.internal.InfoItemContributorManager;
import org.xmind.ui.internal.properties.PropertyMessages;
import org.xmind.ui.mindmap.IInfoItemContributor;
import org.xmind.ui.properties.StyledPropertySectionPart;

public class SheetInfoCardPropertySectionPart
extends StyledPropertySectionPart {
    private List<String> types;
    private Map<String, Button> checkMap;
    private Map<String, String> defaultModes;
    private Control bar;
    private ColorPicker bgColorPicker;

    @Override
    protected void createContent(Composite parent) {
        List<IInfoItemContributor> cs = InfoItemContributorManager.getInstance().getBothContributors();
        for (IInfoItemContributor c : cs) {
            Button check = this.createCheck(parent, c);
            if (this.types == null) {
                this.types = new ArrayList<String>();
            }
            this.types.add(c.getId());
            if (this.checkMap == null) {
                this.checkMap = new HashMap<String, Button>();
            }
            this.checkMap.put(c.getId(), check);
            if (this.defaultModes == null) {
                this.defaultModes = new HashMap<String, String>();
            }
            this.defaultModes.put(c.getId(), c.getDefaultMode());
        }
        this.createBackgroundPart(parent);
    }

    private Button createCheck(Composite parent, final IInfoItemContributor contributor) {
        String cardLabel = contributor.getCardLabel();
        final Button check = new Button(parent, 32);
        check.setText(cardLabel);
        check.setSelection("card".equals(contributor.getDefaultMode()));
        check.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SheetInfoCardPropertySectionPart.this.infoItemVisibility(contributor.getId(), check.getSelection());
            }
        });
        return check;
    }

    private void createBackgroundPart(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout(22, false);
        layout.horizontalSpacing = 7;
        composite.setLayout((Layout)layout);
        Label caption = new Label(composite, 0);
        caption.setText(PropertyMessages.BackgroundColor_label);
        caption.setLayoutData((Object)new GridData(4, 2, false, false));
        this.bgColorPicker = new ColorPicker(5, PaletteContents.getDefault());
        this.bgColorPicker.getAction().setToolTipText(PropertyMessages.InfoCardBackground_toolTip);
        this.bgColorPicker.addOpenListener((IOpenListener)new BackgroundColorOpenListener());
        ToolBarManager colorBar = new ToolBarManager(0x800000);
        colorBar.add((IContributionItem)this.bgColorPicker);
        this.bar = colorBar.createControl(composite);
        this.bar.setLayoutData((Object)new GridData(1, 2, false, false));
    }

    private void infoItemVisibility(String type, boolean visible) {
        IGraphicalEditor editor = this.getContributedEditor();
        if (editor == null) {
            return;
        }
        ISheet sheet = (ISheet)editor.getActivePageInstance().getAdapter(ISheet.class);
        ModifyInfoItemVisibilityCommand command = new ModifyInfoItemVisibilityCommand(sheet, visible, type);
        command.setLabel(CommandMessages.Command_ShowOrHideInfoItem);
        editor.getCommandStack().execute((Command)command);
    }

    private void changeBackgroundColor(IColorSelection selection) {
        this.changeColor(selection, "yellowBoxFillColor", CommandMessages.Command_ModifyYellowBoxBackgroundColor);
    }

    @Override
    protected void doRefresh() {
        for (String type : this.types) {
            this.checkMap.get(type).setSelection(this.isVisible(type));
        }
        this.updateColorPicker(this.bgColorPicker, "yellowBoxFillColor", null);
    }

    private boolean isVisible(String type) {
        Object[] objectArray = this.getSelectedElements();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object o = objectArray[n2];
            if (o instanceof ISheet) {
                ISettingEntry entry = this.findEntry((ISheet)o, type);
                if (entry == null) break;
                return "card".equals(entry.getAttribute("mode"));
            }
            ++n2;
        }
        return "card".equals(this.defaultModes.get(type));
    }

    private ISettingEntry findEntry(ISheet sheet, String type) {
        List entries = sheet.getSettings().getEntries("info-items/info-item");
        for (ISettingEntry entry : entries) {
            String t = entry.getAttribute("type");
            if (!type.equals(t)) continue;
            return entry;
        }
        return null;
    }

    @Override
    protected void registerEventListener(Object source, ICoreEventRegister register) {
        super.registerEventListener(source, register);
        if (source instanceof ISheet) {
            register.register("sheetSettings");
        }
    }

    public void dispose() {
        super.dispose();
        this.types = null;
        this.checkMap = null;
        this.defaultModes = null;
        this.bar = null;
    }

    public void setFocus() {
        if (this.types != null && !this.types.isEmpty() && this.checkMap != null && !this.checkMap.isEmpty()) {
            this.checkMap.get(this.types.get(0));
        }
    }

    private class BackgroundColorOpenListener
    implements IOpenListener {
        private BackgroundColorOpenListener() {
        }

        public void open(OpenEvent event) {
            SheetInfoCardPropertySectionPart.this.changeBackgroundColor((IColorSelection)event.getSelection());
        }
    }
}

