/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.properties;

import java.util.List;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.xmind.gef.Request;
import org.xmind.ui.commands.CommandMessages;
import org.xmind.ui.decorations.IDecorationDescriptor;
import org.xmind.ui.internal.properties.PropertyMessages;
import org.xmind.ui.mindmap.MindMapUI;
import org.xmind.ui.properties.DecorationLabelProvider;
import org.xmind.ui.properties.StyledPropertySectionPart;
import org.xmind.ui.viewers.MComboViewer;

public class RelationshipShapePropertySectionPart
extends StyledPropertySectionPart
implements ISelectionChangedListener {
    private static List<IDecorationDescriptor> RelationshipShapes;
    private static List<IDecorationDescriptor> ArrowShapes;
    private MComboViewer shapeViewer;
    private MComboViewer beginArrowShapeViewer;
    private MComboViewer endArrowShapeViewer;

    @Override
    protected void createContent(Composite parent) {
        Composite line1 = new Composite(parent, 0);
        line1.setLayoutData((Object)new GridData(4, 4, true, false));
        GridLayout layout = new GridLayout(2, false);
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        layout.horizontalSpacing = 3;
        layout.verticalSpacing = 3;
        line1.setLayout((Layout)layout);
        this.createLine1Content(line1);
        Composite line2 = new Composite(parent, 0);
        line2.setLayoutData((Object)new GridData(4, 4, true, false));
        GridLayout layout2 = new GridLayout(2, true);
        layout2.marginWidth = 0;
        layout2.marginHeight = 0;
        layout2.horizontalSpacing = 3;
        layout2.verticalSpacing = 3;
        line2.setLayout((Layout)layout2);
        this.createLine2Content(line2);
    }

    private void createLine1Content(Composite parent) {
        this.shapeViewer = new MComboViewer(parent, 0);
        this.shapeViewer.getControl().setLayoutData((Object)new GridData(4, 4, true, false));
        this.shapeViewer.getControl().setToolTipText(PropertyMessages.RelationshipShape_toolTip);
        this.shapeViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.shapeViewer.setLabelProvider((IBaseLabelProvider)new DecorationLabelProvider());
        this.shapeViewer.setInput(RelationshipShapePropertySectionPart.getRelationshipShapes());
        this.shapeViewer.addSelectionChangedListener((ISelectionChangedListener)this);
    }

    private void createLine2Content(Composite parent) {
        this.beginArrowShapeViewer = new MComboViewer(parent, 0);
        this.beginArrowShapeViewer.getControl().setLayoutData((Object)new GridData(4, 4, true, false));
        this.beginArrowShapeViewer.getControl().setToolTipText(PropertyMessages.BeginArrowShape_toolTip);
        this.beginArrowShapeViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.beginArrowShapeViewer.setLabelProvider((IBaseLabelProvider)new DecorationLabelProvider());
        this.beginArrowShapeViewer.setInput(RelationshipShapePropertySectionPart.getArrowShapes());
        this.beginArrowShapeViewer.addSelectionChangedListener((ISelectionChangedListener)this);
        this.endArrowShapeViewer = new MComboViewer(parent, 0);
        this.endArrowShapeViewer.getControl().setLayoutData((Object)new GridData(4, 4, true, false));
        this.endArrowShapeViewer.getControl().setToolTipText(PropertyMessages.EndArrowShape_toolTip);
        this.endArrowShapeViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.endArrowShapeViewer.setLabelProvider((IBaseLabelProvider)new DecorationLabelProvider());
        this.endArrowShapeViewer.setInput(RelationshipShapePropertySectionPart.getArrowShapes());
        this.endArrowShapeViewer.addSelectionChangedListener((ISelectionChangedListener)this);
    }

    public void setFocus() {
        if (this.shapeViewer != null && !this.shapeViewer.getControl().isDisposed()) {
            this.shapeViewer.getControl().setFocus();
        }
    }

    public void dispose() {
        super.dispose();
        this.shapeViewer = null;
        this.beginArrowShapeViewer = null;
        this.endArrowShapeViewer = null;
    }

    @Override
    protected void doRefresh() {
        IDecorationDescriptor element;
        String shapeId;
        if (this.shapeViewer != null && !this.shapeViewer.getControl().isDisposed()) {
            shapeId = this.getStyleValue("shape-class", null);
            element = this.getSelectableDescriptor(shapeId, RelationshipShapePropertySectionPart.getRelationshipShapes());
            if (element == null) {
                this.shapeViewer.setSelection((ISelection)StructuredSelection.EMPTY);
            } else {
                this.shapeViewer.setSelection((ISelection)new StructuredSelection((Object)element));
            }
        }
        if (this.beginArrowShapeViewer != null && !this.beginArrowShapeViewer.getControl().isDisposed()) {
            shapeId = this.getStyleValue("arrow-begin-class", null);
            element = this.getSelectableDescriptor(shapeId, RelationshipShapePropertySectionPart.getArrowShapes());
            if (element == null) {
                this.beginArrowShapeViewer.setSelection((ISelection)StructuredSelection.EMPTY);
            } else {
                this.beginArrowShapeViewer.setSelection((ISelection)new StructuredSelection((Object)element));
            }
        }
        if (this.endArrowShapeViewer != null && !this.endArrowShapeViewer.getControl().isDisposed()) {
            shapeId = this.getStyleValue("arrow-end-class", null);
            element = this.getSelectableDescriptor(shapeId, RelationshipShapePropertySectionPart.getArrowShapes());
            if (element == null) {
                this.endArrowShapeViewer.setSelection((ISelection)StructuredSelection.EMPTY);
            } else {
                this.endArrowShapeViewer.setSelection((ISelection)new StructuredSelection((Object)element));
            }
        }
    }

    private IDecorationDescriptor getSelectableDescriptor(String shapeId, List<IDecorationDescriptor> descriptors) {
        if (shapeId == null) {
            return null;
        }
        IDecorationDescriptor descriptor = MindMapUI.getDecorationManager().getDecorationDescriptor(shapeId);
        if (!descriptors.contains(descriptor)) {
            return null;
        }
        return descriptor;
    }

    public void selectionChanged(SelectionChangedEvent event) {
        if (this.isRefreshing()) {
            return;
        }
        Object o = ((IStructuredSelection)event.getSelection()).getFirstElement();
        if (o instanceof IDecorationDescriptor) {
            String decorationId = ((IDecorationDescriptor)o).getId();
            ISelectionProvider provider = event.getSelectionProvider();
            if (provider == this.shapeViewer) {
                this.changeRelationshipShape(decorationId);
            } else if (provider == this.beginArrowShapeViewer) {
                this.changeBeginArrowShape(decorationId);
            } else if (provider == this.endArrowShapeViewer) {
                this.changeEndArrowShape(decorationId);
            }
        }
    }

    private void changeRelationshipShape(String newShape) {
        Request request = this.createStyleRequest(CommandMessages.Command_ModifyRelationshipShape);
        this.addStyle(request, "shape-class", newShape);
        this.sendRequest(request);
    }

    private void changeBeginArrowShape(String newShape) {
        Request request = this.createStyleRequest(CommandMessages.Command_ModifyBeginArrowShape);
        this.addStyle(request, "arrow-begin-class", newShape);
        this.sendRequest(request);
    }

    private void changeEndArrowShape(String newShape) {
        Request request = this.createStyleRequest(CommandMessages.Command_ModifyEndArrowShape);
        this.addStyle(request, "arrow-end-class", newShape);
        this.sendRequest(request);
    }

    private static List<IDecorationDescriptor> getRelationshipShapes() {
        if (RelationshipShapes == null) {
            RelationshipShapes = MindMapUI.getDecorationManager().getDescriptors("org.xmind.ui.relationshipDecorations");
        }
        return RelationshipShapes;
    }

    private static List<IDecorationDescriptor> getArrowShapes() {
        if (ArrowShapes == null) {
            ArrowShapes = MindMapUI.getDecorationManager().getDescriptors("org.xmind.ui.arrowDecorations");
        }
        return ArrowShapes;
    }
}

