/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.outline;

import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.swt.custom.TreeEditor;
import org.eclipse.swt.dnd.DragSource;
import org.eclipse.swt.dnd.DragSourceEvent;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.xmind.core.IWorkbook;
import org.xmind.gef.EditDomain;
import org.xmind.gef.IViewer;
import org.xmind.gef.Request;
import org.xmind.gef.dnd.IDndClient;
import org.xmind.gef.part.IPart;
import org.xmind.gef.part.IRootPart;
import org.xmind.gef.policy.IEditPolicy;
import org.xmind.gef.tool.ITool;
import org.xmind.gef.tree.ITreeViewer;
import org.xmind.gef.tree.TreeRootPart;
import org.xmind.gef.tree.TreeSelectTool;
import org.xmind.gef.tree.TreeViewer;
import org.xmind.gef.ui.editor.IGraphicalEditor;
import org.xmind.gef.ui.outline.GraphicalOutlinePage;
import org.xmind.ui.internal.MindMapMessages;
import org.xmind.ui.internal.dnd.MindMapElementTransfer;
import org.xmind.ui.internal.editpolicies.ModifiablePolicy;
import org.xmind.ui.internal.outline.MindMapTreeViewer;
import org.xmind.ui.internal.outline.TopicTreePart;
import org.xmind.ui.mindmap.MindMapUI;

public class MindMapOutlinePage
extends GraphicalOutlinePage {
    private int controlStyle;
    private EditDomain domain;
    IAction showWorkbookAction;
    IAction showCurrentSheetAction;

    public MindMapOutlinePage(IGraphicalEditor parentEditor, int controlStyle) {
        super(parentEditor);
        this.controlStyle = controlStyle;
        this.domain = new EditDomain();
        this.domain.installTool("select tool", (ITool)new TreeSelectTool());
        this.domain.setCommandStack(parentEditor.getCommandStack());
        this.domain.installEditPolicy("org.xmind.ui.editPolicy.modifiable", (IEditPolicy)new ModifiablePolicy());
    }

    public void createControl(Composite parent) {
        this.showWorkbookAction = new ShowWorkbookAction();
        this.showCurrentSheetAction = new ShowCurrentSheetAction();
        IMenuManager menu = this.getSite().getActionBars().getMenuManager();
        menu.add(this.showWorkbookAction);
        menu.add(this.showCurrentSheetAction);
        menu.add((IContributionItem)new Separator());
        menu.add((IContributionItem)new Separator("additions"));
        this.showWorkbookAction.setChecked(!this.isShowCurrentPageViewer());
        this.showCurrentSheetAction.setChecked(this.isShowCurrentPageViewer());
        super.createControl(parent);
    }

    protected TreeViewer createEditorTreeViewer() {
        MindMapTreeViewer viewer = new MindMapTreeViewer();
        viewer.getProperties().set("PROP_HEADER_VISIBLE", false);
        return viewer;
    }

    protected Control createEditorTreeViewerControl(ITreeViewer viewer, Composite parent) {
        Control control = ((TreeViewer)viewer).createControl(parent, this.controlStyle);
        this.hookViewerControl((IViewer)viewer, control);
        return control;
    }

    protected Object createEditorTreeViewerInput(IGraphicalEditor parentEditor) {
        return parentEditor.getAdapter(IWorkbook.class);
    }

    protected ITreeViewer createPageTreeViewer() {
        MindMapTreeViewer viewer = new MindMapTreeViewer();
        viewer.getProperties().set("PROP_HEADER_VISIBLE", false);
        return viewer;
    }

    protected Control createPageTreeViewerControl(ITreeViewer viewer, Composite parent) {
        Control control = ((TreeViewer)viewer).createControl(parent, this.controlStyle);
        this.hookViewerControl((IViewer)viewer, control);
        return control;
    }

    protected Object createPageTreeViewerInput(Object pageInput) {
        return pageInput;
    }

    protected void configureTreeViewer(ITreeViewer viewer) {
        super.configureTreeViewer(viewer);
        viewer.setEditDomain(this.domain);
        viewer.setPartFactory(MindMapUI.getMindMapTreePartFactory());
        viewer.setRootPart((IRootPart)new TreeRootPart());
    }

    protected void hookViewerControl(final IViewer viewer, final Control control) {
        final DragSource dragSource = new DragSource(control, 3);
        dragSource.setTransfer(new Transfer[]{MindMapElementTransfer.getInstance(), TextTransfer.getInstance()});
        dragSource.addDragListener(new DragSourceListener(){
            Object[] elements;
            String text;

            public void dragStart(DragSourceEvent event) {
                this.elements = this.getElements();
                if (this.elements == null || this.elements.length == 0) {
                    event.doit = false;
                } else {
                    this.text = this.createText(this.elements);
                }
            }

            private Object[] getElements() {
                TreeItem[] selection;
                if (control instanceof Tree && (selection = ((Tree)control).getSelection()).length > 0) {
                    Object[] elements = new Object[selection.length];
                    int i = 0;
                    while (i < selection.length) {
                        TreeItem item = selection[i];
                        Object data = item.getData();
                        if (data instanceof IPart) {
                            data = ((IPart)data).getModel();
                        }
                        elements[i] = data;
                        ++i;
                    }
                    return elements;
                }
                return null;
            }

            public void dragSetData(DragSourceEvent event) {
                if (MindMapElementTransfer.getInstance().isSupportedType(event.dataType)) {
                    event.data = this.elements;
                } else if (TextTransfer.getInstance().isSupportedType(event.dataType)) {
                    event.data = this.text;
                }
            }

            private String createText(Object[] elements) {
                IDndClient textClient = MindMapUI.getMindMapDndSupport().getDndClient("org.xmind.ui.dnd.text");
                if (textClient == null) {
                    return null;
                }
                Object data = textClient.toTransferData(elements, viewer);
                return data instanceof String ? (String)data : null;
            }

            public void dragFinished(DragSourceEvent event) {
            }
        });
        control.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                dragSource.dispose();
            }
        });
        control.addListener(8, new Listener(){

            public void handleEvent(Event event) {
                MindMapOutlinePage.this.handleDoubleClick(event, viewer, control);
                event.doit = false;
            }
        });
    }

    protected void handleDoubleClick(Event event, IViewer viewer, Control control) {
        this.startEditing(viewer, control);
    }

    private void startEditing(IViewer viewer, Control control) {
        Tree tree = (Tree)control;
        TreeItem[] selection = tree.getSelection();
        if (selection.length == 0) {
            return;
        }
        final TreeItem item = selection[0];
        if (!(item.getData() instanceof TopicTreePart)) {
            return;
        }
        TreeEditor editor = new TreeEditor(tree){

            public void layout() {
                super.layout();
                Control editor = this.getEditor();
                if (editor == null || editor.isDisposed()) {
                    return;
                }
                Rectangle bounds = editor.getBounds();
                Point prefSize = editor.computeSize(-1, -1);
                if (prefSize.y > bounds.height) {
                    bounds.y += (bounds.height - prefSize.y - 1) / 2;
                    bounds.height = prefSize.y;
                }
                editor.setBounds(bounds);
            }
        };
        editor.horizontalAlignment = 16384;
        editor.grabHorizontal = true;
        editor.minimumWidth = 50;
        final Text text = new Text((Composite)tree, 2052);
        text.setCursor(Display.getCurrent().getSystemCursor(19));
        editor.setEditor((Control)text, item);
        final String oldValue = item.getText();
        text.setText(oldValue);
        text.setFocus();
        text.selectAll();
        text.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusLost(FocusEvent e) {
                item.setText(text.getText());
                MindMapOutlinePage.this.modifyTreeItem(item);
                e.display.asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        text.dispose();
                    }
                });
            }
        });
        text.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                switch (e.character) {
                    case '\u001b': {
                        item.setText(oldValue);
                        e.display.asyncExec(new Runnable(){

                            @Override
                            public void run() {
                                text.dispose();
                            }
                        });
                        break;
                    }
                    case '\r': {
                        item.setText(text.getText());
                        MindMapOutlinePage.this.modifyTreeItem(item);
                        e.display.asyncExec(new Runnable(){

                            @Override
                            public void run() {
                                text.dispose();
                            }
                        });
                    }
                }
            }
        });
    }

    protected void modifyTreeItem(TreeItem item) {
        Object o = item.getData();
        if (o instanceof IPart) {
            IPart part = (IPart)o;
            part.handleRequest(new Request("modify").setViewer(part.getSite().getViewer()).setParameter("text", (Object)item.getText()).setPrimaryTarget(part), "modifiable role");
        }
    }

    private class ShowCurrentSheetAction
    extends Action {
        public ShowCurrentSheetAction() {
            super(MindMapMessages.ShowSheet_text, 8);
            this.setId("org.xmind.ui.showCurrentSheet");
            this.setToolTipText(MindMapMessages.ShowSheet_toolTip);
            this.setImageDescriptor(MindMapUI.getImages().get("sheet.png", true));
            this.setDisabledImageDescriptor(MindMapUI.getImages().get("sheet.png", false));
        }

        public void run() {
            MindMapOutlinePage.this.setShowCurrentPageViewer(true);
        }
    }

    private class ShowWorkbookAction
    extends Action {
        public ShowWorkbookAction() {
            super(MindMapMessages.ShowWorkbook_text, 8);
            this.setId("org.xmind.ui.showWorkbook");
            this.setToolTipText(MindMapMessages.ShowWorkbook_toolTip);
            this.setImageDescriptor(MindMapUI.getImages().get("workbook.png", true));
            this.setDisabledImageDescriptor(MindMapUI.getImages().get("workbook.png", false));
        }

        public void run() {
            MindMapOutlinePage.this.setShowCurrentPageViewer(false);
        }
    }
}

