/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.mindmap;

import org.eclipse.draw2d.IFigure;
import org.xmind.core.IControlPoint;
import org.xmind.core.IRelationship;
import org.xmind.gef.draw2d.decoration.IDecoration;
import org.xmind.gef.graphicalpolicy.IStyleSelector;
import org.xmind.gef.part.IGraphicalPart;
import org.xmind.ui.decorations.IRelationshipDecoration;
import org.xmind.ui.internal.mindmap.DecoratedLineFeedback;
import org.xmind.ui.mindmap.IRelationshipPart;
import org.xmind.ui.resources.ColorUtils;
import org.xmind.ui.style.StyleUtils;
import org.xmind.ui.util.MindMapUtils;

public class DecoratedRelFeedback
extends DecoratedLineFeedback {
    public DecoratedRelFeedback(IGraphicalPart part) {
        super(part);
        this.setLineColor(ColorUtils.getColor((String)"#1040a8"));
        this.setLineStyle(1);
        this.setLineWidthExpansion(2);
    }

    @Override
    protected IDecoration createNewDecoration(IFigure figure, String decorationId) {
        return StyleUtils.createRelationshipDecoration(this.getHost(), decorationId);
    }

    @Override
    protected String getNewDecorationId() {
        return StyleUtils.getString(this.getHost(), StyleUtils.getStyleSelector(this.getHost()), "shape-class", "org.xmind.relationshipShape.straight");
    }

    @Override
    protected void updateDecoration(IFigure figure, IDecoration decoration, String decorationId, IStyleSelector ss) {
        super.updateDecoration(figure, decoration, decorationId, ss);
        if (decoration instanceof IRelationshipDecoration && this.getHost() instanceof IRelationshipPart) {
            IRelationship r = ((IRelationshipPart)this.getHost()).getRelationship();
            this.decorateControlPoints(r, figure, (IRelationshipDecoration)decoration);
        }
    }

    private void decorateControlPoints(IRelationship r, IFigure figure, IRelationshipDecoration decoration) {
        if (r != null) {
            IControlPoint cp0 = r.getControlPoint(0);
            decoration.setRelativeSourceControlPoint(figure, MindMapUtils.toGraphicalPosition(cp0.getPosition()));
            Double angle = cp0 == null ? null : Double.valueOf(cp0.getPolarAngle());
            Double amount = cp0 == null ? null : Double.valueOf(cp0.getPolarAmount());
            decoration.setSourceControlPointHint(figure, angle, amount);
            IControlPoint cp1 = r.getControlPoint(1);
            decoration.setRelativeTargetControlPoint(figure, MindMapUtils.toGraphicalPosition(cp1.getPosition()));
            angle = cp1 == null ? null : Double.valueOf(cp1.getPolarAngle());
            amount = cp1 == null ? null : Double.valueOf(cp1.getPolarAmount());
            decoration.setTargetControlPointHint(figure, angle, amount);
        }
    }
}

