/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.handlers;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.handlers.HandlerUtil;
import org.eclipse.ui.internal.E4PartWrapper;
import org.eclipse.ui.part.IContributedContentsView;
import org.xmind.core.style.IStyle;
import org.xmind.core.style.IStyleSheet;
import org.xmind.ui.internal.MindMapUIPlugin;
import org.xmind.ui.mindmap.IResourceManager;
import org.xmind.ui.mindmap.MindMapUI;

public class MindMapHandlerUtil {
    public static final int MATCH_ALL = 0;
    public static final int MATCH_READ_ONLY = 1;
    public static final int MATCH_MODIFIABLE = 2;

    private MindMapHandlerUtil() {
        throw new AssertionError();
    }

    public static final IEditorPart getActivePartAsEditor(ExecutionEvent event) {
        IWorkbenchPart part = HandlerUtil.getActivePart((ExecutionEvent)event);
        return part instanceof IEditorPart ? (IEditorPart)part : null;
    }

    public static final IEditorPart findContributingEditor(ExecutionEvent event) {
        IWorkbenchPart contributingPart;
        IEditorPart p;
        IWorkbenchPart part = HandlerUtil.getActivePart((ExecutionEvent)event);
        if (part == null) {
            return null;
        }
        if (part instanceof IEditorPart) {
            return (IEditorPart)part;
        }
        if (part instanceof E4PartWrapper && (p = HandlerUtil.getActiveEditor((ExecutionEvent)event)) instanceof IEditorPart) {
            return p;
        }
        IContributedContentsView contributedView = MindMapUIPlugin.getAdapter(part, IContributedContentsView.class);
        if (contributedView != null && (contributingPart = contributedView.getContributingPart()) instanceof IEditorPart) {
            return (IEditorPart)contributingPart;
        }
        return null;
    }

    public static final IStyle findStyle(ExecutionEvent event) {
        return MindMapHandlerUtil.findStyle(event, 0);
    }

    public static final IStyle findStyle(ExecutionEvent event, int match) {
        String uri = event.getParameter("org.xmind.ui.resource.uri");
        if (uri != null) {
            String[] uris = uri.split("\\s+|,");
            int i = 0;
            while (i < uris.length) {
                Object resource = MindMapUI.getResourceManager().findResource(uris[i]);
                if (resource != null && resource instanceof IStyle && MindMapHandlerUtil.matchStyle((IStyle)resource, match)) {
                    return (IStyle)resource;
                }
                ++i;
            }
            return null;
        }
        ISelection selection = HandlerUtil.getCurrentSelection((ExecutionEvent)event);
        if (selection == null || selection.isEmpty() || !(selection instanceof IStructuredSelection)) {
            return null;
        }
        for (Object element : ((IStructuredSelection)selection).toList()) {
            if (!(element instanceof IStyle) || !MindMapHandlerUtil.matchStyle((IStyle)element, match)) continue;
            return (IStyle)element;
        }
        return null;
    }

    public static final List<IStyle> findStyles(ExecutionEvent event) {
        return MindMapHandlerUtil.findStyles(event, 0);
    }

    public static final List<IStyle> findStyles(ExecutionEvent event, int match) {
        ArrayList<IStyle> styles;
        block4: {
            block3: {
                styles = new ArrayList<IStyle>();
                String uri = event.getParameter("org.xmind.ui.resource.uri");
                if (uri == null) break block3;
                String[] uris = uri.split("\\s+|,");
                int i = 0;
                while (i < uris.length) {
                    Object resource = MindMapUI.getResourceManager().findResource(uris[i]);
                    if (resource != null && resource instanceof IStyle && MindMapHandlerUtil.matchStyle((IStyle)resource, match)) {
                        styles.add((IStyle)resource);
                    }
                    ++i;
                }
                break block4;
            }
            ISelection selection = HandlerUtil.getCurrentSelection((ExecutionEvent)event);
            if (selection == null || selection.isEmpty() || !(selection instanceof IStructuredSelection)) break block4;
            for (Object element : ((IStructuredSelection)selection).toList()) {
                if (!(element instanceof IStyle) || !MindMapHandlerUtil.matchStyle((IStyle)element, match)) continue;
                styles.add((IStyle)element);
            }
        }
        return styles;
    }

    private static final boolean matchStyle(IStyle style, int match) {
        if (match == 0) {
            return true;
        }
        IStyleSheet parentSheet = style.getOwnedStyleSheet();
        IResourceManager rm = MindMapUI.getResourceManager();
        if ((match & 1) != 0 && (parentSheet == rm.getDefaultStyleSheet() || parentSheet == rm.getSystemStyleSheet() || parentSheet == rm.getSystemThemeSheet())) {
            return true;
        }
        return (match & 2) != 0 && (parentSheet == rm.getUserStyleSheet() || parentSheet == rm.getUserThemeSheet());
    }
}

