/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.editpolicies;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.eclipse.draw2d.geometry.Point;
import org.xmind.core.ILabeled;
import org.xmind.core.IPositioned;
import org.xmind.core.ITitled;
import org.xmind.core.ITopic;
import org.xmind.gef.IViewer;
import org.xmind.gef.Request;
import org.xmind.gef.command.Command;
import org.xmind.gef.command.ICommandStack;
import org.xmind.ui.commands.CommandBuilder;
import org.xmind.ui.commands.CommandMessages;
import org.xmind.ui.commands.ModifyFoldedCommand;
import org.xmind.ui.commands.ModifyLabelCommand;
import org.xmind.ui.commands.ModifyPositionCommand;
import org.xmind.ui.commands.ModifyTitleTextCommand;
import org.xmind.ui.commands.ModifyTopicStructureCommand;
import org.xmind.ui.commands.ModifyTopicTitleWidthCommand;
import org.xmind.ui.util.MindMapUtils;

public class PropertyCommandBuilder
extends CommandBuilder {
    private static final List<Object> EMPTY_SOURCES = Collections.emptyList();
    private Request request;
    private List<Object> sources = null;

    public PropertyCommandBuilder(Request request) {
        this(request.getTargetViewer(), request.getTargetCommandStack(), request);
    }

    public PropertyCommandBuilder(IViewer viewer, CommandBuilder delegate, Request request) {
        super(viewer, delegate);
        this.request = request;
    }

    public PropertyCommandBuilder(IViewer viewer, ICommandStack commandStack, Request request) {
        super(viewer, commandStack);
        this.request = request;
    }

    public Request getRequest() {
        return this.request;
    }

    public void addSourcesFromRequest(boolean collectable) {
        this.addSources(MindMapUtils.getRealModels(this.request.getTargets()).toArray(), collectable);
    }

    public void addSources(Object[] sources, boolean collectable) {
        Object[] objectArray = sources;
        int n = sources.length;
        int n2 = 0;
        while (n2 < n) {
            Object source = objectArray[n2];
            this.addSource(source, collectable);
            ++n2;
        }
    }

    public void addSource(Object source, boolean collectable) {
        boolean commandAdded = false;
        for (Map.Entry param : this.request.getParameters().entrySet()) {
            String paramName = (String)param.getKey();
            if (!paramName.startsWith("property.")) continue;
            String propName = paramName.substring("property.".length());
            commandAdded |= this.addPropertyCommand(source, propName, param.getValue(), collectable);
        }
        if (commandAdded) {
            this.addSource(source);
        }
    }

    private void addSource(Object source) {
        if (this.sources == null) {
            this.sources = new ArrayList<Object>();
        }
        this.sources.add(source);
    }

    public boolean isSourceAdded(Object source) {
        return this.sources != null && this.sources.contains(source);
    }

    public List<Object> getAddedSources() {
        return this.sources == null ? EMPTY_SOURCES : this.sources;
    }

    private boolean addPropertyCommand(Object source, String propName, Object value, boolean sourceCollectable) {
        if (propName == null || "".equals(propName)) {
            return false;
        }
        if ("titleText".equals(propName)) {
            return this.modifyTitle(source, value, sourceCollectable);
        }
        if ("topicFolded".equals(propName)) {
            return this.modifyTopicFolded(source, value, sourceCollectable);
        }
        if ("labels".equals(propName)) {
            return this.modifyTopicLabels(source, value, sourceCollectable);
        }
        if ("titleWidth".equals(propName)) {
            return this.modifyTitleWidth(source, value, sourceCollectable);
        }
        if ("position".equals(propName)) {
            return this.modifyPosition(source, value, sourceCollectable);
        }
        if ("structureClass".equals(propName)) {
            return this.modifyStructure(source, value, sourceCollectable);
        }
        return false;
    }

    private boolean modifyStructure(Object source, Object value, boolean sourceCollectable) {
        if (source instanceof ITopic && (value == null || value instanceof String)) {
            String structureClass = (String)value;
            this.add((Command)new ModifyTopicStructureCommand((ITopic)source, structureClass), sourceCollectable);
            return true;
        }
        return false;
    }

    private boolean modifyPosition(Object source, Object value, boolean sourceCollectable) {
        if (source instanceof IPositioned && (value == null || value instanceof Point)) {
            Point p = (Point)value;
            this.add((Command)new ModifyPositionCommand((IPositioned)source, MindMapUtils.toModelPosition(p)), sourceCollectable);
            return true;
        }
        return false;
    }

    private boolean modifyTitleWidth(Object source, Object value, boolean sourceCollectable) {
        if (source instanceof ITopic && (value == null || value instanceof Integer)) {
            int width = value == null ? -1 : (Integer)value;
            ModifyTopicTitleWidthCommand command = new ModifyTopicTitleWidthCommand((ITopic)source, width);
            command.setLabel(CommandMessages.Command_ModifyWidth);
            this.add((Command)command, sourceCollectable);
            return true;
        }
        return false;
    }

    private boolean modifyTopicLabels(Object source, Object value, boolean sourceCollectable) {
        if (source instanceof ITopic && (value == null || value instanceof String || value instanceof String[] || value instanceof Collection)) {
            ArrayList<String> labels = new ArrayList<String>();
            if (value != null) {
                if (value instanceof String) {
                    labels.addAll(MindMapUtils.getLabels((String)value));
                } else if (value instanceof String[]) {
                    labels.addAll(Arrays.asList((String[])value));
                } else if (value instanceof Collection) {
                    for (Object o : (Collection)value) {
                        if (!(o instanceof String)) continue;
                        labels.add((String)o);
                    }
                }
            }
            this.add((Command)new ModifyLabelCommand((ILabeled)((ITopic)source), labels), sourceCollectable);
            return true;
        }
        return false;
    }

    private boolean modifyTopicFolded(Object source, Object value, boolean sourceCollectable) {
        if (source instanceof ITopic && value instanceof Boolean) {
            boolean newFolded = (Boolean)value;
            this.add((Command)new ModifyFoldedCommand((ITopic)source, newFolded), sourceCollectable);
            return true;
        }
        return false;
    }

    private boolean modifyTitle(Object source, Object value, boolean sourceCollectable) {
        if (source instanceof ITitled && (value == null || value instanceof String)) {
            this.add((Command)new ModifyTitleTextCommand((ITitled)source, (String)value), sourceCollectable);
            return true;
        }
        return false;
    }
}

