/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.editor;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.text.TextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.widgets.Display;
import org.xmind.core.ITitled;
import org.xmind.gef.EditDomain;
import org.xmind.gef.IGraphicalViewer;
import org.xmind.gef.IViewer;
import org.xmind.gef.Request;
import org.xmind.gef.part.IPart;
import org.xmind.gef.tool.AbstractTool;
import org.xmind.gef.tool.ITool;
import org.xmind.gef.ui.editor.IGraphicalEditor;
import org.xmind.gef.ui.editor.IGraphicalEditorPage;
import org.xmind.ui.internal.findreplace.AbstractFindReplaceOperationProvider;
import org.xmind.ui.internal.tools.LabelEditTool;
import org.xmind.ui.mindmap.IBoundaryPart;
import org.xmind.ui.mindmap.IBranchPart;
import org.xmind.ui.mindmap.ILabelPart;
import org.xmind.ui.mindmap.IRelationshipPart;
import org.xmind.ui.mindmap.ISheetPart;
import org.xmind.ui.mindmap.ITopicPart;
import org.xmind.ui.texteditor.FloatingTextEditTool;
import org.xmind.ui.texteditor.FloatingTextEditor;
import org.xmind.ui.tools.TitleEditTool;
import org.xmind.ui.util.MindMapUtils;

public class MindMapFindReplaceOperationProvider
extends AbstractFindReplaceOperationProvider {
    private static final int PROP_TITLE = 1;
    private static final int PROP_LABEL = 2;
    private IGraphicalEditor editor;
    private SearchResult result = null;

    @Override
    public String getContextName() {
        String pageTitle;
        String title = this.editor.getTitle();
        IGraphicalEditorPage page = this.editor.getActivePageInstance();
        String string = pageTitle = page == null ? null : page.getPageTitle();
        if (pageTitle == null || "".equals(pageTitle)) {
            return title;
        }
        return NLS.bind((String)"{0} - {1}", (Object)title, (Object)pageTitle);
    }

    @Override
    public String getContextName(int maxWidth, Font font) {
        String pageTitle;
        String title = this.editor.getTitle();
        IGraphicalEditorPage page = this.editor.getActivePageInstance();
        String string = pageTitle = page == null ? null : page.getPageTitle();
        if (pageTitle == null || "".equals(pageTitle)) {
            return MindMapFindReplaceOperationProvider.constrainText(title, maxWidth, font);
        }
        String name = NLS.bind((String)"{0} - {1}", (Object)title, (Object)pageTitle);
        if (MindMapFindReplaceOperationProvider.computeTextWidth(name, font) > maxWidth) {
            int halfMaxWidth = (maxWidth - MindMapFindReplaceOperationProvider.computeTextWidth(" - ", font)) / 2 - 1;
            int w1 = MindMapFindReplaceOperationProvider.computeTextWidth(title, font);
            int w2 = MindMapFindReplaceOperationProvider.computeTextWidth(pageTitle, font);
            if (w1 > halfMaxWidth) {
                title = MindMapFindReplaceOperationProvider.constrainText(title, Math.max(halfMaxWidth, halfMaxWidth * 2 - w2), font);
                w1 = MindMapFindReplaceOperationProvider.computeTextWidth(title, font);
            }
            if (MindMapFindReplaceOperationProvider.computeTextWidth(name = NLS.bind((String)"{0} - {1}", (Object)title, (Object)pageTitle), font) > maxWidth) {
                pageTitle = MindMapFindReplaceOperationProvider.constrainText(pageTitle, Math.max(halfMaxWidth, halfMaxWidth * 2 - w1), font);
            }
            name = NLS.bind((String)"{0} - {1}", (Object)title, (Object)pageTitle);
        }
        return name;
    }

    public MindMapFindReplaceOperationProvider(IGraphicalEditor editor) {
        this.editor = editor;
    }

    protected IPart getCurrentPart() {
        IPart part;
        IGraphicalViewer viewer = this.getActiveViewer();
        if (viewer != null && (part = viewer.getFocusedPart()) != null) {
            return part;
        }
        return this.getCurrentCentralTopicPart();
    }

    private IPart getCurrentCentralTopicPart() {
        IGraphicalViewer viewer = this.getActiveViewer();
        if (viewer != null) {
            return (ITopicPart)viewer.getAdapter(ITopicPart.class);
        }
        return null;
    }

    @Override
    public boolean canFind(String toFind) {
        return this.getCurrentPart() != null;
    }

    @Override
    public boolean canReplace(String toFind, String toReplaceWith) {
        return this.canFind(toFind);
    }

    @Override
    protected boolean findAll(String toFind) {
        List<IPart> result = this.findAllParts(toFind);
        this.select(result);
        return !result.isEmpty();
    }

    @Override
    protected boolean findNext(String toFind) {
        SearchResult start = this.getStartingLocation();
        SearchResult newResult = new SearchResult(toFind);
        this.findNext(newResult, start);
        this.result = newResult;
        return this.result.found() && this.select(newResult);
    }

    private void findNext(SearchResult result, SearchResult start) {
        this.findNextInProperty(result, start);
        SearchResult next = start;
        while (!result.found()) {
            if ((next = this.getNextProperty(next)) == null || next.part == start.part && next.propertyId == start.propertyId) break;
            this.findNextInProperty(result, next);
        }
    }

    private SearchResult getNextProperty(SearchResult start) {
        SearchResult result = new SearchResult(start.toFind);
        if (start.part instanceof ITopicPart) {
            if (start.propertyId == 1) {
                result.part = start.part;
                result.propertyId = 2;
            } else if (start.propertyId == 2) {
                result.part = this.getNextPart(start.part);
                result.propertyId = 1;
            }
        } else {
            result.part = this.getNextPart(start.part);
            result.propertyId = 1;
        }
        result.offset = this.getStartingOffset(result);
        return result;
    }

    private void findNextInProperty(SearchResult result, SearchResult start) {
        int offset;
        String text = this.getPropertyText(start.part, start.propertyId);
        if (text != null && (offset = this.indexOf(text, result.toFind, start.offset)) >= 0) {
            result.part = start.part;
            result.propertyId = start.propertyId;
            result.offset = offset;
        }
    }

    private boolean select(SearchResult result) {
        int pageIndex;
        if (result.found() && (pageIndex = this.getPageIndex(result.part)) >= 0) {
            IGraphicalEditorPage page;
            if (pageIndex != this.editor.getActivePage()) {
                this.editor.setActivePage(pageIndex);
            }
            if ((page = this.editor.getActivePageInstance()) != null) {
                EditDomain domain = page.getEditDomain();
                IGraphicalViewer viewer = page.getViewer();
                if (result.propertyId == 1) {
                    this.editAndSelect(result, domain, viewer, "edit");
                } else if (result.propertyId == 2) {
                    this.editAndSelect(result, domain, viewer, "edit_label");
                }
                return true;
            }
        }
        return false;
    }

    private void editAndSelect(final SearchResult result, final EditDomain domain, IGraphicalViewer viewer, final String requestType) {
        Display.getCurrent().asyncExec(new Runnable(){

            @Override
            public void run() {
                Request request = new Request(requestType).setPrimaryTarget(result.part).setDomain(domain).setViewer((IViewer)MindMapFindReplaceOperationProvider.this.getActiveViewer()).setParameter("focus", (Object)Boolean.FALSE).setParameter("textSelection", (Object)new TextSelection(result.offset, result.toFind.length()));
                domain.handleRequest(request);
            }
        });
    }

    private SearchResult getStartingLocation() {
        SearchResult start = new SearchResult(this.result == null ? null : this.result.toFind);
        start.part = this.getCurrentPart();
        ITool tool = this.editor.getActivePageInstance().getEditDomain().getActiveTool();
        if (tool instanceof LabelEditTool) {
            start.propertyId = 2;
            start.offset = this.getStartingOffset((LabelEditTool)tool);
        } else if (tool instanceof TitleEditTool) {
            start.propertyId = 1;
            start.offset = this.getStartingOffset((TitleEditTool)tool);
        } else {
            start.propertyId = 1;
            start.offset = this.getStartingOffset(start);
        }
        return start;
    }

    private int getStartingOffset(FloatingTextEditTool tool) {
        ITextSelection selection = tool.getTextSelection();
        if (this.isForward()) {
            return selection.getOffset() + selection.getLength();
        }
        return selection.getOffset();
    }

    private int getStartingOffset(SearchResult result) {
        String text = this.getPropertyText(result.part, result.propertyId);
        return text == null ? -1 : this.getNewOffset(text);
    }

    private String getPropertyText(IPart part, int propertyId) {
        if (propertyId == 2) {
            ILabelPart label = ((ITopicPart)part).getOwnerBranch().getLabel();
            return label == null ? null : label.getLabelText();
        }
        Object model = MindMapUtils.getRealModel(part);
        if (model instanceof ITitled && ((ITitled)model).hasTitle()) {
            return ((ITitled)model).getTitleText();
        }
        ITitled titled = (ITitled)part.getAdapter(ITitled.class);
        if (titled != null && titled.hasTitle()) {
            return titled.getTitleText();
        }
        return (String)part.getAdapter(String.class);
    }

    @Override
    protected boolean replaceAll(String toFind, String toReplaceWith) {
        boolean found = this.findAll(toFind);
        if (found) {
            EditDomain domain = this.getCurrentDomain();
            if (domain == null) {
                found = false;
            } else {
                Boolean ignoreCase = (this.getParameter() & 1) == 0;
                domain.handleRequest(new Request("replace_all").setParameter("text", (Object)toFind).setParameter("replacement", (Object)toReplaceWith).setParameter("ignoreCase", (Object)ignoreCase).setDomain(domain).setViewer((IViewer)this.getActiveViewer()));
            }
        }
        return found;
    }

    @Override
    protected boolean replaceNext(String toFind, String toReplaceWith) {
        FloatingTextEditor textEditor;
        ITool tool;
        EditDomain domain = this.getCurrentDomain();
        if (domain != null && (tool = domain.getActiveTool()) != null && tool instanceof FloatingTextEditTool && (textEditor = ((FloatingTextEditTool)tool).getEditor()) != null && !textEditor.isClosed()) {
            textEditor.replaceText(toReplaceWith, true);
            textEditor.close(true);
        }
        return this.findNext(toFind);
    }

    protected List<IPart> findAllParts(String toFind) {
        return this.findAllParts(toFind, this.getCurrentPart(), null, new ArrayList<IPart>());
    }

    protected List<IPart> findAllParts(String toFind, IPart current, IPart start, List<IPart> result) {
        IPart next;
        String text;
        int index;
        if (start == null) {
            start = current;
        }
        if ((index = this.indexOf(text = this.getText(current), toFind, this.getNewOffset(text))) >= 0) {
            result.add(current);
        }
        if ((next = this.getNextPart(current)) != start) {
            result = this.findAllParts(toFind, next, start, result);
        }
        return result;
    }

    protected boolean select(List<IPart> result) {
        if (this.isEditing(null)) {
            this.getEditTool(null).handleRequest(new Request("finish").setViewer((IViewer)this.getActiveViewer()));
        }
        this.getActiveViewer().setSelection((ISelection)new StructuredSelection(result), true);
        return true;
    }

    protected String getText(IPart p) {
        if (p == null) {
            return null;
        }
        if (p instanceof ILabelPart) {
            ILabelPart labelPart = (ILabelPart)p;
            String text = labelPart.getLabelText();
            return text;
        }
        ITitled titled = (ITitled)p.getAdapter(ITitled.class);
        if (titled != null && titled.hasTitle()) {
            return titled.getTitleText();
        }
        return (String)p.getAdapter(String.class);
    }

    private int getPageIndex(IPart part) {
        Object input = part.getSite().getViewer().getInput();
        IGraphicalEditorPage page = this.editor.findPage(input);
        return page == null ? this.editor.getActivePage() : page.getIndex();
    }

    private IPart getNextPart(IPart current) {
        return this.isForward() ? this.getForwardPart(current) : this.getBackwardPart(current);
    }

    private IPart getBackwardPart(IPart current) {
        IPart prev;
        if (!this.isCentral(current) || !this.isWorkbook()) {
            IPart prev2 = this.findPrecedingPart(current);
            if (prev2 != null && prev2 != current) {
                return prev2;
            }
            if (!this.isWorkbook()) {
                return current;
            }
        }
        int pageIndex = this.getPageIndex(current);
        int pageCount = this.editor.getPageCount();
        pageIndex = pageIndex == 0 ? pageCount - 1 : --pageIndex;
        IGraphicalEditorPage page = this.editor.getPage(pageIndex);
        IGraphicalViewer viewer = page.getViewer();
        IPart central = (IPart)viewer.getAdapter(ITopicPart.class);
        if (central != null && (prev = this.findPrecedingPart(central)) != null && prev != central) {
            return prev;
        }
        return central;
    }

    private IPart getForwardPart(IPart current) {
        int pageCount;
        IPart next = this.findSucceedingPart(current);
        if (!(next == null || next == current || this.isCentral(next) && this.isWorkbook())) {
            return next;
        }
        if (!this.isWorkbook()) {
            return current;
        }
        int pageIndex = this.getPageIndex(current);
        pageIndex = pageIndex == (pageCount = this.editor.getPageCount()) - 1 ? 0 : ++pageIndex;
        IGraphicalEditorPage page = this.editor.getPage(pageIndex);
        IGraphicalViewer viewer = page.getViewer();
        return (IPart)viewer.getAdapter(ITopicPart.class);
    }

    private IPart findSucceedingPart(IPart current) {
        IPart rel;
        IPart next;
        if (current instanceof ITopicPart) {
            next = this.firstBoundary(((ITopicPart)current).getOwnerBranch());
            if (next != null) {
                return next;
            }
        } else {
            if (current instanceof IBoundaryPart) {
                IPart next2 = this.nextBoundary((IBoundaryPart)current);
                if (next2 != null) {
                    return next2;
                }
                return this.findNavNext((IPart)((IBoundaryPart)current).getOwnedBranch().getTopicPart());
            }
            if (current instanceof IRelationshipPart) {
                IPart next3 = this.nextRelationship((IRelationshipPart)current);
                if (next3 != null) {
                    return next3;
                }
                return ((IRelationshipPart)current).getOwnerSheet().getCentralBranch().getTopicPart();
            }
        }
        next = this.findNavNext(current);
        if (current instanceof ITopicPart && this.isCentral(next) && (rel = this.firstRelationship((ISheetPart)current.getSite().getViewer().getAdapter(ISheetPart.class))) != null) {
            return rel;
        }
        return next;
    }

    private IPart findPrecedingPart(IPart current) {
        if (current instanceof ITopicPart) {
            IPart prevBoundary;
            IPart rel;
            if (this.isCentral(current) && (rel = this.lastRelationship((ISheetPart)current.getSite().getViewer().getAdapter(ISheetPart.class))) != null) {
                return rel;
            }
            IPart prev = this.findNavPrev(current);
            if (prev != current && prev instanceof ITopicPart && ((ITopicPart)current).getOwnerBranch().getParentBranch() == ((ITopicPart)prev).getOwnerBranch() && (prevBoundary = this.lastBoundary(((ITopicPart)prev).getOwnerBranch())) != null) {
                return prevBoundary;
            }
            return prev;
        }
        if (current instanceof IBoundaryPart) {
            IPart prev = this.prevBoundary((IBoundaryPart)current);
            if (prev != null) {
                return prev;
            }
            return ((IBoundaryPart)current).getOwnedBranch().getTopicPart();
        }
        if (current instanceof IRelationshipPart) {
            IPart prev = this.prevRelationship((IRelationshipPart)current);
            if (prev != null) {
                return prev;
            }
            return this.findNavPrev((IPart)((IRelationshipPart)current).getOwnerSheet().getCentralBranch().getTopicPart());
        }
        return null;
    }

    private IPart findNavNext(IPart current) {
        if (current.hasRole("navigable role")) {
            IPart[] parts;
            Request navRequest = new Request("navigate_next");
            navRequest.setPrimaryTarget(current);
            IViewer viewer = current.getSite().getViewer();
            navRequest.setViewer(viewer);
            current.handleRequest(navRequest, "navigable role");
            Object result = navRequest.getResult("navigationResult");
            if (result instanceof IPart[] && (parts = (IPart[])result).length > 0) {
                IPart part = parts[0];
                return part;
            }
        }
        return null;
    }

    private IPart findNavPrev(IPart current) {
        if (current.hasRole("navigable role")) {
            IPart[] parts;
            Request navRequest = new Request("navigate_previous").setPrimaryTarget(current).setViewer(current.getSite().getViewer());
            current.handleRequest(navRequest, "navigable role");
            Object result = navRequest.getResult("navigationResult");
            if (result instanceof IPart[] && (parts = (IPart[])result).length > 0) {
                return parts[0];
            }
        }
        return null;
    }

    private IPart firstBoundary(IBranchPart branch) {
        List<IBoundaryPart> boundaries = branch.getBoundaries();
        if (boundaries.isEmpty()) {
            return null;
        }
        int start = -1;
        int end = -1;
        IBoundaryPart first = null;
        for (IBoundaryPart b : boundaries) {
            int s = b.getBoundary().getStartIndex();
            int e = b.getBoundary().getEndIndex();
            if (start >= 0 && s >= start && (s != start || end >= 0 && e <= end)) continue;
            start = s;
            end = e;
            first = b;
        }
        return first;
    }

    private IPart lastBoundary(IBranchPart branch) {
        List<IBoundaryPart> boundaries = branch.getBoundaries();
        if (boundaries.isEmpty()) {
            return null;
        }
        int start = -1;
        int end = -1;
        IBoundaryPart last = null;
        for (IBoundaryPart b : boundaries) {
            int s = b.getBoundary().getStartIndex();
            int e = b.getBoundary().getEndIndex();
            if (start >= 0 && s <= start && (s != start || end >= 0 && e >= end)) continue;
            start = s;
            end = e;
            last = b;
        }
        return last;
    }

    private IPart nextBoundary(IBoundaryPart boundary) {
        List<IBoundaryPart> boundaries = boundary.getOwnedBranch().getBoundaries();
        int start0 = boundary.getBoundary().getStartIndex();
        int end0 = boundary.getBoundary().getEndIndex();
        int start = -1;
        int end = -1;
        IBoundaryPart next = null;
        for (IBoundaryPart b : boundaries) {
            if (b == boundary) continue;
            int s = b.getBoundary().getStartIndex();
            int e = b.getBoundary().getEndIndex();
            if (s <= start0 && (s != start0 || e >= end0) || start >= 0 && s >= start && (s != start || end >= 0 && e <= end)) continue;
            start = s;
            end = e;
            next = b;
        }
        return next;
    }

    private IPart prevBoundary(IBoundaryPart boundary) {
        List<IBoundaryPart> boundaries = boundary.getOwnedBranch().getBoundaries();
        int start0 = boundary.getBoundary().getStartIndex();
        int end0 = boundary.getBoundary().getEndIndex();
        int start = -1;
        int end = -1;
        IBoundaryPart next = null;
        for (IBoundaryPart b : boundaries) {
            if (b == boundary) continue;
            int s = b.getBoundary().getStartIndex();
            int e = b.getBoundary().getEndIndex();
            if (s >= start0 && (s != start0 || e <= end0) || start >= 0 && s <= start && (s != start || end >= 0 && e >= end)) continue;
            start = s;
            end = e;
            next = b;
        }
        return next;
    }

    private List<IRelationshipPart> getRelationships(ISheetPart sheet) {
        if (sheet != null) {
            return sheet.getRelationships();
        }
        return null;
    }

    private IPart firstRelationship(ISheetPart sheet) {
        List<IRelationshipPart> rels = this.getRelationships(sheet);
        if (rels != null && !rels.isEmpty()) {
            return (IPart)rels.get(0);
        }
        return null;
    }

    private IPart lastRelationship(ISheetPart sheet) {
        List<IRelationshipPart> rels = this.getRelationships(sheet);
        if (rels != null && !rels.isEmpty()) {
            return (IPart)rels.get(rels.size() - 1);
        }
        return null;
    }

    private IPart nextRelationship(IRelationshipPart rel) {
        int index;
        List<IRelationshipPart> rels = this.getRelationships(rel.getOwnerSheet());
        if (rels != null && !rels.isEmpty() && (index = rels.indexOf(rel)) >= 0 && index < rels.size() - 1) {
            return (IPart)rels.get(index + 1);
        }
        return null;
    }

    private IPart prevRelationship(IRelationshipPart rel) {
        int index;
        List<IRelationshipPart> rels = this.getRelationships(rel.getOwnerSheet());
        if (rels != null && !rels.isEmpty() && (index = rels.indexOf(rel)) > 0) {
            return (IPart)rels.get(index - 1);
        }
        return null;
    }

    private boolean isCentral(IPart part) {
        return part instanceof ITopicPart && ((ITopicPart)part).getOwnerBranch().isCentral();
    }

    protected FloatingTextEditor getTextEditor(IPart part) {
        ITool editTool = this.getEditTool(part);
        if (editTool instanceof FloatingTextEditTool) {
            return ((FloatingTextEditTool)editTool).getEditor();
        }
        return null;
    }

    protected boolean isEditing(IPart part) {
        ITool editTool = this.getEditTool(part);
        return editTool != null && ((AbstractTool)editTool).getStatus().isStatus(1);
    }

    protected ITool getEditTool(IPart part) {
        EditDomain domain = this.getCurrentDomain();
        if (part instanceof ILabelPart) {
            return domain == null ? null : domain.getTool("org.xmind.ui.tool.editLabel");
        }
        if (part instanceof IBoundaryPart || part instanceof IRelationshipPart) {
            return domain == null ? null : domain.getTool("edit tool");
        }
        return domain == null ? null : domain.getTool("org.xmind.ui.tool.editTopicTitle");
    }

    protected ITool getDefaultTool() {
        EditDomain domain = this.getCurrentDomain();
        return domain == null ? null : domain.getDefaultTool();
    }

    protected EditDomain getCurrentDomain() {
        IGraphicalEditorPage page = this.getActivePage();
        return page == null ? null : page.getEditDomain();
    }

    protected IGraphicalViewer getActiveViewer() {
        IGraphicalEditorPage page = this.getActivePage();
        return page == null ? null : page.getViewer();
    }

    private IGraphicalEditorPage getActivePage() {
        return this.editor.getActivePageInstance();
    }

    private class SearchResult {
        final String toFind;
        IPart part = null;
        int offset = -1;
        int propertyId = 0;

        public SearchResult(String toFind) {
            this.toFind = toFind;
        }

        public boolean found() {
            if (this.part == null) {
                return false;
            }
            return this.offset >= 0;
        }

        public boolean sameLocation(SearchResult that) {
            if (that == null) {
                return false;
            }
            if (this.part != that.part) {
                return false;
            }
            return this.propertyId == that.propertyId && this.offset == that.offset;
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (!(obj instanceof SearchResult)) {
                return false;
            }
            SearchResult that = (SearchResult)obj;
            return (this.toFind == that.toFind || this.toFind != null && this.toFind.equals(that.toFind)) && this.sameLocation(that);
        }
    }
}

