/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.e4handlers;

import java.util.Arrays;
import java.util.List;
import javax.inject.Named;
import org.eclipse.e4.core.di.annotations.CanExecute;
import org.eclipse.e4.core.di.annotations.Execute;
import org.eclipse.e4.core.di.annotations.Optional;
import org.eclipse.e4.ui.model.application.MApplication;
import org.eclipse.e4.ui.model.application.descriptor.basic.MPartDescriptor;
import org.eclipse.e4.ui.model.application.ui.MUIElement;
import org.eclipse.e4.ui.model.application.ui.basic.MDialog;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.e4.ui.model.application.ui.basic.MWindow;
import org.eclipse.e4.ui.workbench.modeling.EModelService;
import org.eclipse.e4.ui.workbench.modeling.EPartService;
import org.osgi.framework.FrameworkUtil;

public class DialogPartHandler {
    private static final String DIALOG_PREFIX = "DIALOG:";
    private static final String DIALOG_PART_SHARED_LIBRARIES = "org.xmind.ui.dialogPart.sharedLibraries";
    private static final int DEFAULT_DIALOG_Y = 0;
    private static final int DEFAULT_DIALOG_X = 0;
    private static final int DEFAULT_DIALOG_WIDTH = 800;
    private static final int DEFAULT_DIALOG_HEIGHT = 600;

    @Execute
    public void run(EPartService ps, MApplication appli, EModelService modelService, @Named(value="org.xmind.ui.commandParameter.modelPart.partId") String partId, @Optional @Named(value="org.xmind.ui.commandParameter.modelPart.pageId") String pageId) {
        if (partId == null) {
            return;
        }
        MPartDescriptor partDescriptor = null;
        for (MPartDescriptor mp : appli.getDescriptors()) {
            if (!partId.equals(mp.getElementId())) continue;
            partDescriptor = mp;
            break;
        }
        if (partDescriptor == null) {
            return;
        }
        List existingDialogs = modelService.findElements((MUIElement)appli, DIALOG_PREFIX + partId, MDialog.class, null);
        boolean dialogExisted = !existingDialogs.isEmpty();
        MDialog dialogModel = dialogExisted ? (MDialog)existingDialogs.get(0) : this.createDialog(modelService, partDescriptor, partId);
        this.configDialog(dialogModel, partDescriptor);
        MPart p = ps.findPart(partId);
        if (p == null) {
            p = ps.createPart(partId);
            dialogModel.getChildren().add(p);
            dialogModel.setSelectedElement((MUIElement)p);
        }
        if (!dialogExisted) {
            ((MWindow)appli.getChildren().get(0)).getWindows().add(dialogModel);
        }
        if (pageId != null) {
            p.getPersistedState().put("org.xmind.ui.modelPart.currentPageId", pageId);
        }
        p.setVisible(true);
        modelService.bringToTop((MUIElement)p);
        ps.activate(p, true);
    }

    private MDialog createDialog(EModelService modelService, MPartDescriptor partDescriptor, String partId) {
        String contributorURI = "platform:/plugin/" + FrameworkUtil.getBundle(this.getClass()).getSymbolicName();
        MDialog dialogModel = (MDialog)modelService.createModelElement(MDialog.class);
        dialogModel.setElementId(DIALOG_PREFIX + partId);
        dialogModel.setLabel(partDescriptor.getLocalizedLabel());
        dialogModel.setContributorURI(contributorURI);
        String dialogStyle = (String)partDescriptor.getPersistedState().get("styleOverride");
        dialogModel.getPersistedState().put("styleOverride", dialogStyle);
        return dialogModel;
    }

    private void configDialog(MDialog dialogModel, MPartDescriptor partDescriptor) {
        String[] locations;
        String location = (String)dialogModel.getPersistedState().get("org.xmind.ui.dialogPart.customLocation");
        if (location == null || location.equals("")) {
            location = (String)partDescriptor.getPersistedState().get("org.xmind.ui.dialogPart.customLocation");
        }
        if ((locations = (location = location == null ? "" : location).split(",")).length < 4) {
            String[] tempLocations = new String[4];
            int i = 0;
            while (i < locations.length) {
                tempLocations[i] = locations[i];
                ++i;
            }
            locations = tempLocations;
        }
        int dialogX = this.getDigitalValue(locations[0], 0);
        int dialogY = this.getDigitalValue(locations[1], 0);
        int dialogW = this.getDigitalValue(locations[2], 800);
        int dialogH = this.getDigitalValue(locations[3], 600);
        dialogModel.setX(dialogX);
        dialogModel.setY(dialogY);
        dialogModel.setWidth(dialogW);
        dialogModel.setHeight(dialogH);
        dialogModel.getPersistedState().put("org.xmind.ui.dialogPart.customLocation", location);
    }

    private boolean isNone(String value) {
        return value == null || "".equals(value);
    }

    private int getDigitalValue(String value, int defaultValue) {
        return this.isNone(value) ? defaultValue : Integer.valueOf(value);
    }

    @CanExecute
    public boolean canExecute(MApplication app, EModelService modelService, @Named(value="org.xmind.ui.commandParameter.modelPart.partId") String partId) {
        if (DIALOG_PART_SHARED_LIBRARIES.equals(partId)) {
            return true;
        }
        List editors = modelService.findElements((MUIElement)app, null, MPart.class, Arrays.asList("Editor"));
        return !editors.isEmpty();
    }
}

