/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.dialogs;

import java.util.ArrayList;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorPart;
import org.xmind.core.IRevision;
import org.xmind.core.IRevisionManager;
import org.xmind.core.ISheet;
import org.xmind.core.IWorkbook;
import org.xmind.ui.internal.dialogs.DialogMessages;
import org.xmind.ui.internal.editor.MindMapEditor;

public class ReduceFileSizeDialog
extends Dialog {
    private IEditorPart editor;
    private Button editingHistoryCheckbox;
    private Button previewImageCheckbox;

    public ReduceFileSizeDialog(IEditorPart editor) {
        super(editor.getSite().getShell());
        this.editor = editor;
    }

    public void create() {
        super.create();
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        Label title = new Label(composite, 0);
        title.setText(DialogMessages.ReduceFileSize_text);
        FontData fontData = title.getFont().getFontData()[0];
        Font font = new Font((Device)Display.getDefault(), new FontData(fontData.getName(), fontData.getHeight() + 2, 1));
        title.setFont(font);
        Label label = new Label(composite, 64);
        label.setText(DialogMessages.ReduceFileSize_Advise_text);
        GridData gridData = new GridData(4, 4, true, false);
        gridData.widthHint = 380;
        gridData.heightHint = -1;
        label.setLayoutData((Object)gridData);
        this.editingHistoryCheckbox = new Button(composite, 32);
        this.editingHistoryCheckbox.setSelection(true);
        this.editingHistoryCheckbox.setText(DialogMessages.DeleteEditingHistory_text);
        GridData ehcGridData = new GridData(4, 4, true, false);
        ehcGridData.widthHint = 380;
        ehcGridData.heightHint = -1;
        ehcGridData.horizontalIndent = 20;
        ehcGridData.verticalIndent = 10;
        this.editingHistoryCheckbox.setLayoutData((Object)ehcGridData);
        this.previewImageCheckbox = new Button(composite, 32);
        this.previewImageCheckbox.setText(DialogMessages.DeletePreviewImage_text);
        GridData picGridData = new GridData(4, 4, true, false);
        picGridData.widthHint = 380;
        picGridData.heightHint = -1;
        picGridData.horizontalIndent = 20;
        this.previewImageCheckbox.setLayoutData((Object)picGridData);
        SelectionAdapter listener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ReduceFileSizeDialog.this.getButton(0).setEnabled(ReduceFileSizeDialog.this.editingHistoryCheckbox.getSelection() || ReduceFileSizeDialog.this.previewImageCheckbox.getSelection());
            }
        };
        this.editingHistoryCheckbox.addSelectionListener((SelectionListener)listener);
        this.previewImageCheckbox.addSelectionListener((SelectionListener)listener);
        return composite;
    }

    protected void okPressed() {
        boolean deleteEditingHistory = this.editingHistoryCheckbox.getSelection();
        boolean deletePreviewImage = this.previewImageCheckbox.getSelection();
        if (!deleteEditingHistory && !deletePreviewImage) {
            return;
        }
        IWorkbook workbook = (IWorkbook)this.editor.getAdapter(IWorkbook.class);
        if (deleteEditingHistory) {
            for (ISheet sheet : workbook.getSheets()) {
                IRevisionManager rm = workbook.getRevisionRepository().getRevisionManager(sheet.getId(), "application/vnd.xmind.sheet");
                ArrayList revisions = new ArrayList(rm.getRevisions());
                for (IRevision r : revisions) {
                    rm.removeRevision(r);
                }
            }
        }
        if (deletePreviewImage) {
            ((MindMapEditor)this.editor).skipNextPreviewImage();
        }
        NullProgressMonitor progress = new NullProgressMonitor();
        this.editor.doSave((IProgressMonitor)progress);
        if (progress.isCanceled()) {
            this.getShell().setActive();
            return;
        }
        super.okPressed();
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(DialogMessages.ReduceFileSize_text);
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 0, DialogMessages.ReduceAndSave_text, true);
        this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
    }
}

