/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.dialogs;

import java.util.Arrays;
import java.util.Comparator;
import org.eclipse.e4.ui.workbench.modeling.ESelectionService;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.resource.DeviceResourceDescriptor;
import org.eclipse.jface.resource.FontDescriptor;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.LocalResourceManager;
import org.eclipse.jface.resource.ResourceManager;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.Hyperlink;
import org.eclipse.ui.internal.WorkbenchImages;
import org.eclipse.ui.internal.progress.AbstractProgressViewer;
import org.eclipse.ui.internal.progress.DetailedProgressViewer;
import org.eclipse.ui.internal.progress.FinishedJobs;
import org.eclipse.ui.internal.progress.JobInfo;
import org.eclipse.ui.internal.progress.JobTreeElement;
import org.eclipse.ui.internal.progress.ProgressManager;
import org.eclipse.ui.internal.progress.ProgressMessages;
import org.eclipse.ui.internal.progress.ProgressViewerContentProvider;
import org.eclipse.ui.internal.util.PrefUtil;
import org.xmind.ui.internal.MindMapMessages;
import org.xmind.ui.internal.e4models.ModelPart;
import org.xmind.ui.mindmap.MindMapUI;
import org.xmind.ui.resources.ColorUtils;
import org.xmind.ui.resources.FontUtils;

public class ProgressDialogPart
extends ModelPart {
    public static final String CONTEXT_MENU_ID = "org.xmind.ui.ProgressDialog";
    private ResourceManager resources;
    private DetailedProgressViewer viewer;
    private Control control;
    private Hyperlink removeAllHyperlink;
    private Action clearAllAction;
    private Action cancelAction;

    protected void createContent(Composite parent) {
        this.resources = new LocalResourceManager(JFaceResources.getResources(), (Control)parent);
        Composite composite = new Composite(parent, 0);
        composite.setLayoutData((Object)new GridData(1808));
        composite.setBackground((Color)this.resources.get((DeviceResourceDescriptor)ColorUtils.toDescriptor((String)"#ffffff")));
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.verticalSpacing = 0;
        layout.horizontalSpacing = 0;
        composite.setLayout((Layout)layout);
        this.createContentsSection(composite);
        this.createBottomSection(composite);
        this.control = composite;
    }

    private void createContentsSection(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayoutData((Object)new GridData(1808));
        composite.setBackground((Color)this.resources.get((DeviceResourceDescriptor)ColorUtils.toDescriptor((String)"#d8d8d8")));
        GridLayout layout = new GridLayout();
        layout.marginHeight = 1;
        layout.marginWidth = 1;
        layout.verticalSpacing = 0;
        composite.setLayout((Layout)layout);
        Composite composite2 = new Composite(composite, 0);
        composite2.setLayoutData((Object)new GridData(1808));
        composite2.setBackground(parent.getBackground());
        GridLayout layout2 = new GridLayout();
        layout2.marginHeight = 0;
        layout2.marginWidth = 0;
        layout2.marginBottom = 0;
        layout2.verticalSpacing = 0;
        layout2.horizontalSpacing = 0;
        composite2.setLayout((Layout)layout2);
        this.createProgressViewerSection(composite2);
        this.createShowOperationsCheck(composite2);
    }

    protected void createProgressViewerSection(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayoutData((Object)new GridData(1808));
        composite.setBackground(parent.getBackground());
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.marginBottom = 0;
        layout.verticalSpacing = 0;
        layout.horizontalSpacing = 0;
        composite.setLayout((Layout)layout);
        this.createProgressViewer(composite);
    }

    private void createProgressViewer(Composite parent) {
        this.viewer = new ProgressViewer(parent, 258);
        this.viewer.setComparator((ViewerComparator)new ProgressViewerComparator());
        this.viewer.getControl().setLayoutData((Object)new GridData(4, 4, true, true));
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, "org.eclipse.ui.responsive_ui_context");
        this.initContentProvider();
        this.createClearAllAction();
        this.createCancelAction();
        this.initContextMenu();
        this.setSelectionProvider((ISelectionProvider)this.viewer);
    }

    private void createShowOperationsCheck(Composite parent) {
        Composite border = new Composite(parent, 0);
        border.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        border.setBackground((Color)this.resources.get((DeviceResourceDescriptor)ColorUtils.toDescriptor((String)"#d8d8d8")));
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.marginTop = 1;
        layout.marginBottom = 0;
        layout.verticalSpacing = 0;
        layout.horizontalSpacing = 0;
        border.setLayout((Layout)layout);
        Composite composite = new Composite(border, 0);
        composite.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        composite.setBackground((Color)this.resources.get((DeviceResourceDescriptor)ColorUtils.toDescriptor((String)"#ffffff")));
        GridLayout layout2 = new GridLayout();
        layout2.marginHeight = 8;
        layout2.marginWidth = 0;
        layout2.marginTop = 0;
        layout2.marginBottom = 0;
        layout2.verticalSpacing = 0;
        layout2.horizontalSpacing = 0;
        composite.setLayout((Layout)layout2);
        Composite composite2 = new Composite(composite, 0);
        composite2.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        composite2.setBackground(composite.getBackground());
        GridLayout layout3 = new GridLayout(2, false);
        layout3.marginHeight = 0;
        layout3.marginWidth = 15;
        layout3.verticalSpacing = 0;
        layout3.horizontalSpacing = 0;
        composite2.setLayout((Layout)layout3);
        final Button showSystemCheck = new Button(composite2, 32);
        showSystemCheck.setBackground(composite2.getBackground());
        showSystemCheck.setLayoutData((Object)new GridData(16384, 0x1000000, true, false));
        showSystemCheck.setText(MindMapMessages.ProgressDialog_ShowSystem_check);
        showSystemCheck.setForeground((Color)this.resources.get((DeviceResourceDescriptor)ColorUtils.toDescriptor((String)"#000000")));
        boolean showSystemJobs = PrefUtil.getAPIPreferenceStore().getBoolean("SHOW_SYSTEM_JOBS");
        showSystemCheck.setSelection(showSystemJobs);
        showSystemCheck.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                boolean showSystem = showSystemCheck.getSelection();
                PrefUtil.getAPIPreferenceStore().setValue("SHOW_SYSTEM_JOBS", showSystem);
                ProgressDialogPart.this.viewer.refresh();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
    }

    private void createBottomSection(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        composite.setBackground((Color)this.resources.get((DeviceResourceDescriptor)ColorUtils.toDescriptor((String)"#f3f3f3")));
        GridLayout layout = new GridLayout(2, false);
        layout.marginHeight = 14;
        layout.marginWidth = 0;
        layout.marginRight = 13;
        layout.marginBottom = 1;
        layout.verticalSpacing = 0;
        layout.horizontalSpacing = 0;
        composite.setLayout((Layout)layout);
        this.createRemoveAllHyperlink(composite);
        this.createButtonBar(composite);
    }

    private void createRemoveAllHyperlink(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        composite.setBackground(parent.getBackground());
        GridLayout layout = new GridLayout(1, false);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.marginLeft = 35;
        composite.setLayout((Layout)layout);
        this.removeAllHyperlink = new Hyperlink(composite, 0);
        this.removeAllHyperlink.setBackground(composite.getBackground());
        this.removeAllHyperlink.setLayoutData((Object)new GridData(16384, 0x1000000, true, false));
        this.removeAllHyperlink.setText(MindMapMessages.ProgressDialog_RemoveAll_hyperlink);
        this.removeAllHyperlink.setUnderlined(false);
        this.removeAllHyperlink.setForeground((Color)this.resources.get((DeviceResourceDescriptor)ColorUtils.toDescriptor((String)"#6484fc")));
        this.removeAllHyperlink.setFont((Font)this.resources.get((DeviceResourceDescriptor)FontDescriptor.createFrom((FontData[])FontUtils.relativeHeight((FontData[])this.removeAllHyperlink.getFont().getFontData(), (int)-1))));
        this.removeAllHyperlink.addHyperlinkListener(new IHyperlinkListener(){

            public void linkExited(HyperlinkEvent e) {
            }

            public void linkEntered(HyperlinkEvent e) {
            }

            public void linkActivated(HyperlinkEvent e) {
                ProgressDialogPart.this.clearAllAction.run();
            }
        });
        Object[] elements = ((IStructuredContentProvider)this.viewer.getContentProvider()).getElements(this.viewer.getInput());
        this.removeAllHyperlink.setEnabled(elements.length != 0);
    }

    private void createButtonBar(Composite parent) {
        Composite buttonBar = new Composite(parent, 0);
        buttonBar.setLayoutData((Object)new GridData(131072, 0x1000000, false, false));
        buttonBar.setBackground(parent.getBackground());
        GridLayout layout = new GridLayout();
        layout.numColumns = 0;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.verticalSpacing = 0;
        layout.horizontalSpacing = 6;
        buttonBar.setLayout((Layout)layout);
        this.createButton(buttonBar, 1, IDialogConstants.CLOSE_LABEL, false);
    }

    private Button createButton(Composite parent, int id, String label, boolean defaultButton) {
        Shell shell;
        ++((GridLayout)parent.getLayout()).numColumns;
        Button button = new Button(parent, 8);
        button.setBackground(parent.getBackground());
        button.setText(label);
        button.setFont(JFaceResources.getDialogFont());
        button.setData((Object)id);
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                ProgressDialogPart.this.buttonPressed((Integer)event.widget.getData());
            }
        });
        if (defaultButton && (shell = parent.getShell()) != null) {
            shell.setDefaultButton(button);
        }
        this.setButtonLayoutData(button);
        return button;
    }

    private void setButtonLayoutData(Button button) {
        GridData data = new GridData(256);
        data.widthHint = 92;
        button.setLayoutData((Object)data);
    }

    private void buttonPressed(int buttonId) {
        if (1 == buttonId) {
            this.cancelPressed();
        }
    }

    private void cancelPressed() {
        this.close();
    }

    private void close() {
        if (this.control != null && !this.control.isDisposed()) {
            this.control.getShell().close();
        }
    }

    protected void setFocus() {
        super.setFocus();
        if (this.viewer != null) {
            this.viewer.setFocus();
        }
    }

    private void initContentProvider() {
        ProgressViewerContentProvider provider = new ProgressViewerContentProvider((AbstractProgressViewer)this.viewer, true, true);
        this.viewer.setContentProvider((IContentProvider)provider);
        this.viewer.setInput((Object)ProgressManager.getInstance());
    }

    private void initContextMenu() {
        MenuManager menuMgr = new MenuManager("#PopupMenu");
        Menu menu = menuMgr.createContextMenu(this.viewer.getControl());
        menuMgr.add((IAction)this.cancelAction);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                JobInfo info = ProgressDialogPart.this.getSelectedInfo();
                if (info == null) {
                    return;
                }
            }
        });
        menuMgr.add((IContributionItem)new Separator("additions"));
        this.viewer.getControl().setMenu(menu);
        this.registerContextMenu(this.viewer.getControl(), CONTEXT_MENU_ID);
    }

    private JobInfo getSelectedInfo() {
        JobTreeElement element;
        IStructuredSelection selection = this.getSelection();
        if (selection != null && selection.size() == 1 && (element = (JobTreeElement)selection.getFirstElement()) instanceof JobInfo) {
            return (JobInfo)element;
        }
        return null;
    }

    private IStructuredSelection getSelection() {
        ESelectionService selectionService = this.getAdapter(ESelectionService.class);
        if (selectionService != null) {
            Object selection = selectionService.getSelection();
            return selection instanceof IStructuredSelection ? (IStructuredSelection)selection : null;
        }
        return null;
    }

    private void createCancelAction() {
        this.cancelAction = new Action(ProgressMessages.ProgressView_CancelAction){

            public void run() {
                ProgressDialogPart.this.viewer.cancelSelection();
            }
        };
    }

    private void createClearAllAction() {
        this.clearAllAction = new Action(ProgressMessages.ProgressView_ClearAllAction){

            public void run() {
                FinishedJobs.getInstance().clearAll();
            }
        };
        this.clearAllAction.setToolTipText(ProgressMessages.NewProgressView_RemoveAllJobsToolTip);
        ImageDescriptor id = WorkbenchImages.getWorkbenchImageDescriptor((String)"/elcl16/progress_remall.png");
        if (id != null) {
            this.clearAllAction.setImageDescriptor(id);
        }
        if ((id = WorkbenchImages.getWorkbenchImageDescriptor((String)"/dlcl16/progress_remall.png")) != null) {
            this.clearAllAction.setDisabledImageDescriptor(id);
        }
    }

    public <T> T getAdapter(Class<T> adapter) {
        if (adapter.isAssignableFrom(DetailedProgressViewer.class)) {
            return adapter.cast(this.viewer);
        }
        return (T)super.getAdapter(adapter);
    }

    private class ProgressViewer
    extends DetailedProgressViewer {
        private Control nullContentArea;

        public ProgressViewer(Composite parent, int style) {
            super(parent, style);
        }

        public void add(Object[] elements) {
            super.add(elements);
            this.updateForShowingContent();
        }

        public void remove(Object[] elements) {
            super.remove(elements);
            this.updateForShowingContent();
        }

        protected void inputChanged(Object input, Object oldInput) {
            super.inputChanged(input, oldInput);
            this.updateForShowingContent();
        }

        protected void internalRefresh(Object element) {
            super.internalRefresh(element);
            this.updateForShowingContent();
        }

        private void updateForShowingContent() {
            Control control = this.getControl();
            if (control == null || control.isDisposed()) {
                return;
            }
            if (this.getContentProvider() == null) {
                return;
            }
            Object[] elements = ((IStructuredContentProvider)this.getContentProvider()).getElements(this.getInput());
            if (elements.length != 0) {
                if (this.nullContentArea != null) {
                    this.nullContentArea.setVisible(false);
                    ((GridData)this.nullContentArea.getLayoutData()).exclude = true;
                }
                control.setVisible(true);
                ((GridData)control.getLayoutData()).exclude = false;
                if (ProgressDialogPart.this.removeAllHyperlink != null && !ProgressDialogPart.this.removeAllHyperlink.isDisposed()) {
                    ProgressDialogPart.this.removeAllHyperlink.setEnabled(true);
                }
            } else {
                control.setVisible(false);
                ((GridData)control.getLayoutData()).exclude = true;
                if (this.nullContentArea == null) {
                    this.nullContentArea = this.createNullContentArea(control.getParent());
                }
                this.nullContentArea.setVisible(true);
                ((GridData)this.nullContentArea.getLayoutData()).exclude = false;
                if (ProgressDialogPart.this.removeAllHyperlink != null && !ProgressDialogPart.this.removeAllHyperlink.isDisposed()) {
                    ProgressDialogPart.this.removeAllHyperlink.setEnabled(false);
                }
            }
            this.getControl().getParent().layout();
        }

        private Composite createNullContentArea(Composite parent) {
            Composite composite = new Composite(parent, 0);
            composite.setBackground(composite.getParent().getBackground());
            GridData layoutData = new GridData(1808);
            composite.setLayoutData((Object)layoutData);
            GridLayout layout = new GridLayout(1, false);
            layout.marginWidth = 0;
            layout.marginHeight = 0;
            layout.verticalSpacing = 0;
            composite.setLayout((Layout)layout);
            this.createNullContent(composite);
            return composite;
        }

        private void createNullContent(Composite parent) {
            Composite composite = new Composite(parent, 0);
            composite.setBackground(composite.getParent().getBackground());
            composite.setLayoutData((Object)new GridData(0x1000000, 0x1000000, true, true));
            GridLayout layout = new GridLayout(1, false);
            layout.marginWidth = 0;
            layout.marginHeight = 0;
            layout.verticalSpacing = 20;
            composite.setLayout((Layout)layout);
            Label label = new Label(composite, 0);
            label.setBackground(label.getParent().getBackground());
            label.setLayoutData((Object)new GridData(0x1000000, 0x1000000, false, false));
            label.setImage((Image)ProgressDialogPart.this.resources.get((DeviceResourceDescriptor)MindMapUI.getImages().get("progress_no_operations.png", true)));
            Composite composite2 = new Composite(composite, 0);
            composite2.setBackground(composite2.getParent().getBackground());
            composite2.setLayoutData((Object)new GridData(0x1000000, 0x1000000, false, false));
            GridLayout layout2 = new GridLayout(1, false);
            layout2.marginWidth = 0;
            layout2.marginHeight = 0;
            layout2.verticalSpacing = 0;
            composite2.setLayout((Layout)layout2);
            Label label2 = new Label(composite2, 0);
            label2.setBackground(label2.getParent().getBackground());
            label2.setForeground(ProgressDialogPart.this.resources.createColor(ColorUtils.toDescriptor((String)"#aaaaaa")));
            label2.setLayoutData((Object)new GridData(0x1000000, 0x1000000, false, false));
            label2.setText(MindMapMessages.ProgressDialog_NullContet_message);
            label2.setFont(ProgressDialogPart.this.resources.createFont(FontDescriptor.createFrom((FontData[])FontUtils.relativeHeight((FontData[])label2.getFont().getFontData(), (int)1))));
        }
    }

    private static class ProgressViewerComparator
    extends ViewerComparator {
        private ProgressViewerComparator() {
        }

        public int compare(Viewer testViewer, Object e1, Object e2) {
            return ((Comparable)e1).compareTo(e2);
        }

        public void sort(final Viewer viewer, Object[] elements) {
            int retries = 3;
            while (retries > 0) {
                try {
                    Arrays.sort(elements, new Comparator<Object>(){

                        @Override
                        public int compare(Object a, Object b) {
                            return ProgressViewerComparator.this.compare(viewer, a, b);
                        }
                    });
                    return;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    --retries;
                }
            }
            super.sort(viewer, elements);
        }
    }
}

