/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.decorators;

import org.eclipse.draw2d.IFigure;
import org.xmind.gef.draw2d.DecoratedShapeFigure;
import org.xmind.gef.draw2d.decoration.IShapeDecorationEx;
import org.xmind.gef.part.Decorator;
import org.xmind.gef.part.IGraphicalPart;
import org.xmind.ui.internal.decorations.RoundedRectTopicDecoration;
import org.xmind.ui.internal.mindmap.LegendPart;
import org.xmind.ui.resources.ColorUtils;
import org.xmind.ui.style.StyleUtils;

public class LegendDecorator
extends Decorator {
    private static final int H_MARGIN = 10;
    private static final int V_MARGIN = 6;
    private static final LegendDecorator instance = new LegendDecorator();

    public void decorate(IGraphicalPart part, IFigure figure) {
        super.decorate(part, figure);
        if (figure instanceof DecoratedShapeFigure) {
            DecoratedShapeFigure fig = (DecoratedShapeFigure)figure;
            RoundedRectTopicDecoration shape = new RoundedRectTopicDecoration();
            shape.setLeftMargin(figure, 10);
            shape.setTopMargin(figure, 6);
            shape.setRightMargin(figure, 10);
            shape.setBottomMargin(figure, 6);
            shape.setCornerSize(figure, 10);
            if (part instanceof LegendPart) {
                shape.setFillColor(figure, StyleUtils.getColor(((LegendPart)part).getOwnedSheet(), StyleUtils.getStyleSelector(((LegendPart)part).getOwnedSheet()), "legendFillColor", shape.getId(), "#ffffd0"));
            }
            shape.setLineColor(figure, ColorUtils.getColor((String)"#dddddd"));
            shape.setLineWidth(figure, 1);
            fig.setDecoration((IShapeDecorationEx)shape);
        }
    }

    public static LegendDecorator getInstance() {
        return instance;
    }
}

