/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.decorations;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.widgets.Display;
import org.xmind.gef.draw2d.geometry.Geometry;
import org.xmind.gef.draw2d.geometry.PrecisionPoint;
import org.xmind.gef.draw2d.graphics.GraphicsUtils;
import org.xmind.gef.draw2d.graphics.Path;
import org.xmind.gef.graphicalpolicy.IStructure;
import org.xmind.ui.branch.IBranchStructureExtension;
import org.xmind.ui.decorations.AbstractBoundaryDecoration;
import org.xmind.ui.mindmap.IBoundaryPart;
import org.xmind.ui.mindmap.IBranchPart;
import org.xmind.ui.mindmap.ITopicPart;

public class PolygonBoundaryDecoration
extends AbstractBoundaryDecoration {
    private IBoundaryPart boundary;

    public PolygonBoundaryDecoration() {
    }

    public PolygonBoundaryDecoration(String id) {
        super(id);
    }

    public PolygonBoundaryDecoration(IBoundaryPart boundary, String id) {
        super(id);
        this.boundary = boundary;
    }

    protected void sketch(IFigure figure, Path shape, Rectangle box, int purpose) {
        List<Point> points = this.calcPathPoints(box, this.boundary);
        if (points.size() > 4) {
            shape.moveTo(points.get(0));
            int i = 1;
            while (i < points.size()) {
                shape.lineTo(points.get(i));
                ++i;
            }
            shape.lineTo(points.get(0));
            shape.close();
        } else {
            shape.addRectangle(box);
        }
    }

    public PrecisionPoint getAnchorLocation(IFigure figure, double refX, double refY, double expansion) {
        Rectangle bounds = figure.getBounds();
        PrecisionPoint p1 = new PrecisionPoint(bounds.x + bounds.width / 2, bounds.y + bounds.height / 2);
        PrecisionPoint p2 = Geometry.getChopBoxLocation((double)refX, (double)refY, (Rectangle)this.getOutlineBox(figure), (double)expansion);
        return this.calcAnchorLocation(figure, p1, p2);
    }

    private PrecisionPoint calcAnchorLocation(IFigure figure, PrecisionPoint p1, PrecisionPoint p2) {
        double d = p1.getDistance(p2);
        int n = this.getLineWidth() == 0 ? 1 : this.getLineWidth();
        if (d < (double)n) {
            return p2;
        }
        PrecisionPoint p3 = new PrecisionPoint((p1.x + p2.x) / 2.0, (p1.y + p2.y) / 2.0);
        if (this.containsPoint(figure, (float)p3.x, (float)p3.y)) {
            return this.calcAnchorLocation(figure, p3, p2);
        }
        return this.calcAnchorLocation(figure, p1, p3);
    }

    private boolean containsPoint(IFigure figure, float x, float y) {
        this.checkValidation(figure);
        GC gc = GraphicsUtils.getAdvanced().getGC();
        gc.setLineWidth(this.getCheckingLineWidth());
        Path shape = new Path((Device)Display.getCurrent());
        this.sketch(figure, shape, this.getOutlineBox(figure), 1);
        boolean ret = shape.contains(x, y, gc, false);
        shape.close();
        shape.dispose();
        return ret;
    }

    protected List<Point> calcPathPoints(Rectangle box, IBoundaryPart boundary) {
        List<IBranchPart> enclosingBranches = boundary.getEnclosingBranches();
        IBranchPart branch = !enclosingBranches.isEmpty() ? enclosingBranches.get(0) : boundary.getOwnedBranch();
        int childDirection = this.calcChildDirection(branch);
        List<ITopicPart> topics = this.collectTopics(boundary);
        ArrayList<Point> points = new ArrayList<Point>();
        switch (childDirection) {
            case 8: {
                this.collectPointsWestDire(points, topics, box);
                break;
            }
            case 16: {
                this.collcetPointsEastDire(points, topics, box);
                break;
            }
            case 4: {
                this.collectPointsSouthDire(points, topics, box);
                break;
            }
            case 1: {
                this.collectPointsNorthDire(points, topics, box);
            }
        }
        return points;
    }

    private void collectPointsWestDire(List<Point> points, List<ITopicPart> topics, Rectangle box) {
        int lineWidth1 = this.getLineWidth();
        int lineWidth2 = lineWidth1 > 1 ? lineWidth1 - 1 : lineWidth1;
        HashMap<ITopicPart, Integer> headMap = new HashMap<ITopicPart, Integer>();
        for (ITopicPart topic : topics) {
            Rectangle bounds = topic.getFigure().getBounds();
            ITopicPart t = this.findTopicByValue(headMap, bounds.x);
            if (t != null) {
                if (bounds.y >= t.getFigure().getBounds().y) continue;
                headMap.remove(t);
                headMap.put(topic, bounds.x);
                continue;
            }
            headMap.put(topic, bounds.x);
        }
        ArrayList<Point> headPoints = new ArrayList<Point>();
        for (ITopicPart topic : this.sortTopicPart(headMap)) {
            headPoints.add(topic.getFigure().getBounds().getTopLeft().getTranslated(-10 + lineWidth2, -10 + lineWidth2));
        }
        HashMap<ITopicPart, Integer> tailMap = new HashMap<ITopicPart, Integer>();
        for (ITopicPart topic : topics) {
            Rectangle bounds = topic.getFigure().getBounds();
            ITopicPart t = this.findTopicByValue(tailMap, bounds.x);
            if (t != null) {
                if (bounds.bottom() <= t.getFigure().getBounds().bottom()) continue;
                tailMap.remove(t);
                tailMap.put(topic, bounds.x);
                continue;
            }
            tailMap.put(topic, bounds.x);
        }
        ArrayList<Point> tailPoints = new ArrayList<Point>();
        for (ITopicPart topic : this.sortTopicPart(tailMap)) {
            tailPoints.add(topic.getFigure().getBounds().getBottomLeft().getTranslated(-10 + lineWidth2, 10 - lineWidth2));
        }
        Point tr = box.getTopRight();
        Point br = box.getBottomRight();
        this.initPoints(points, (Point)headPoints.get(0), tr, br, (Point)tailPoints.get(0));
        this.calcPointsWestOrEast(points, tr, br, headPoints, tailPoints);
    }

    private void collcetPointsEastDire(List<Point> points, List<ITopicPart> topics, Rectangle box) {
        int lineWidth1 = this.getLineWidth();
        int lineWidth2 = lineWidth1 > 1 ? lineWidth1 - 1 : lineWidth1;
        HashMap<ITopicPart, Integer> headMap = new HashMap<ITopicPart, Integer>();
        for (ITopicPart topic : topics) {
            Rectangle bounds = topic.getFigure().getBounds();
            ITopicPart t = this.findTopicByValue(headMap, -bounds.right());
            if (t != null) {
                if (bounds.y >= t.getFigure().getBounds().y) continue;
                headMap.remove(t);
                headMap.put(topic, -bounds.right());
                continue;
            }
            headMap.put(topic, -bounds.right());
        }
        ArrayList<Point> headPoints = new ArrayList<Point>();
        for (ITopicPart topic : this.sortTopicPart(headMap)) {
            headPoints.add(topic.getFigure().getBounds().getTopRight().getTranslated(10 - lineWidth1, -10 + lineWidth2));
        }
        HashMap<ITopicPart, Integer> tailMap = new HashMap<ITopicPart, Integer>();
        for (ITopicPart topic : topics) {
            Rectangle bounds = topic.getFigure().getBounds();
            ITopicPart t = this.findTopicByValue(tailMap, -bounds.right());
            if (t != null) {
                if (bounds.bottom() <= t.getFigure().getBounds().bottom()) continue;
                tailMap.remove(t);
                tailMap.put(topic, -bounds.right());
                continue;
            }
            tailMap.put(topic, -bounds.right());
        }
        ArrayList<Point> tailPoints = new ArrayList<Point>();
        for (ITopicPart topic : this.sortTopicPart(tailMap)) {
            tailPoints.add(topic.getFigure().getBounds().getBottomRight().getTranslated(10 - lineWidth1, 10 - (lineWidth1 > 1 ? lineWidth1 - 1 : lineWidth1)));
        }
        Point tl = box.getTopLeft();
        Point bl = box.getBottomLeft();
        this.initPoints(points, (Point)headPoints.get(0), tl, bl, (Point)tailPoints.get(0));
        this.calcPointsWestOrEast(points, tl, bl, headPoints, tailPoints);
    }

    private void calcPointsWestOrEast(List<Point> points, Point crl1, Point crl2, List<Point> headPoints, List<Point> tailPoints) {
        Point point;
        int i;
        int upSize = 2;
        if (headPoints.get((int)0).y > crl1.y) {
            i = headPoints.size() - 1;
            while (i > 0) {
                point = headPoints.get(i);
                Point firstPoint = points.get(0);
                Point secPoint = points.get(1);
                if (firstPoint.y == secPoint.y && !firstPoint.equals((Object)secPoint)) break;
                if (!secPoint.equals((Object)crl1) && secPoint.y == point.y) {
                    points.remove(1);
                    points.add(1, point);
                } else if (this.isUpperLine(firstPoint, secPoint, point)) {
                    points.add(1, point);
                    ++upSize;
                }
                --i;
            }
        }
        i = 1;
        while (i < upSize - 1) {
            if (!this.isUpperLine(points.get(i - 1), points.get(i + 1), points.get(i))) {
                points.remove(i--);
                --upSize;
                if (i > 1) {
                    --i;
                }
            }
            ++i;
        }
        if (tailPoints.get((int)0).y < crl2.y) {
            i = tailPoints.size() - 1;
            while (i > 0) {
                point = tailPoints.get(i);
                Point lastPoint = points.get(points.size() - 1);
                Point penPoint = points.get(points.size() - 2);
                if (lastPoint.y == penPoint.y) break;
                if (!penPoint.equals((Object)crl2) && penPoint.y == point.y) {
                    points.remove(points.size() - 2);
                    points.add(points.size() - 1, point);
                } else if (!this.isUpperLine(penPoint, lastPoint, point)) {
                    points.add(points.size() - 1, point);
                }
                --i;
            }
        }
        i = upSize + 1;
        while (i < points.size() - 1) {
            if (this.isUpperLine(points.get(i - 1), points.get(i + 1), points.get(i))) {
                points.remove(i--);
                if (i > upSize) {
                    --i;
                }
            }
            ++i;
        }
    }

    private void collectPointsSouthDire(List<Point> points, List<ITopicPart> topics, Rectangle box) {
        int lineWidth1 = this.getLineWidth();
        int lineWidth2 = lineWidth1 > 1 ? lineWidth1 - 1 : lineWidth1;
        HashMap<ITopicPart, Integer> headMap = new HashMap<ITopicPart, Integer>();
        for (ITopicPart topic : topics) {
            Rectangle bounds = topic.getFigure().getBounds();
            ITopicPart t = this.findTopicByValue(headMap, -bounds.bottom());
            if (t != null) {
                if (bounds.x >= t.getFigure().getBounds().x) continue;
                headMap.remove(t);
                headMap.put(topic, -bounds.bottom());
                continue;
            }
            headMap.put(topic, -bounds.bottom());
        }
        ArrayList<Point> headPoints = new ArrayList<Point>();
        for (ITopicPart topic : this.sortTopicPart(headMap)) {
            headPoints.add(topic.getFigure().getBounds().getBottomLeft().getTranslated(-10 + lineWidth2, 10 - lineWidth2));
        }
        HashMap<ITopicPart, Integer> tailMap = new HashMap<ITopicPart, Integer>();
        for (ITopicPart topic : topics) {
            Rectangle bounds = topic.getFigure().getBounds();
            ITopicPart t = this.findTopicByValue(tailMap, -bounds.bottom());
            if (t != null) {
                if (bounds.right() <= t.getFigure().getBounds().right()) continue;
                tailMap.remove(t);
                tailMap.put(topic, -bounds.bottom());
                continue;
            }
            tailMap.put(topic, -bounds.bottom());
        }
        ArrayList<Point> tailPoints = new ArrayList<Point>();
        for (ITopicPart topic : this.sortTopicPart(tailMap)) {
            tailPoints.add(topic.getFigure().getBounds().getBottomRight().getTranslated(10 - lineWidth1, 10 - lineWidth2));
        }
        Point tl = box.getTopLeft();
        Point tr = box.getTopRight();
        this.initPoints(points, (Point)headPoints.get(0), tl, tr, (Point)tailPoints.get(0));
        this.calcPointsSouthOrNorth(points, tl, tr, headPoints, tailPoints);
    }

    private void collectPointsNorthDire(List<Point> points, List<ITopicPart> topics, Rectangle box) {
        int lineWidth1 = this.getLineWidth();
        int lineWidth2 = lineWidth1 > 1 ? lineWidth1 - 1 : lineWidth1;
        HashMap<ITopicPart, Integer> headMap = new HashMap<ITopicPart, Integer>();
        for (ITopicPart topic : topics) {
            Rectangle bounds = topic.getFigure().getBounds();
            ITopicPart t = this.findTopicByValue(headMap, bounds.y);
            if (t != null) {
                if (bounds.x >= t.getFigure().getBounds().x) continue;
                headMap.remove(t);
                headMap.put(topic, bounds.y);
                continue;
            }
            headMap.put(topic, bounds.y);
        }
        ArrayList<Point> headPoints = new ArrayList<Point>();
        for (ITopicPart topic : this.sortTopicPart(headMap)) {
            headPoints.add(topic.getFigure().getBounds().getTopLeft().getTranslated(-10 + lineWidth2, -10 + lineWidth1));
        }
        HashMap<ITopicPart, Integer> tailMap = new HashMap<ITopicPart, Integer>();
        for (ITopicPart topic : topics) {
            Rectangle bounds = topic.getFigure().getBounds();
            ITopicPart t = this.findTopicByValue(tailMap, bounds.y);
            if (t != null) {
                if (bounds.right() <= t.getFigure().getBounds().right()) continue;
                tailMap.remove(t);
                tailMap.put(topic, bounds.y);
                continue;
            }
            tailMap.put(topic, bounds.y);
        }
        ArrayList<Point> tailPoints = new ArrayList<Point>();
        for (ITopicPart topic : this.sortTopicPart(tailMap)) {
            tailPoints.add(topic.getFigure().getBounds().getTopRight().getTranslated(10 - lineWidth1, -10 + lineWidth1));
        }
        Point bl = box.getBottomLeft();
        Point br = box.getBottomRight();
        this.initPoints(points, (Point)headPoints.get(0), bl, br, (Point)tailPoints.get(0));
        this.calcPointsSouthOrNorth(points, bl, br, headPoints, tailPoints);
    }

    private void calcPointsSouthOrNorth(List<Point> points, Point crl1, Point crl2, List<Point> headPoints, List<Point> tailPoints) {
        Point point;
        int i;
        int leftSize = 2;
        if (headPoints.get((int)0).x > crl1.x) {
            i = headPoints.size() - 1;
            while (i > 0) {
                point = headPoints.get(i);
                Point firstPoint = points.get(0);
                Point secPoint = points.get(1);
                if (firstPoint.x == secPoint.x) break;
                if (!secPoint.equals((Object)crl1) && secPoint.x == point.x) {
                    points.remove(1);
                    points.add(1, point);
                } else if (this.isLeftLine(firstPoint, secPoint, point)) {
                    points.add(1, point);
                    ++leftSize;
                }
                --i;
            }
        }
        i = 1;
        while (i < leftSize - 1) {
            if (!this.isLeftLine(points.get(i - 1), points.get(i + 1), points.get(i))) {
                points.remove(i--);
                --leftSize;
                if (i > 1) {
                    --i;
                }
            }
            ++i;
        }
        if (tailPoints.get((int)0).x < crl2.x) {
            i = tailPoints.size() - 1;
            while (i > 0) {
                point = tailPoints.get(i);
                Point lastPoint = points.get(points.size() - 1);
                Point penPoint = points.get(points.size() - 2);
                if (lastPoint.x == penPoint.x) break;
                if (!penPoint.equals((Object)crl2) && penPoint.x == point.x) {
                    points.remove(points.size() - 2);
                    points.add(points.size() - 1, point);
                } else if (!this.isLeftLine(penPoint, lastPoint, point)) {
                    points.add(points.size() - 1, point);
                }
                --i;
            }
        }
        i = leftSize + 1;
        while (i < points.size() - 1) {
            if (this.isLeftLine(points.get(i - 1), points.get(i + 1), points.get(i))) {
                points.remove(i--);
                if (i > leftSize) {
                    --i;
                }
            }
            ++i;
        }
    }

    private void initPoints(List<Point> points, Point p1, Point p2, Point p3, Point p4) {
        points.add(p1);
        points.add(p2);
        points.add(p3);
        points.add(p4);
    }

    private int calcChildDirection(IBranchPart branch) {
        IStructure structure = branch.getBranchPolicy().getStructure(branch);
        if (structure instanceof IBranchStructureExtension) {
            return ((IBranchStructureExtension)structure).getChildTargetOrientation(branch.getParentBranch(), branch);
        }
        return 0;
    }

    private List<ITopicPart> collectTopics(IBoundaryPart boundary) {
        ArrayList<ITopicPart> topics = new ArrayList<ITopicPart>();
        List<IBranchPart> branches = boundary.getEnclosingBranches();
        if (!branches.isEmpty()) {
            for (IBranchPart branch : branches) {
                topics.add(branch.getTopicPart());
                this.addAllTopics(branch, topics);
            }
        } else {
            IBranchPart branch = boundary.getOwnedBranch();
            topics.add(branch.getTopicPart());
            this.addAllTopics(branch, topics);
        }
        return topics;
    }

    private void addAllTopics(IBranchPart branch, List<ITopicPart> topics) {
        for (IBranchPart sub : branch.getSubBranches()) {
            topics.add(sub.getTopicPart());
            this.addAllTopics(sub, topics);
        }
        for (IBranchPart callout : branch.getCalloutBranches()) {
            topics.add(callout.getTopicPart());
            this.addAllTopics(callout, topics);
        }
        for (IBranchPart summary : branch.getSummaryBranches()) {
            topics.add(summary.getTopicPart());
            this.addAllTopics(summary, topics);
        }
    }

    private boolean isUpperLine(Point p1, Point p2, Point p3) {
        if (p1.y < p3.y) {
            return false;
        }
        float dx1 = Math.abs(p2.x - p1.x);
        float dy1 = Math.abs(p2.y - p1.y);
        float dx2 = Math.abs(p3.x - p1.x);
        float dy2 = Math.abs(p3.y - p1.y);
        return dy1 / dx1 < dy2 / dx2;
    }

    private boolean isLeftLine(Point p1, Point p2, Point p3) {
        float dy2;
        float dx2;
        float dy1;
        if (p1.x < p3.x) {
            return false;
        }
        float dx1 = Math.abs(p2.x - p1.x);
        return dx1 / (dy1 = (float)Math.abs(p2.y - p1.y)) < (dx2 = (float)Math.abs(p3.x - p1.x)) / (dy2 = (float)Math.abs(p3.y - p1.y));
    }

    private Set<ITopicPart> sortTopicPart(Map<ITopicPart, Integer> topicMap) {
        HashMap<ITopicPart, Integer> map = new HashMap<ITopicPart, Integer>();
        ValueComparator bvc = new ValueComparator(map);
        TreeMap<ITopicPart, Integer> sortedMap = new TreeMap<ITopicPart, Integer>(bvc);
        map.putAll(topicMap);
        sortedMap.putAll(map);
        return sortedMap.keySet();
    }

    private ITopicPart findTopicByValue(Map<ITopicPart, Integer> map, Integer value) {
        for (Map.Entry<ITopicPart, Integer> entry : map.entrySet()) {
            if (value != entry.getValue() && (value == null || !value.equals(entry.getValue()))) continue;
            return entry.getKey();
        }
        return null;
    }

    private class ValueComparator
    implements Comparator<ITopicPart> {
        private Map<ITopicPart, Integer> base;

        public ValueComparator(Map<ITopicPart, Integer> base) {
            this.base = base;
        }

        @Override
        public int compare(ITopicPart t1, ITopicPart t2) {
            if (this.base.get(t1) > this.base.get(t2)) {
                return 1;
            }
            return -1;
        }
    }
}

