/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.branch;

import java.util.Iterator;
import java.util.List;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Insets;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.xmind.gef.draw2d.IAnchor;
import org.xmind.gef.draw2d.IReferencedFigure;
import org.xmind.gef.draw2d.geometry.HorizontalFlipper;
import org.xmind.gef.draw2d.geometry.ITransformer;
import org.xmind.gef.draw2d.geometry.PrecisionPoint;
import org.xmind.gef.part.IPart;
import org.xmind.ui.branch.AbstractBranchStructure;
import org.xmind.ui.branch.BoundaryLayoutHelper;
import org.xmind.ui.branch.IInsertion;
import org.xmind.ui.branch.Insertion;
import org.xmind.ui.internal.mindmap.TopicPart;
import org.xmind.ui.mindmap.IBranchPart;
import org.xmind.ui.mindmap.IBranchRangePart;
import org.xmind.ui.mindmap.IPlusMinusPart;
import org.xmind.ui.mindmap.ISummaryPart;
import org.xmind.ui.mindmap.ITopicPart;
import org.xmind.ui.tools.ParentSearchKey;

public class LeftRightStructure
extends AbstractBranchStructure {
    private boolean leftwards;
    private ITransformer t = new HorizontalFlipper();

    protected LeftRightStructure(boolean leftwards) {
        this.leftwards = leftwards;
        this.t.setEnabled(leftwards);
    }

    public boolean isLeftwards() {
        return this.leftwards;
    }

    @Override
    protected void doFillPlusMinus(IBranchPart branch, IPlusMinusPart plusMinus, AbstractBranchStructure.LayoutInfo info) {
        Point ref = info.getReference();
        this.t.setOrigin(ref);
        int y = ref.y;
        Rectangle topicBounds = info.getCheckedClientArea();
        topicBounds = this.t.tr(topicBounds);
        int x = topicBounds.right();
        IFigure pmFigure = plusMinus.getFigure();
        Dimension size = pmFigure.getPreferredSize();
        Rectangle r = new Rectangle(x, y - size.height / 2, size.width, size.height);
        info.put(pmFigure, this.t.r(r));
    }

    @Override
    protected void doFillSubBranches(IBranchPart branch, List<IBranchPart> subBranches, AbstractBranchStructure.LayoutInfo info) {
        Dimension insSize;
        Rectangle r;
        int majorSpacing = this.getMajorSpacing(branch);
        int minorSpacing = this.getMinorSpacing(branch);
        Point ref = info.getReference();
        this.t.setOrigin(ref);
        Rectangle refBounds = info.getCheckedClientArea();
        refBounds = this.t.tr(refBounds);
        int x = refBounds.right() + majorSpacing;
        int num = subBranches.size();
        int anchorHeight = 0;
        TopicPart topicPart = (TopicPart)branch.getTopicPart();
        if (topicPart != null) {
            IAnchor anchor = topicPart.getSourceAnchor(null);
            anchorHeight = (int)anchor.getLocation((int)(this.leftwards ? 16 : 8), (double)0.0).getDifference((PrecisionPoint)anchor.getReferencePoint()).height;
        }
        int distanceTop = this.calcDistanceTop(branch, minorSpacing, true);
        int y = ref.y + anchorHeight - distanceTop;
        IInsertion insertion = this.getCurrentInsertion(branch);
        BoundaryLayoutHelper helper = this.getBoundaryLayoutHelper(branch);
        int i = 0;
        while (i < num) {
            if (insertion != null && i == insertion.getIndex()) {
                r = insertion.createRectangle(x, y);
                info.add(this.t.rr(r));
                y += r.height + minorSpacing;
            }
            IBranchPart subBranch = subBranches.get(i);
            IFigure subBranchFigure = subBranch.getFigure();
            Insets ins = helper.getInsets(subBranch);
            ins = this.t.ti(ins);
            Dimension size = subBranchFigure.getPreferredSize();
            Rectangle r2 = new Rectangle(x + ins.left, y + ins.top, size.width, size.height);
            info.put(subBranchFigure, this.t.rr(r2));
            y += size.height + ins.getHeight() + minorSpacing;
            ++i;
        }
        if (insertion != null && num == insertion.getIndex() && (insSize = insertion.getSize()) != null) {
            r = new Rectangle(x, y, insSize.width, insSize.height);
            info.add(this.t.rr(r));
        }
    }

    @Override
    public IPart calcNavigation(IBranchPart branch, String navReqType) {
        if (!branch.getSubBranches().isEmpty() && (this.isLeftwards() ? "navigate_left".equals(navReqType) : "navigate_right".equals(navReqType))) {
            return this.getSubTopicPart(branch, 0);
        }
        return super.calcNavigation(branch, navReqType);
    }

    @Override
    public IPart calcChildNavigation(IBranchPart branch, IBranchPart sourceChild, String navReqType, boolean sequential) {
        if ("navigate_up".equals(navReqType)) {
            return this.getSubTopicPart(branch, sourceChild.getBranchIndex() - 1);
        }
        if ("navigate_down".equals(navReqType)) {
            return this.getSubTopicPart(branch, sourceChild.getBranchIndex() + 1);
        }
        if (!sequential && (this.isLeftwards() ? "navigate_right".equals(navReqType) : "navigate_left".equals(navReqType))) {
            return branch.getTopicPart();
        }
        return super.calcChildNavigation(branch, sourceChild, navReqType, sequential);
    }

    @Override
    public int getSourceOrientation(IBranchPart branch) {
        if (this.isLeftwards()) {
            return 8;
        }
        return 16;
    }

    @Override
    public int getChildTargetOrientation(IBranchPart branch, IBranchPart subBranch) {
        return this.calcChildTargetOrientation();
    }

    private int calcChildTargetOrientation() {
        if (this.isLeftwards()) {
            return 16;
        }
        return 8;
    }

    @Override
    public int calcChildDistance(IBranchPart branch, ParentSearchKey key) {
        IFigure branchFigure = branch.getFigure();
        IReferencedFigure topicFigure = (IReferencedFigure)branch.getTopicPart().getFigure();
        Point ref = topicFigure.getReference();
        this.t.setOrigin(ref);
        Point childRef = this.t.tp(this.getChildRef(branch, ref, key));
        Rectangle branchBounds = this.t.tr(branchFigure.getBounds());
        Rectangle topicBounds = this.t.tr(topicFigure.getBounds());
        int dx = childRef.x - topicBounds.right();
        if (dx > 0) {
            if (childRef.y >= branchBounds.y && childRef.y < branchBounds.bottom() && dx < 200) {
                return dx;
            }
            int dy = childRef.y - ref.y;
            int d = dy * dy + dx * dx;
            return d;
        }
        return super.calcChildDistance(branch, key);
    }

    @Override
    protected int calcInsIndex(IBranchPart branch, ParentSearchKey key, boolean withDisabled) {
        if (branch.getSubBranches().isEmpty() || branch.isFolded()) {
            return withDisabled ? 0 : -1;
        }
        ITopicPart topic = branch.getTopicPart();
        if (topic == null) {
            return withDisabled ? 0 : -1;
        }
        IFigure topicFigure = topic.getFigure();
        Point ref = ((IReferencedFigure)topicFigure).getReference();
        this.t.setOrigin(ref);
        Point childRef = this.t.tp(this.getChildRef(branch, ref, key));
        Dimension insSize = this.calcInsSize(key.getFigure());
        int insHeight = insSize.height;
        int minorSpacing = this.getMinorSpacing(branch);
        int totalChildrenHeight = this.calcTotalChildrenHeight(branch, minorSpacing, false);
        int totalHeight = totalChildrenHeight + insHeight + minorSpacing;
        int startY = ref.y - totalHeight / 2;
        return this.calcInsIndex(branch, startY, childRef, insHeight, minorSpacing, withDisabled);
    }

    private int calcInsIndex(IBranchPart branch, int startY, Point childRef, int childHeight, int spacing, boolean withDisabled) {
        int ret = 0;
        int sum = 0;
        List<IBranchPart> subBranches = branch.getSubBranches();
        int num = subBranches.size();
        for (IBranchPart subBranch : subBranches) {
            IFigure subFigure = subBranch.getFigure();
            int h = this.getBorderedSize((IBranchPart)branch, (IBranchPart)subBranch).height;
            int hint = startY + sum + (childHeight + h + spacing) / 2;
            if (childRef.y < hint) {
                return ret;
            }
            sum += h + spacing;
            if (!withDisabled && !subFigure.isEnabled()) continue;
            ++ret;
        }
        return withDisabled ? num : -1;
    }

    private Dimension calcInsSize(IReferencedFigure child) {
        return child.getSize().scale(0.8);
    }

    private int calcDistanceTop(IBranchPart branch, int minorSpacing, boolean withInsertion) {
        Dimension insSize;
        IInsertion ins;
        int totalAnchorHeight = 0;
        int firstDistanceTop = 0;
        List<IBranchPart> subBranches = branch.getSubBranches();
        int num = subBranches.size();
        int i = 0;
        while (i < num) {
            IBranchPart subBranch = subBranches.get(i);
            int h = this.getBorderedSize((IBranchPart)branch, (IBranchPart)subBranch).height;
            TopicPart topicPart = (TopicPart)subBranch.getTopicPart();
            int anchorDistanceTop = 0;
            if (topicPart != null) {
                IAnchor anchor = topicPart.getTargetAnchor(null);
                anchorDistanceTop = (int)anchor.getLocation((int)(this.leftwards ? 16 : 8), (double)0.0).y - subBranch.getFigure().getBounds().y;
            }
            if (i == 0) {
                firstDistanceTop = anchorDistanceTop;
                totalAnchorHeight += num == 1 ? 0 : h - anchorDistanceTop;
            } else {
                totalAnchorHeight += minorSpacing;
                if (i == num - 1) {
                    totalAnchorHeight += anchorDistanceTop;
                    break;
                }
                totalAnchorHeight += h;
            }
            ++i;
        }
        if (withInsertion && (ins = this.getCurrentInsertion(branch)) != null && (insSize = ins.getSize()) != null) {
            totalAnchorHeight += minorSpacing + insSize.height;
        }
        return totalAnchorHeight / 2 + firstDistanceTop;
    }

    private int calcTotalChildrenHeight(IBranchPart branch, int minorSpacing, boolean withInsertion) {
        Dimension insSize;
        IInsertion ins;
        int totalHeight = 0;
        Iterator<IBranchPart> it = branch.getSubBranches().iterator();
        while (it.hasNext()) {
            IBranchPart subBranch = it.next();
            int h = this.getBorderedSize((IBranchPart)branch, (IBranchPart)subBranch).height;
            totalHeight += h;
            if (!it.hasNext()) continue;
            totalHeight += minorSpacing;
        }
        if (withInsertion && (ins = this.getCurrentInsertion(branch)) != null && (insSize = ins.getSize()) != null) {
            totalHeight += minorSpacing + insSize.height;
        }
        return totalHeight;
    }

    @Override
    public IInsertion calcInsertion(IBranchPart branch, ParentSearchKey key) {
        int newIndex = this.calcInsIndex(branch, key, true);
        Dimension newSize = this.calcInsSize(key.getFigure());
        return new Insertion(branch, newIndex, newSize);
    }

    @Override
    public int getSummaryDirection(IBranchPart branch, ISummaryPart summary) {
        if (this.leftwards) {
            return 8;
        }
        return 16;
    }

    @Override
    public int getRangeGrowthDirection(IBranchPart branch, IBranchRangePart range) {
        return 4;
    }

    @Override
    public int getQuickMoveOffset(IBranchPart branch, IBranchPart child, int direction) {
        if (direction == 4) {
            return 1;
        }
        if (direction == 1) {
            return -1;
        }
        return super.getQuickMoveOffset(branch, child, direction);
    }
}

