/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.branch;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.expressions.IEvaluationContext;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.xmind.gef.part.IGraphicalPart;
import org.xmind.ui.internal.branch.AbstractBranchStyleSelector;
import org.xmind.ui.internal.branch.BranchPolicyManager;
import org.xmind.ui.internal.branch.OverridedStyle;
import org.xmind.ui.mindmap.IBranchPart;
import org.xmind.ui.util.Logger;

public class ContributedBranchStyleSelector
extends AbstractBranchStyleSelector {
    private BranchPolicyManager manager;
    private IConfigurationElement element;
    private Map<String, List<OverridedStyle>> overridedStyles;

    public ContributedBranchStyleSelector(BranchPolicyManager manager, IConfigurationElement element) {
        this.manager = manager;
        this.element = element;
        this.loadInheritedStyles();
    }

    private void loadInheritedStyles() {
        this.registerInheritedStyleKey("line-color", "beforeThemeValue");
        this.registerInheritedStyleKey("line-width", "beforeThemeValue");
        this.registerInheritedStyleKey("line-pattern", "beforeDefaultValue");
    }

    @Override
    protected String getLayeredProperty(IGraphicalPart part, String layerName, String familyName, String key) {
        String value = super.getLayeredProperty(part, layerName, familyName, key);
        if (this.isValidValue(part, key, value)) {
            return this.getCheckedValue(value);
        }
        if (part instanceof IBranchPart) {
            IBranchPart branch = (IBranchPart)part;
            List<OverridedStyle> overrideds = this.getOverridedStyles(key);
            if (overrideds != null && !overrideds.isEmpty() && (value = this.getOverridedValue(branch, layerName, key, overrideds)) != null) {
                return value;
            }
        }
        return value;
    }

    public String getOverridedValue(IGraphicalPart part, String key, String layerName) {
        String familyName = this.getFamilyName(part);
        return this.getLayeredProperty(part, layerName, familyName, key);
    }

    private String getOverridedValue(IBranchPart branch, String layerName, String key, List<OverridedStyle> overridedStyles) {
        IEvaluationContext context = null;
        for (OverridedStyle overridedStyle : overridedStyles) {
            String value;
            if (!overridedStyle.isOnLayer(layerName)) continue;
            if (context == null) {
                context = BranchPolicyManager.createBranchEvaluationContext(branch);
            }
            if (!overridedStyle.isApplicableTo(context) || (value = overridedStyle.getValue(branch, layerName)) == null) continue;
            return value;
        }
        return null;
    }

    private List<OverridedStyle> getOverridedStyles(String key) {
        this.ensureLoaded();
        return this.overridedStyles.get(key);
    }

    private void ensureLoaded() {
        if (this.overridedStyles != null) {
            return;
        }
        this.lazyLoad();
        if (this.overridedStyles == null) {
            this.overridedStyles = Collections.emptyMap();
        }
    }

    private void lazyLoad() {
        IConfigurationElement[] children;
        IConfigurationElement[] iConfigurationElementArray = children = this.element.getChildren("overridedStyle");
        int n = children.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement child = iConfigurationElementArray[n2];
            this.loadOverridedStyle(child);
            ++n2;
        }
    }

    private void loadOverridedStyle(IConfigurationElement element) {
        try {
            OverridedStyle overridedStyle = new OverridedStyle(this.manager, element);
            this.registerOverridedStyle(overridedStyle);
        }
        catch (CoreException e) {
            Logger.log(e, "Failed to load overrided style: " + element);
        }
    }

    private void registerOverridedStyle(OverridedStyle overridedStyle) {
        List<OverridedStyle> list;
        String key = overridedStyle.getKey();
        if (this.overridedStyles == null) {
            this.overridedStyles = new HashMap<String, List<OverridedStyle>>();
        }
        if ((list = this.overridedStyles.get(key)) == null) {
            list = new ArrayList<OverridedStyle>();
            this.overridedStyles.put(key, list);
        }
        list.add(overridedStyle);
    }
}

