/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.branch;

import java.util.List;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Insets;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.xmind.gef.draw2d.IReferencedFigure;
import org.xmind.gef.part.IPart;
import org.xmind.ui.branch.AbstractBranchStructure;
import org.xmind.ui.internal.branch.BaseRadialStructure;
import org.xmind.ui.internal.branch.RadialData;
import org.xmind.ui.internal.branch.RadialUtils;
import org.xmind.ui.mindmap.IBranchPart;
import org.xmind.ui.mindmap.ITopicPart;
import org.xmind.ui.tools.ParentSearchKey;

public class ClockwiseRadialStructure
extends BaseRadialStructure {
    @Override
    protected void doFillSubBranches(IBranchPart branch, List<IBranchPart> subBranches, AbstractBranchStructure.LayoutInfo info) {
        RadialData cache = this.getRadialData(branch);
        int numRight = cache.getNumRight();
        int[] childrenSpacings = cache.getChildrenSpacings();
        int num = subBranches.size();
        boolean right = true;
        BaseRadialStructure.RadiationInsertion insertion = this.getCurrentInsertion(branch);
        int insHeight = insertion == null ? 0 : insertion.getSize().height;
        int y = -cache.getRightSumSpacing() / 2;
        if (insertion != null && insertion.right) {
            y -= insHeight / 2;
        }
        Point ref = info.getReference();
        int i = 0;
        while (i < num) {
            Rectangle r;
            if (i == numRight) {
                y = cache.getLeftSumSpacing() / 2;
                if (insertion != null && !insertion.right) {
                    y += insHeight / 2;
                }
                right = false;
            }
            if (!(insertion == null || i != insertion.getIndex() || i == numRight && insertion.right)) {
                Point p = ref.getTranslated(cache.getX(y, right), y);
                Rectangle insBounds = RadialUtils.getPrefBounds(insertion.getSize(), p, right);
                info.add(insBounds);
                y = insertion.right ? (y += insHeight) : (y -= insHeight);
            }
            IBranchPart subBranch = subBranches.get(i);
            Dimension offset = this.getOffset(subBranch);
            IFigure subFigure = subBranch.getFigure();
            if (offset != null && subFigure instanceof IReferencedFigure) {
                Point subRef = ref.getTranslated(offset);
                r = ((IReferencedFigure)subFigure).getPreferredBounds(subRef);
            } else {
                int x = cache.getX(y, right);
                Point subRef = ref.getTranslated(x, y);
                r = RadialUtils.getPrefBounds(subBranch, subRef, right);
            }
            info.put(subFigure, r);
            y = i < numRight ? (y += childrenSpacings[i]) : (y -= childrenSpacings[i]);
            if (insertion != null && (i == numRight - 1 && insertion.getIndex() == numRight && insertion.right || i == num)) {
                Point p = ref.getTranslated(cache.getX(y, right), y);
                Rectangle insBounds = RadialUtils.getPrefBounds(insertion.getSize(), p, right);
                info.add(insBounds);
                y += insHeight;
            }
            ++i;
        }
    }

    @Override
    public IPart calcChildNavigation(IBranchPart branch, IBranchPart sourceChild, String navReqType, boolean sequential) {
        int numRight = this.getRadialData(branch).getNumRight();
        int index = sourceChild.getBranchIndex();
        int num = branch.getSubBranches().size();
        if ("navigate_up".equals(navReqType)) {
            if (index == 0) {
                return this.getSubTopicPart(branch, num - 1);
            }
            if (index == numRight - 1) {
                return this.getSubTopicPart(branch, index - 1);
            }
            if (index == numRight) {
                return this.getSubTopicPart(branch, index + 1);
            }
            if (index > numRight) {
                if (index == num - 1) {
                    return this.getSubTopicPart(branch, 0);
                }
                return this.getSubTopicPart(branch, index + 1);
            }
            return this.getSubTopicPart(branch, index - 1);
        }
        if ("navigate_down".equals(navReqType)) {
            if (index == 0) {
                return this.getSubTopicPart(branch, index + 1);
            }
            if (index == numRight - 1) {
                return this.getSubTopicPart(branch, index + 1);
            }
            if (index == numRight) {
                return this.getSubTopicPart(branch, index - 1);
            }
            if (index > numRight) {
                return this.getSubTopicPart(branch, index - 1);
            }
            return this.getSubTopicPart(branch, index + 1);
        }
        if (!sequential) {
            if ("navigate_right".equals(navReqType)) {
                int numFirst = this.getRadialData(branch).getNumRight();
                if (sourceChild.getBranchIndex() >= numFirst) {
                    return branch.getTopicPart();
                }
            } else if ("navigate_left".equals(navReqType)) {
                int numFirst = this.getRadialData(branch).getNumRight();
                if (sourceChild.getBranchIndex() < numFirst) {
                    return branch.getTopicPart();
                }
            }
        }
        return super.calcChildNavigation(branch, sourceChild, navReqType, sequential);
    }

    @Override
    protected int calcInsIndex(IBranchPart branch, ParentSearchKey key, boolean withDisabled) {
        List<IBranchPart> subBranches = branch.getSubBranches();
        if (subBranches.isEmpty()) {
            return withDisabled ? 0 : -1;
        }
        if (branch.isFolded()) {
            return withDisabled ? 0 : -1;
        }
        ITopicPart topic = branch.getTopicPart();
        if (topic == null) {
            return withDisabled ? 0 : -1;
        }
        Point childRef = key.getFigure().getReference();
        Point ref = ((IReferencedFigure)topic.getFigure()).getReference();
        RadialData cache = this.getRadialData(branch);
        int numRight = cache.getNumRight();
        int[] childrenSpacings = cache.getChildrenSpacings();
        int num = subBranches.size();
        boolean right = true;
        Dimension insSize = this.calcInsSize(branch, key);
        int insHeight = insSize.height;
        int startY = ref.y;
        int y = startY - cache.getRightSumSpacing() / 2;
        boolean insRight = this.calcInsSide(branch, ref, key);
        if (insRight) {
            if (numRight == 0) {
                return 0;
            }
            y -= insHeight / 2;
        }
        int ret = 0;
        int i = 0;
        while (i < num) {
            if (i == numRight) {
                y = startY + cache.getLeftSumSpacing() / 2;
                if (!insRight) {
                    y += insHeight / 2;
                }
                right = false;
            }
            IBranchPart subbranch = subBranches.get(i);
            IFigure subFigure = subbranch.getFigure();
            Insets refIns = RadialUtils.getRefInsets(subFigure, right);
            int hint = i < numRight ? y - refIns.top + (refIns.getHeight() + insHeight) / 2 : y + refIns.top - (refIns.getHeight() + insHeight) / 2;
            if (i < numRight) {
                if (insRight && childRef.y < hint) {
                    return ret;
                }
                if (withDisabled || subFigure.isEnabled()) {
                    ++ret;
                }
                if (i == numRight - 1 && childRef.x > ref.x && childRef.y >= hint) {
                    return ret;
                }
            } else {
                if (!insRight && childRef.y > hint) {
                    return ret;
                }
                if (withDisabled || subFigure.isEnabled()) {
                    ++ret;
                }
            }
            y = i < numRight ? (y += childrenSpacings[i]) : (y -= childrenSpacings[i]);
            ++i;
        }
        return withDisabled ? num : -1;
    }

    public Dimension calcInsSize(IBranchPart branch, ParentSearchKey key) {
        return key.getFigure().getSize();
    }

    public boolean calcInsSide(IBranchPart branch, Point branchRef, ParentSearchKey key) {
        Point childRef = key.getFigure().getReference();
        return childRef.x > branchRef.x;
    }
}

