/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.branch;

import java.util.HashSet;
import java.util.Set;
import org.xmind.core.ITopic;
import org.xmind.gef.graphicalpolicy.AbstractGraphicalPolicy;
import org.xmind.gef.graphicalpolicy.IStructure;
import org.xmind.gef.graphicalpolicy.IStyleSelector;
import org.xmind.gef.part.IGraphicalPart;
import org.xmind.gef.part.IPart;
import org.xmind.ui.branch.IBranchHook;
import org.xmind.ui.branch.IBranchPolicy;
import org.xmind.ui.branch.IBranchStructure;
import org.xmind.ui.branch.IBranchStructureExtension;
import org.xmind.ui.internal.branch.BranchPolicyManager;
import org.xmind.ui.internal.branch.DefaultBranchStyleSelector;
import org.xmind.ui.internal.branch.DownStructure;
import org.xmind.ui.internal.branch.IStructureDescriptor;
import org.xmind.ui.internal.branch.LeftStructure;
import org.xmind.ui.internal.branch.RightStructure;
import org.xmind.ui.internal.branch.UpStructure;
import org.xmind.ui.mindmap.IBranchPart;
import org.xmind.ui.mindmap.ICacheManager;
import org.xmind.ui.mindmap.ICacheValueProvider;
import org.xmind.ui.mindmap.ISummaryPart;
import org.xmind.ui.mindmap.MindMapUI;
import org.xmind.ui.tools.IToolHelper;
import org.xmind.ui.util.MindMapUtils;

public abstract class AbstractBranchPolicy
extends AbstractGraphicalPolicy
implements IBranchPolicy,
ICacheValueProvider {
    protected static final String RIGHT_STRUCTURE_ID = "org.xmind.ui.branchStructure.right";
    protected static final String DOWN_STRUCTURE_ID = "org.xmind.ui.branchStructure.down";
    protected static final String UP_STRUCTURE_ID = "org.xmind.ui.branchStructure.up";
    protected static final String LEFT_STRUCTURE_ID = "org.xmind.ui.branchStructure.left";
    protected static IBranchStructure left = null;
    protected static IBranchStructure right = null;
    protected static IBranchStructure up = null;
    protected static IBranchStructure down = null;
    protected BranchPolicyManager manager;
    private String id;
    private Set<IBranchPart> calculationQueue;

    public AbstractBranchPolicy(BranchPolicyManager manager, String id) {
        this.manager = manager;
        this.id = id;
    }

    protected String getPolicyId() {
        return this.id;
    }

    public void activate(IGraphicalPart part) {
        super.activate(part);
        if (part instanceof IBranchPart) {
            this.activateBranch((IBranchPart)part);
        }
    }

    public void deactivate(IGraphicalPart part) {
        if (part instanceof IBranchPart) {
            this.deactivateBranch((IBranchPart)part);
        }
        super.deactivate(part);
    }

    @Override
    public void postDeactivate(IBranchPart branch) {
    }

    protected void activateBranch(IBranchPart branch) {
        ICacheManager cm = MindMapUtils.getCacheManager((IPart)branch);
        if (cm != null) {
            cm.setValueProvider("org.xmind.ui.branchCache.structureId", this);
        }
        this.addHook(branch);
        this.flushStructureCache(branch, true, true);
    }

    protected void deactivateBranch(IBranchPart branch) {
        this.flushStructureCache(branch, true, true);
        this.removeHook(branch);
        ICacheManager cm = MindMapUtils.getCacheManager((IPart)branch);
        if (cm != null) {
            cm.removeValueProvider("org.xmind.ui.branchCache.structureId");
        }
    }

    protected void addHook(IBranchPart branch) {
        IBranchHook hook = this.createHook(branch);
        if (hook != null) {
            hook.hook(branch);
            MindMapUtils.setCache((IPart)branch, "org.xmind.ui.branchCache.branchHook", hook);
        }
    }

    protected abstract IBranchHook createHook(IBranchPart var1);

    protected void removeHook(IBranchPart branch) {
        IBranchHook hook = (IBranchHook)MindMapUtils.getCache((IPart)branch, "org.xmind.ui.branchCache.branchHook");
        if (hook != null) {
            MindMapUtils.flushCache((IPart)branch, "org.xmind.ui.branchCache.branchHook");
            hook.unhook(branch);
        }
    }

    @Override
    public void flushStructureCache(IBranchPart branch, boolean ancestors, boolean descendants) {
        this.flushStructureCache(branch);
        if (ancestors) {
            this.flushParentStructureCache(branch);
        }
        if (descendants) {
            this.flushChildrenStructureCache(branch);
        }
    }

    protected void flushStructureCache(IBranchPart branch) {
        MindMapUtils.flushCache((IPart)branch, "org.xmind.ui.branchCache.structureId");
    }

    protected void flushParentStructureCache(IBranchPart branch) {
        IBranchPart parent = branch.getParentBranch();
        if (parent == null) {
            return;
        }
        String policyId = parent.getBranchPolicyId();
        if (this.getPolicyId().equals(policyId)) {
            parent.getBranchPolicy().flushStructureCache(parent, true, false);
        }
    }

    protected void flushChildrenStructureCache(IBranchPart branch) {
        for (IBranchPart child : branch.getSubBranches()) {
            this.flushChildStructureCache(child);
        }
        for (IBranchPart child : branch.getCalloutBranches()) {
            this.flushChildStructureCache(child);
        }
        for (IBranchPart child : branch.getSummaryBranches()) {
            this.flushChildStructureCache(child);
        }
    }

    protected void flushChildStructureCache(IBranchPart child) {
        String policyId = child.getBranchPolicyId();
        if (this.getPolicyId().equals(policyId)) {
            child.getBranchPolicy().flushStructureCache(child, false, true);
        }
    }

    public IToolHelper getToolHelper(IBranchPart parent, Class<? extends IToolHelper> type) {
        return null;
    }

    @Override
    public boolean isPropertyModifiable(IBranchPart branch, String propertyKey) {
        return this.isPropertyModifiable(branch, propertyKey, null);
    }

    @Override
    public boolean isPropertyModifiable(IBranchPart branch, String propertyKey, String secondaryKey) {
        boolean modifiable = this.internalCheckPropertyModifiability(branch, propertyKey, secondaryKey);
        if (modifiable) {
            modifiable = !this.isUnmodifiableProperty(branch, propertyKey, secondaryKey);
        }
        return modifiable;
    }

    protected abstract boolean isUnmodifiableProperty(IBranchPart var1, String var2, String var3);

    protected boolean internalCheckPropertyModifiability(IBranchPart branch, String propertyKey, String secondaryKey) {
        if ("topicFolded".equals(propertyKey)) {
            return this.isBranchFoldable(branch);
        }
        if ("topicHyperlink".equals(propertyKey)) {
            return this.isHyperlinkModifiable(branch);
        }
        return true;
    }

    protected boolean isHyperlinkModifiable(IBranchPart branch) {
        ITopic t = branch.getTopic();
        String uri = t.getHyperlink();
        if (uri != null) {
            return MindMapUI.getProtocolManager().isHyperlinkModifiable(t, uri);
        }
        return true;
    }

    protected boolean isBranchFoldable(IBranchPart branch) {
        return !branch.isCentral();
    }

    protected IStyleSelector createDefaultStyleSelector() {
        return DefaultBranchStyleSelector.getDefault();
    }

    public IStructure getStructure(IGraphicalPart part) {
        IBranchPart branch = (IBranchPart)part;
        String structureId = (String)MindMapUtils.getCache((IPart)branch, "org.xmind.ui.branchCache.structureId");
        return this.getStructureAlgorithmById(part, structureId);
    }

    private IStructure getStructureAlgorithmById(IGraphicalPart part, String structureId) {
        if (structureId != null) {
            IStructureDescriptor structureDescriptor = this.manager.getStructureDescriptor(structureId);
            if (structureDescriptor != null) {
                return structureDescriptor.getAlgorithm();
            }
            IBranchStructure sa = this.getPredefinedStructure(structureId);
            if (sa != null) {
                return sa;
            }
        }
        return super.getStructure(part);
    }

    @Override
    public Object getValue(IPart part, String key) {
        IBranchPart branch = (IBranchPart)part;
        if ("org.xmind.ui.branchCache.structureId".equals(key)) {
            return this.calculateStructureAlgorithmId(branch);
        }
        return null;
    }

    protected String calculateStructureAlgorithmId(IBranchPart branch) {
        IBranchPart parent = branch.getParentBranch();
        if (parent != null && parent.getSummaryBranches().contains(branch)) {
            return this.calcSummaryBranchStructureType(branch, parent);
        }
        if (this.isCalculatingOn(branch)) {
            return this.getDefaultStructureId();
        }
        this.startCalculationOn(branch);
        String structureId = this.calcAdditionalStructureId(branch, parent);
        this.endCalculationOn(branch);
        if (structureId != null) {
            return structureId;
        }
        return this.getDefaultStructureId();
    }

    protected abstract String calcAdditionalStructureId(IBranchPart var1, IBranchPart var2);

    private String calcSummaryBranchStructureType(IBranchPart branch, IBranchPart parent) {
        IStructure sa;
        ISummaryPart summary = MindMapUtils.findAttachedSummary(parent, branch);
        if (summary != null && (sa = parent.getBranchPolicy().getStructure(parent)) instanceof IBranchStructureExtension) {
            int direction = ((IBranchStructureExtension)sa).getSummaryDirection(parent, summary);
            if (direction == 8) {
                return LEFT_STRUCTURE_ID;
            }
            if (direction == 1) {
                return UP_STRUCTURE_ID;
            }
            if (direction == 4) {
                return DOWN_STRUCTURE_ID;
            }
        }
        return RIGHT_STRUCTURE_ID;
    }

    protected boolean isCalculatingOn(IBranchPart branch) {
        return this.calculationQueue != null && this.calculationQueue.contains(branch);
    }

    protected void startCalculationOn(IBranchPart branch) {
        if (this.calculationQueue == null) {
            this.calculationQueue = new HashSet<IBranchPart>();
        }
        this.calculationQueue.add(branch);
    }

    protected void endCalculationOn(IBranchPart branch) {
        if (this.calculationQueue == null) {
            return;
        }
        this.calculationQueue.remove(branch);
        if (this.calculationQueue.isEmpty()) {
            this.calculationQueue = null;
        }
    }

    protected IBranchStructure getPredefinedStructure(String structureId) {
        if (LEFT_STRUCTURE_ID.equals(structureId)) {
            if (left == null) {
                left = new LeftStructure();
            }
            return left;
        }
        if (RIGHT_STRUCTURE_ID.equals(structureId)) {
            if (right == null) {
                right = new RightStructure();
            }
            return right;
        }
        if (UP_STRUCTURE_ID.equals(structureId)) {
            if (up == null) {
                up = new UpStructure();
            }
            return up;
        }
        if (DOWN_STRUCTURE_ID.equals(structureId)) {
            if (down == null) {
                down = new DownStructure();
            }
            return down;
        }
        return null;
    }

    protected abstract String getDefaultStructureId();
}

