/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.actions;

import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.Separator;
import org.eclipse.ui.actions.CompoundContributionItem;
import org.eclipse.ui.internal.WorkbenchPlugin;
import org.eclipse.ui.menus.CommandContributionItem;
import org.eclipse.ui.menus.CommandContributionItemParameter;
import org.eclipse.ui.menus.IWorkbenchContribution;
import org.eclipse.ui.services.IServiceLocator;
import org.xmind.ui.editor.IEditorHistory;
import org.xmind.ui.editor.IEditorHistoryItem;

public class RecentFileListContributionItem
extends CompoundContributionItem
implements IWorkbenchContribution {
    private static final int MAX_SIZE = 5;
    private IServiceLocator serviceLocator;

    public RecentFileListContributionItem() {
    }

    public RecentFileListContributionItem(String id) {
        super(id);
    }

    protected IContributionItem[] getContributionItems() {
        ArrayList<IContributionItem> items = new ArrayList<IContributionItem>();
        this.fillItems(items);
        IContributionItem[] itemArray = new IContributionItem[items.size()];
        items.toArray(itemArray);
        return itemArray;
    }

    private void fillItems(List<IContributionItem> items) {
        if (this.serviceLocator == null) {
            return;
        }
        IEditorHistory editorHistory = (IEditorHistory)this.serviceLocator.getService(IEditorHistory.class);
        if (editorHistory == null) {
            return;
        }
        URI[] pinnedInputURIs = editorHistory.getPinnedInputURIs();
        int pinnedItensToShow = Math.min(pinnedInputURIs.length, 5);
        int unpinnedItemsToShow = WorkbenchPlugin.getDefault().getPreferenceStore().getInt("RECENT_FILES");
        URI[] unpinnedInputURIs = editorHistory.getUnpinnedInputURIs(unpinnedItemsToShow);
        unpinnedItemsToShow = Math.min(5, unpinnedInputURIs.length);
        URI[] inputURIs = new URI[pinnedItensToShow + unpinnedItemsToShow];
        System.arraycopy(pinnedInputURIs, 0, inputURIs, 0, pinnedItensToShow);
        System.arraycopy(unpinnedInputURIs, 0, inputURIs, pinnedItensToShow, Math.min(unpinnedItemsToShow, unpinnedInputURIs.length));
        int index = 0;
        while (index < inputURIs.length) {
            URI inputURI = inputURIs[index];
            IEditorHistoryItem item = editorHistory.getItem(inputURI);
            items.add(this.makeHistoryCommandItem(inputURI, index, item.getName()));
            ++index;
        }
        if (items.size() > 0) {
            items.add((IContributionItem)new Separator());
        }
    }

    private IContributionItem makeHistoryCommandItem(URI item, int index, String label) {
        String indexStr = Integer.toString(index + 1);
        String id = "org.xmind.ui.file.recent." + indexStr;
        CommandContributionItemParameter parameter = new CommandContributionItemParameter(this.serviceLocator, id, "org.xmind.ui.command.openWorkbook", 8);
        if (label == null) {
            label = item.toString();
        }
        parameter.label = String.format("&%s %s", indexStr, label);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("org.xmind.ui.command.openWorkbook.uri", item.toString());
        parameter.parameters = params;
        return new CommandContributionItem(parameter);
    }

    public void initialize(IServiceLocator serviceLocator) {
        this.serviceLocator = serviceLocator;
    }
}

