/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.actions;

import org.eclipse.jface.action.ContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.menus.IWorkbenchContribution;
import org.eclipse.ui.services.IServiceLocator;
import org.xmind.core.ISheet;
import org.xmind.gef.ui.editor.IGraphicalEditorPage;
import org.xmind.ui.internal.MindMapUIPlugin;
import org.xmind.ui.internal.actions.AllowManualLayoutAction;
import org.xmind.ui.internal.editor.MindMapEditor;

public class AllowManualLayoutMenu
extends ContributionItem
implements IWorkbenchContribution {
    private boolean dirty = true;
    IWorkbenchWindow window;
    private IMenuListener menuListener = new IMenuListener(){

        public void menuAboutToShow(IMenuManager manager) {
            manager.markDirty();
            AllowManualLayoutMenu.this.dirty = true;
        }
    };

    public boolean isDynamic() {
        return true;
    }

    public void fill(Menu menu, int index) {
        if (this.getParent() instanceof MenuManager) {
            ((MenuManager)this.getParent()).addMenuListener(this.menuListener);
        }
        if (!this.dirty) {
            return;
        }
        MenuManager manager = new MenuManager();
        this.fillMenu(manager);
        IContributionItem[] items = manager.getItems();
        if (items.length > 0) {
            int i = 0;
            while (i < items.length) {
                items[i].fill(menu, index++);
                ++i;
            }
        }
        this.dirty = false;
    }

    public void fillMenu(MenuManager menuManager) {
        IGraphicalEditorPage page;
        IPreferenceStore prefStore = MindMapUIPlugin.getDefault().getPreferenceStore();
        AllowManualLayoutAction allowManualLayoutAction = new AllowManualLayoutAction(prefStore);
        IWorkbenchPart part = this.window.getActivePage().getActivePart();
        if (part == null || !(part instanceof MindMapEditor)) {
            allowManualLayoutAction.setEnabled(false);
        } else if (part instanceof MindMapEditor && (page = ((MindMapEditor)part).getActivePageInstance()) != null) {
            ISheet sheet = (ISheet)page.getAdapter(ISheet.class);
            String structureClass = sheet.getRootTopic().getStructureClass();
            allowManualLayoutAction.setEnabled(structureClass == null || structureClass.contains("org.xmind.ui.map"));
        }
        menuManager.add((IAction)allowManualLayoutAction);
    }

    public void initialize(IServiceLocator serviceLocator) {
        this.window = (IWorkbenchWindow)serviceLocator.getService(IWorkbenchWindow.class);
    }
}

