/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.eclipse.ui.internal.registry.RegistryReader;
import org.xmind.ui.internal.InfoItemContributorProxy;
import org.xmind.ui.mindmap.IInfoItemContributor;
import org.xmind.ui.util.Logger;

public class InfoItemContributorManager
extends RegistryReader {
    private static final InfoItemContributorManager instance = new InfoItemContributorManager();
    public static final String LABEL_ID = "org.xmind.ui.infoItem.label";
    public static final String NOTES_ID = "org.xmind.ui.infoItem.notes";
    public static final String HYPERLINK_ID = "org.xmind.ui.infoItem.hyperlink";
    public static final String TASKINFO_ID = "org.xmind.ui.infoItem.taskInfo";
    private List<IInfoItemContributor> contributors = null;
    private List<IInfoItemContributor> bothContributors = null;

    private InfoItemContributorManager() {
    }

    public List<IInfoItemContributor> getContributors() {
        this.ensureLoaded();
        return this.contributors;
    }

    public List<IInfoItemContributor> getBothContributors() {
        return this.bothContributors;
    }

    private void ensureLoaded() {
        if (this.contributors != null && this.bothContributors != null) {
            return;
        }
        this.lazyLoad();
        if (this.contributors == null) {
            this.contributors = Collections.emptyList();
        }
        if (this.bothContributors == null) {
            this.bothContributors = Collections.emptyList();
        }
    }

    private void lazyLoad() {
        if (Platform.isRunning()) {
            this.readRegistry(Platform.getExtensionRegistry(), "org.xmind.ui", "infoItems");
        }
    }

    protected boolean readElement(IConfigurationElement element) {
        String name = element.getName();
        if ("infoItem".equals(name)) {
            this.readInfoItem(element);
            return true;
        }
        return false;
    }

    private void readInfoItem(IConfigurationElement element) {
        InfoItemContributorProxy contributor;
        try {
            contributor = new InfoItemContributorProxy(element);
        }
        catch (CoreException e) {
            Logger.log(e, "Failed to load info item: " + element);
            return;
        }
        String modes = contributor.getAvailableModes();
        if (modes.contains("icon") && modes.contains("card")) {
            if (this.bothContributors == null) {
                this.bothContributors = new ArrayList<IInfoItemContributor>();
            }
            this.bothContributors.add(contributor);
        } else {
            if (this.contributors == null) {
                this.contributors = new ArrayList<IInfoItemContributor>();
            }
            this.contributors.add(contributor);
        }
    }

    public static InfoItemContributorManager getInstance() {
        return instance;
    }
}

