/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.core.net.util;

public class LinkUtils {
    public static final String HOST_NET = "www.xmind.net";
    public static final String HOST_CN = "www.xmind.cn";
    private static final String LANGUAGE_OSGI_NL_KEY = "osgi.nl";
    private static final String LANGUAGE_KEY_CN = "zh_CN";

    public static boolean isCnLanguage() {
        String lang = System.getProperty(LANGUAGE_OSGI_NL_KEY);
        return LANGUAGE_KEY_CN.equals(lang);
    }

    public static String getHostByLanguage(boolean protocol, boolean https) {
        String host;
        String string = host = LinkUtils.isCnLanguage() ? HOST_CN : HOST_NET;
        if (protocol) {
            host = https ? "https://" + host : "http://" + host;
        }
        return host;
    }

    public static String getHostByUser(boolean isCnUser, boolean protocol, boolean https) {
        String host;
        String string = host = isCnUser ? HOST_CN : HOST_NET;
        if (protocol) {
            host = https ? "https://" + host : "http://" + host;
        }
        return host;
    }

    public static String getLinkByLanguage(boolean protocol, boolean https, String api) {
        return String.valueOf(LinkUtils.getHostByLanguage(protocol, https)) + (api == null ? "" : api);
    }

    public static String getLinkByUser(boolean isCnUser, boolean protocol, boolean https, String api) {
        return String.valueOf(LinkUtils.getHostByUser(isCnUser, protocol, https)) + (api == null ? "" : api);
    }

    private LinkUtils() {
    }
}

