/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.cathy.internal.renderer;

import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.eclipse.e4.ui.model.application.ui.MElementContainer;
import org.eclipse.e4.ui.model.application.ui.MUIElement;
import org.eclipse.e4.ui.model.application.ui.advanced.MPlaceholder;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.e4.ui.model.application.ui.basic.MPartStack;
import org.eclipse.e4.ui.model.application.ui.basic.MStackElement;
import org.eclipse.e4.ui.workbench.IPresentationEngine;
import org.eclipse.e4.ui.workbench.renderers.swt.LazyStackRenderer;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;

public class XStackRenderer
extends LazyStackRenderer {
    @Inject
    private IPresentationEngine renderer;
    @Inject
    private IEventBroker eventBroker;

    public Object createWidget(MUIElement element, Object parent) {
        int styleOverride;
        if (!(element instanceof MPartStack) || !(parent instanceof Composite)) {
            return null;
        }
        MPartStack viewStack = (MPartStack)element;
        Composite parentComposite = (Composite)parent;
        Composite viewContainer = null;
        if (element.getElementId() == null || element.getElementId().length() == 0) {
            String generatedId = "RightStack@" + Integer.toHexString(element.hashCode());
            element.setElementId(generatedId);
        }
        int style = (styleOverride = this.getStyleOverride((MUIElement)viewStack)) == -1 ? 0 : styleOverride;
        viewContainer = new Composite(parentComposite, style);
        viewContainer.setLayout((Layout)new StackLayout());
        this.bindWidget(element, viewContainer);
        return viewContainer;
    }

    protected void showTab(MUIElement element) {
        super.showTab(element);
        if (element instanceof MPartStack && element.getRenderer() == this) {
            MPartStack stackModel = (MPartStack)element;
            MUIElement curSel = stackModel.getSelectedElement();
            MPart part = (MPart)(curSel instanceof MPlaceholder ? ((MPlaceholder)curSel).getRef() : curSel);
            if (curSel instanceof MPlaceholder) {
                part.setCurSharedRef((MPlaceholder)curSel);
            }
        }
        if (!element.isVisible()) {
            return;
        }
        Composite viewContainer = (Composite)this.getParentWidget(element);
        Control ctrl = (Control)element.getWidget();
        if (ctrl != null && ctrl.getParent() != viewContainer) {
            ctrl.setParent(viewContainer);
        } else if (ctrl == null) {
            this.renderer.createGui(element);
        }
        ctrl = (Control)element.getWidget();
        if (ctrl instanceof Composite) {
            ((Composite)ctrl).layout(false, true);
        }
        ((StackLayout)viewContainer.getLayout()).topControl = ctrl;
        viewContainer.layout(true, true);
    }

    public void childRendered(MElementContainer<MUIElement> parentElement, MUIElement element) {
        super.childRendered(parentElement, element);
        if (!(parentElement instanceof MPartStack) || !(element instanceof MStackElement)) {
            return;
        }
        this.showTab(element);
    }

    @PostConstruct
    public void init() {
        super.init(this.eventBroker);
    }

    @PreDestroy
    public void contextDisposed() {
        super.contextDisposed(this.eventBroker);
    }
}

