/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.cathy.internal.jobs;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jface.util.SafeRunnable;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IWorkbench;
import org.xmind.cathy.internal.WorkbenchMessages;
import org.xmind.cathy.internal.jobs.AbstractCheckFilesJob;
import org.xmind.cathy.internal.jobs.OpenXMindCommandFileJob;
import org.xmind.core.Core;
import org.xmind.core.IWorkbook;
import org.xmind.core.command.Command;
import org.xmind.core.command.CommandJob;
import org.xmind.core.command.ICommand;
import org.xmind.core.util.FileUtils;
import org.xmind.ui.internal.MarkerImpExpUtils;
import org.xmind.ui.internal.imports.freemind.FreeMindImporter;
import org.xmind.ui.internal.imports.mm.MindManagerImporter;
import org.xmind.ui.mindmap.MindMapUI;
import org.xmind.ui.util.PrefUtils;

public class OpenFilesJob
extends AbstractCheckFilesJob {
    private List<String> filesToOpen;
    private boolean markersImported = false;
    private List<String> commandFilesToOpen = new ArrayList<String>(1);

    public OpenFilesJob(IWorkbench workbench, String jobName) {
        super(workbench, jobName);
        this.filesToOpen = new ArrayList<String>();
    }

    public OpenFilesJob(IWorkbench workbench, String jobName, Collection<String> files) {
        super(workbench, jobName);
        this.filesToOpen = new ArrayList<String>(files);
    }

    @Override
    protected void prepare() {
        this.markersImported = false;
        super.prepare();
    }

    @Override
    protected void finish() {
        this.filesToOpen.clear();
        this.markersImported = false;
        super.finish();
    }

    protected IStatus run(IProgressMonitor monitor) {
        monitor.beginTask(null, this.getTotalSteps());
        this.doCheckAndOpenFiles(monitor);
        monitor.done();
        return Status.OK_STATUS;
    }

    protected int getTotalSteps() {
        return 4;
    }

    protected void doCheckAndOpenFiles(IProgressMonitor monitor) {
        this.filterFilesToOpen(this.filesToOpen, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
        if (this.filesToOpen.isEmpty()) {
            monitor.worked(2);
        } else {
            this.addEditors((IProgressMonitor)new SubProgressMonitor(monitor, 1));
            this.openEditors(monitor, WorkbenchMessages.CheckOpenFilesJob_OpenFiles_name, 1, true);
        }
        this.onFilsOpened((IProgressMonitor)new SubProgressMonitor(monitor, 1));
    }

    protected void onFilsOpened(IProgressMonitor monitor) {
        monitor.beginTask(null, 1);
        if (this.markersImported) {
            this.showMarkersPrefPage();
        }
        if (!this.commandFilesToOpen.isEmpty()) {
            this.openXMindCommandFiles();
        }
        monitor.done();
    }

    protected void filterFilesToOpen(List<String> filesToOpen, IProgressMonitor monitor) {
        monitor.beginTask(null, 1);
        monitor.done();
    }

    protected void addEditors(final IProgressMonitor monitor) {
        monitor.beginTask(WorkbenchMessages.CheckOpenFilesJob_OpenFiles_name, this.filesToOpen.size());
        for (final String fileName : this.filesToOpen) {
            SafeRunner.run((ISafeRunnable)new SafeRunnable(NLS.bind((String)WorkbenchMessages.CheckOpenFilesJob_FailsToOpen_message, (Object)fileName)){

                public void run() throws Exception {
                    monitor.subTask(fileName);
                    IEditorInput input = OpenFilesJob.this.createEditorInput(fileName, monitor);
                    if (input != null) {
                        OpenFilesJob.this.addEditorToOpen(input);
                    }
                    monitor.worked(1);
                }
            });
        }
        monitor.done();
    }

    protected IEditorInput createEditorInput(String fileName, IProgressMonitor monitor) throws Exception {
        Command command = Command.parseURI((String)fileName);
        if (command != null) {
            new CommandJob((ICommand)command, null).schedule();
            return null;
        }
        String path = fileName;
        String extension = FileUtils.getExtension((String)path);
        if (".xmind-command".equalsIgnoreCase(extension)) {
            return this.openXMindCommandFile(path);
        }
        if (".xmt".equalsIgnoreCase(extension)) {
            return this.newFromTemplate(path, fileName);
        }
        if (".mmap".equalsIgnoreCase(extension)) {
            return this.importMindManagerFile(path, fileName);
        }
        if (".mm".equalsIgnoreCase(extension)) {
            return this.importFreeMindFile(path, fileName);
        }
        if (".xmp".equalsIgnoreCase(extension)) {
            return this.importMarkers(path);
        }
        if (new File(path).exists()) {
            return MindMapUI.getEditorInputFactory().createEditorInputForFile(new File(path));
        }
        IWorkbook workbook = Core.getWorkbookBuilder().loadFromPath(path);
        return workbook == null ? null : MindMapUI.getEditorInputFactory().createEditorInputForPreLoadedWorkbook(workbook, fileName);
    }

    protected IEditorInput newFromTemplate(String path, String fileName) throws Exception {
        IWorkbook workbook = Core.getWorkbookBuilder().loadFromPath(path);
        return workbook == null ? null : MindMapUI.getEditorInputFactory().createEditorInputForPreLoadedWorkbook(workbook, fileName);
    }

    protected IEditorInput importMindManagerFile(String path, String fileName) throws Exception {
        MindManagerImporter importer = new MindManagerImporter(path);
        importer.build();
        IWorkbook workbook = importer.getTargetWorkbook();
        return workbook == null ? null : MindMapUI.getEditorInputFactory().createEditorInputForPreLoadedWorkbook(workbook, fileName);
    }

    protected IEditorInput importFreeMindFile(String path, String fileName) throws Exception {
        FreeMindImporter importer = new FreeMindImporter(path);
        importer.build();
        IWorkbook workbook = importer.getTargetWorkbook();
        return workbook == null ? null : MindMapUI.getEditorInputFactory().createEditorInputForPreLoadedWorkbook(workbook, fileName);
    }

    protected IEditorInput importMarkers(String path) throws Exception {
        MarkerImpExpUtils.importMarkerPackage((String)path);
        this.markersImported = true;
        return null;
    }

    private void showMarkersPrefPage() {
        Display display = this.getWorkbench().getDisplay();
        if (display == null || display.isDisposed()) {
            return;
        }
        display.asyncExec(new Runnable(){

            @Override
            public void run() {
                PrefUtils.openPrefDialog(null, (String)"org.xmind.ui.MarkersPrefPage");
            }
        });
    }

    private IEditorInput openXMindCommandFile(String path) {
        this.commandFilesToOpen.add(path);
        return null;
    }

    private void openXMindCommandFiles() {
        for (String path : this.commandFilesToOpen) {
            new OpenXMindCommandFileJob(path).schedule(500L);
        }
    }
}

