/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.cathy.internal.css;

import org.eclipse.e4.ui.css.core.dom.properties.ICSSPropertyHandler;
import org.eclipse.e4.ui.css.core.engine.CSSEngine;
import org.eclipse.e4.ui.css.swt.properties.AbstractCSSPropertySWTHandler;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.w3c.dom.Element;
import org.w3c.dom.css.CSSStyleDeclaration;
import org.w3c.dom.css.CSSValue;

public class CSSPropertyMaxMinVisibleSWTHandler
extends AbstractCSSPropertySWTHandler {
    public static final ICSSPropertyHandler INSTANCE = new CSSPropertyMaxMinVisibleSWTHandler();
    private static final String CSS_CTABFOLDER_MAXMIN_VISIBLE_LISTENER_KEY = "CSS_CTABFOLDER_MAXMIN_VISIBLE_LISTENER_KEY";

    public void applyCSSProperty(Control control, String property, CSSValue value, String pseudo, CSSEngine engine) throws Exception {
        if (!(control instanceof CTabFolder)) {
            return;
        }
        CTabFolder folder = (CTabFolder)control;
        boolean visible = (Boolean)engine.convert(value, Boolean.class, null);
        ShowMaxMinVisibleListener listener = (ShowMaxMinVisibleListener)folder.getData(CSS_CTABFOLDER_MAXMIN_VISIBLE_LISTENER_KEY);
        if (listener == null) {
            listener = new ShowMaxMinVisibleListener(engine);
            folder.addListener(9, (Listener)listener);
            folder.setData(CSS_CTABFOLDER_MAXMIN_VISIBLE_LISTENER_KEY, (Object)listener);
        } else {
            listener.setEngine(engine);
        }
        if ("xmind-swt-maximize-visible".equals(property)) {
            folder.setMaximizeVisible(visible);
        } else if ("xmind-swt-minimize-visible".equals(property)) {
            folder.setMinimizeVisible(visible);
        }
    }

    public String retrieveCSSProperty(Control control, String property, String pseudo, CSSEngine engine) throws Exception {
        if (control instanceof CTabFolder) {
            CTabFolder folder = (CTabFolder)control;
            if ("xmind-swt-maximize-visible".equals(property)) {
                return Boolean.toString(folder.getMaximizeVisible());
            }
            if ("xmind-swt-minimize-visible".equals(property)) {
                return Boolean.toString(folder.getMinimizeVisible());
            }
        }
        return null;
    }

    private class ShowMaxMinVisibleListener
    implements Listener {
        private CSSEngine engine;

        public ShowMaxMinVisibleListener(CSSEngine engine) {
            this.engine = engine;
        }

        public void setEngine(CSSEngine engine) {
            this.engine = engine;
        }

        public void handleEvent(Event e) {
            CTabFolder folder = (CTabFolder)e.widget;
            if (folder == null || folder.isDisposed()) {
                return;
            }
            Element element = this.engine.getElement((Object)folder);
            CSSStyleDeclaration style = this.engine.getViewCSS().getComputedStyle(element, null);
            if (style != null) {
                boolean miniVisible;
                boolean maxVisible;
                CSSValue maximizeVisible = style.getPropertyCSSValue("xmind-swt-maximize-visible");
                CSSValue minimizeVisible = style.getPropertyCSSValue("xmind-swt-minimize-visible");
                if (maximizeVisible != null && (maxVisible = Boolean.parseBoolean(maximizeVisible.getCssText())) != folder.getMaximizeVisible()) {
                    folder.setMaximizeVisible(maxVisible);
                }
                if (minimizeVisible != null && (miniVisible = Boolean.parseBoolean(minimizeVisible.getCssText())) != folder.getMinimizeVisible()) {
                    folder.setMinimizeVisible(miniVisible);
                }
            }
        }
    }
}

